<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       dmConfirm.jsp
 *
 *      NOTES
 *       jsp launched from various Data Masking page for a confirmation
 *       of an action to be taken.  The bean name is 'dmConfirmBean'
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    xshen      03/11/07 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg" class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

        <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

            <uix:header iconBinding="confirmationIcon@dmConfirmBean@servletRequest" 
			textBinding="CONFIRMATION@dbUIMsg">
              <uix:tableLayout width="100%">
	        <uix:rowLayout width="100%" vAlign="bottom">
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                       textBinding="mainConfirmationStr@dmConfirmBean@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>

            <uix:spacer height="20"/>

            <!-- Yes and No Buttons -->
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="NO@dbUIMsg"
                            shortDescBinding="NO@dbUIMsg"
                            destinationBinding="actNoDest@dmConfirmBean@servletRequest"/>
                <uix:button textBinding="YES@dbUIMsg"
                            shortDescBinding="YES@dbUIMsg"
                            destinationBinding="actYesDest@dmConfirmBean@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
