<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       dmImpExp.jsp
 *
 *      NOTES
 *       Import Export page launched from Data Masking pages.
 *       The bean name is 'dmImpExpBean'
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    xshen      02/21/08 - fix export cause page freeze
 *    xshen      06/25/07 - ui changes
 *    xshen      06/18/07 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg" class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@dmImpExpBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="impExpForm" 
               method="POST" 
               usesUpload="true" 
               destinationBinding="impExpDestination@dmImpExpBean@servletRequest"
               copyParams="target,type">
      <uix:formValue name="pageName" value="/database/masking/dmImpExp"/>
      
        <uix:pageLayout titleBinding="pageTitle@dmImpExpBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

        <!-- Messaging Area -->
        <%@ include file="/database/masking/dmMsging.jspf" %>   

            <uix:spacer height="10"/>
               
            <uix:tableLayout width="90%">
               <!-- Instruction Txt -->            
	       <uix:rowLayout width="100%">
                  <uix:styledText styleClass="OraInstructionText" 
                                  textBinding="pageInstruction@dmImpExpBean@servletRequest"/>
               </uix:rowLayout>
            </uix:tableLayout>
            
            <uix:tableLayout width="90%" renderedBinding="import@dmImpExpBean@servletRequest">
               <uix:rowLayout>
                  <uix:spacer height="10"/>
               </uix:rowLayout>
               <uix:rowLayout width="100%">       
                  <uix:messageFileUpload promptBinding="FILE@dmUIMsg" 
                                         columns="60"
                                         name="fileName"
                                         id="fileName"/>
               </uix:rowLayout>               
            </uix:tableLayout>
            
            <uix:spacer height="20"/>

            <!-- Cancel and Action Buttons -->
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@dbUIMsg"
                                  shortDescBinding="CANCEL@dbUIMsg"
                                  name="event" 
                                  value="cancelImpExp"/>

                <uix:submitButton renderedBinding="export@dmImpExpBean@servletRequest"
                                  textBinding="actionButtonText@dmImpExpBean@servletRequest"
                                  shortDescBinding="actionButtonText@dmImpExpBean@servletRequest"                           
                                  name="event" 
                                  value="exportMetadata"/>

                <uix:submitButton renderedBinding="import@dmImpExpBean@servletRequest"
                                  textBinding="actionButtonText@dmImpExpBean@servletRequest"
                                  shortDescBinding="actionButtonText@dmImpExpBean@servletRequest"
                                  name="event" 
                                  value="importMetadata"/>                           
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
