<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       manageRuleTemplate.jsp
 *
 *      NOTES
 *       Launched from 'Rule Templates Library' page. 
 *
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    11/26/08 - Implement initial input focus
 *    kmckeen    11/21/08 - Handle new format types for format library
 *    xshen      07/02/07 - use corrected msgs
 *    xshen      03/07/07 - ui changes
 *    xshen      09/13/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg" class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@ruleTemplateBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].templateName.focus()">
      <db:form name="manageTemplateForm" 
               method="POST"
               destinationBinding="ruleTemplateDest@ruleTemplateBean@servletRequest"
               copyParams="target,type,rule_guid">
      <uix:formValue name="pageName" value="/database/masking/manageRuleTemplate"/>

        <uix:pageLayout 
             titleBinding="titleString@ruleTemplateBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

            <uix:rowLayout>
              <uix:spacer height="6"/>
            </uix:rowLayout>

            <uix:labeledFieldLayout labelWidth="28%" width="80%" renderedBinding="editable@ruleTemplateBean@servletRequest">
	       <uix:contents>
                    <uix:messageTextInput
                         shortDescBinding="NAME@dmUIMsg"
                         promptBinding="NAME@dmUIMsg"
                         id="templateName"
                         name="templateName"
                         columns="60"
                         required="uiOnly"
                         maximumLength="40"
                         textBinding="templateName@ruleTemplateBean@servletRequest"/>
	            <uix:messageTextInput
                         promptBinding="DESCRIPTION@dmUIMsg"
                         shortDescBinding="DESCRIPTION@dmUIMsg"
                         name="templateDesc"
			 maximumLength="2000"
                         columns="60"
                         textBinding="templateDesc@ruleTemplateBean@servletRequest"/>
               </uix:contents>
            </uix:labeledFieldLayout>

            <uix:labeledFieldLayout labelWidth="28%" width="80%" 
                 renderedBinding="viewMode@ruleTemplateBean@servletRequest">
	       <uix:contents>
                    <uix:messagePrompt promptBinding="NAME@dmUIMsg"/>
                    <uix:styledText styleClass="OraDataText" 
                         textBinding="templateName@ruleTemplateBean@servletRequest"/>
	            <uix:messagePrompt 
                         promptBinding="DESCRIPTION@dmUIMsg"/>
                    <uix:styledText styleClass="OraDataText" 
                         textBinding="templateDesc@ruleTemplateBean@servletRequest"/>
               </uix:contents>
            </uix:labeledFieldLayout>

            <uix:spacer height="4"/>
            <uix:separator/>
            <uix:spacer height="4"/>

         <uix:header textBinding="FORMAT_ENTRIES@dmUIMsg"> 

            <uix:rowLayout renderedBinding="editable@ruleTemplateBean@servletRequest" width="100%">
              <uix:messagePrompt promptBinding="DEFINE_LIB_FORMAT_INSTRUCTION_STRING@dmUIMsg"/>
            </uix:rowLayout>

            <uix:spacer renderedBinding="editable@ruleTemplateBean@servletRequest" height="5"/>

            <uix:tableLayout renderedBinding="editable@ruleTemplateBean@servletRequest" width="80%">
              <uix:contents>
                <uix:rowLayout hAlign="right">
                  <uix:cellFormat wrappingDisabled="true" vAlign="top">
                    <uix:contents>
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:messageChoice 
                            shortDescBinding="RULE_TYPE@dmUIMsg"
                            name="ruleType" 
                            promptBinding="ADD@dmUIMsg"
                            onChangeBinding="onChangeFormatTypeDest@ruleTemplateBean@servletRequest"                            
                            selectedValueBinding="selectedRuleType@ruleTemplateBean@servletRequest">
                             <uix:contents childDataBinding="ruleTypes@ruleTemplateBean@servletRequest">
                               <uix:option textBinding="text" valueBinding="value"/>
                             </uix:contents>
                          </uix:messageChoice>
                          <uix:submitButton name="event"
                                  value="addRuleEntry"
                                  shortDescBinding="GO@dbUIMsg"
                                  disabledBinding="isNonParameterFormatTypeSelected@ruleTemplateBean@servletRequest"
                                  textBinding="GO@dbUIMsg"/>
                          <uix:spacer width="2"/>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>

<!-- Format Entries Table -->
<uix:stackLayout renderedBinding="renderEditableEntries@ruleTemplateBean@servletRequest">
  <uix:contents>
          <uix:table              
             summaryBinding="CONFIGURE_RULE@dmUIMsg"
             partialRenderMode="self"
             id="ruleEntriesTable"
             name="ruleEntriesTable"
             alternateTextBinding="NO_ENTRIES@dmUIMsg"
             formSubmitted="true"
             width="80%"
             valueBinding="ruleEntriesValue@ruleTemplateBean@servletRequest"
             maxValueBinding="ruleEntriesMaxValue@ruleTemplateBean@servletRequest"
             blockSize="25"
             tableDataBinding="ruleEntriesTable@ruleTemplateBean@servletRequest">
   
            <uix:tableFormat tableBanding="rowBanding"/>
              <uix:contents>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="TYPE@dmUIMsg"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                  <uix:contents>
                    <uix:styledText textBinding="RULE_TYPE"/>    
                  </uix:contents>
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="DESCRIPTION@dmUIMsg"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" width="60%"/>
                  <uix:contents>
                    <uix:styledText textBinding="DEFINITION_DESCRIPTION"/>    
                  </uix:contents>
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="EDIT@dmUIMsg"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconButtonFormat" width="10%"/>
                  <uix:contents>
                    <uix:image shortDescBinding="EDIT@dmUIMsg"
                           sourceBinding="editRuleIconSource@ruleTemplateBean@servletRequest"
                           onClickBinding="editRuleRowDest@ruleTemplateBean@servletRequest" />    
                  </uix:contents>
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="REMOVE@dmUIMsg"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconButtonFormat" width="10%"/>
                  <uix:contents>
                    <uix:image shortDescBinding="REMOVE@dmUIMsg"
                           sourceBinding="removeRuleIconSource@ruleTemplateBean@servletRequest"
                           onClickBinding="removeRuleRowDest@ruleTemplateBean@servletRequest" />
                  </uix:contents>
                </uix:column>
              </uix:contents>
          </uix:table>
  </uix:contents>
</uix:stackLayout>
  
      <uix:stackLayout>
        <uix:contents>
          <uix:table 
             renderedBinding="renderViewOnlyEntries@ruleTemplateBean@servletRequest"
             summaryBinding="CONFIGURE_RULE@dmUIMsg"
             partialRenderMode="self"
             id="ruleEntriesTable"
             name="ruleEntriesTable"
             alternateTextBinding="NO_ENTRIES@dmUIMsg"
             formSubmitted="true"
             width="80%"
             valueBinding="ruleEntriesValue@ruleTemplateBean@servletRequest"
             maxValueBinding="ruleEntriesMaxValue@ruleTemplateBean@servletRequest"
             blockSize="25"
             tableDataBinding="ruleEntriesTable@ruleTemplateBean@servletRequest">
            <uix:tableFormat tableBanding="rowBanding"/>
              <uix:contents>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="TYPE@dmUIMsg"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" width="40%"/>
                  <uix:contents>
                    <uix:styledText textBinding="RULE_TYPE"/>    
                  </uix:contents>
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="DESCRIPTION@dmUIMsg"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" width="60%"/>
                  <uix:contents>
                    <uix:styledText textBinding="DEFINITION_DESCRIPTION"/>    
                  </uix:contents>
                </uix:column>
              </uix:contents>
          </uix:table>
          <%-- this is not correct - checks for shuffle, but msg is about substring
          <uix:rowLayout renderedBinding="shuffleSelected@ruleTemplateBean@servletRequest">
            <uix:styledText styleClass="OraInlineInfoText" textBinding="SUBSTRING_INFO@dmUIMsg"/>
          </uix:rowLayout>
          --%>
        </uix:contents>
      </uix:stackLayout>
  
          <uix:spacer height="4"/>

          <uix:separator renderedBinding="showPostUdf@ruleTemplateBean@servletRequest" />

          <uix:spacer height="4"/>

        <!-- Post Processing Rule, shown conditionally: getShowPostUdf() -->
        <uix:tableLayout width="100%" renderedBinding="showPostUdf@ruleTemplateBean@servletRequest">

          <uix:rowLayout>
            <uix:spacer height="2"/>
          </uix:rowLayout>

       <uix:switcher childNameBinding="editable@ruleTemplateBean@servletRequest">
         <uix:case name="true">
          <uix:rowLayout width="100%" renderedBinding="disablePostUdf@ruleTemplateBean@servletRequest">
            <uix:styledText styleClass="OraInlineInfoText" textBinding="POST_PROC_DISABLED_TIP@dmUIMsg"/>
          </uix:rowLayout>
         </uix:case>
       </uix:switcher>

          <uix:rowLayout>
            <uix:spacer height="4"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:contents>
               <uix:messageTextInput 
                    disabledBinding="disablePostUdf@ruleTemplateBean@servletRequest"
                    promptBinding="POST_PROCESSING_RULE@dmUIMsg"
                    shortDescBinding="POST_PROCESSING_RULE@dmUIMsg"
                    name="postUDFName"
                    textBinding="postUDFName@ruleTemplateBean@servletRequest"
                    columns="88"
                    tipBinding="POST_UDF_EXAMPLE@dmUIMsg"/>
            </uix:contents>
          </uix:rowLayout>

        </uix:tableLayout>

      </uix:header>

        <!-- Shown Sample: Currently Whenever this page is launched / returned / on change -->
        <uix:header textBinding="SAMPLE_MASKED_DATA@dmUIMsg">

            <uix:rowLayout renderedBinding="editable@ruleTemplateBean@servletRequest">
              <uix:cellFormat width="480" vAlign="top">
                <uix:messagePrompt promptBinding="SAMPLE_MASKED_DATA_INFO@dmUIMsg"/>    
              </uix:cellFormat>
              <uix:cellFormat vAlign="top" width="2">
                <uix:submitButton textBinding="REFRESH@dmUIMsg" name="event" value="showSampleData"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout width="100%">
              <uix:cellFormat vAlign="top" width="106"/>
              <uix:cellFormat wrappingDisabled="true" vAlign="top">
              <uix:switcher childNameBinding="sampleUnvailable@ruleTemplateBean@servletRequest">
               <uix:case name="true">
                <uix:bulletedList>
                  <uix:messagePrompt promptBinding="newSample@ruleTemplateBean@servletRequest"/>
                </uix:bulletedList>
               </uix:case>
               <uix:case name="false">
                <uix:bulletedList>
                  <uix:messagePrompt promptBinding="newSample@ruleTemplateBean@servletRequest"/>
                  <uix:messagePrompt promptBinding="newSample2@ruleTemplateBean@servletRequest"/>
                  <uix:messagePrompt promptBinding="newSample3@ruleTemplateBean@servletRequest"/>
                  <uix:messagePrompt promptBinding="newSample4@ruleTemplateBean@servletRequest"/>
                  <uix:messagePrompt promptBinding="newSample5@ruleTemplateBean@servletRequest"/>
                </uix:bulletedList>
               </uix:case>
              </uix:switcher>
              </uix:cellFormat>
            </uix:rowLayout>
        </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar> 
                <uix:button renderedBinding="editable@ruleTemplateBean@servletRequest"
                     destinationBinding="cancelManageTemplateURL@ruleTemplateBean@servletRequest"
                     shortDescBinding="CANCEL@dbUIMsg"
                     textBinding="CANCEL@dbUIMsg"/>
                <uix:submitButton renderedBinding="editable@ruleTemplateBean@servletRequest"
                     shortDescBinding="OK@dbUIMsg"
                     name="event"
                     value="manageRuleTemplateOk"
                     textBinding="OK@dbUIMsg"/>
                <uix:button renderedBinding="viewMode@ruleTemplateBean@servletRequest"
                     destinationBinding="cancelManageTemplateURL@ruleTemplateBean@servletRequest"
                     shortDescBinding="RETURN@dbUIMsg"
                     textBinding="RETURN@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


