<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       maskingWizAddColumns.jsp
 *
 *      NOTES
 *       Launched from 'Add' on masking page. 
 *
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    11/26/08 - Implement initial input focus
 *    kmckeen    08/18/08 - Implement compound masking
 *    kmckeen    06/26/08 - Implement new workflow
 *    xshen      08/18/07 - remove search selection bean property
 *    xshen      03/10/07 - lov
 *    xshen      12/06/06 - ui changes
 *    xshen      11/13/06 - ui changes
 *    xshen      08/25/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<db:script src="/database/LOV.js"/>  

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg"
            class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].searchColumnsSchema.focus()">
      <db:form name="maskingForm" method="POST"
          destinationBinding="maskingDestination@maskingBean@servletRequest"
          copyParams="target,type">
      <uix:formValue name="pageName" 
                     value="/database/masking/maskingWizAddColumns"/>
      <uix:formValue name="event" value="searchColumns"/>

        <uix:pageLayout 
             titleBinding="titleString@maskingBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="DATABASE@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="target@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"
                      styleClass="OraDataText"
                      textBinding="tgtUser@maskingBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page context information with a separator --%>
            <uix:separator/>

            <uix:rowLayout width="100%">
                 <uix:messagePrompt 
                      promptBinding="SELECT_SEARCH_COLUMNS_INSTRUCTION@dmUIMsg"/>
            </uix:rowLayout>

              <uix:rowLayout width="100%">
                 <uix:spacer height="4"/>
              </uix:rowLayout>


<uix:header textBinding="SEARCH@dbUIMsg">

<uix:rowLayout width="80%">
  <uix:cellFormat width="40%" vAlign="top">
              <uix:labeledFieldLayout labelWidth="30%">
                <uix:contents>
                    <!-- Schema Name -->
                    <uix:messageLovField                                     
                         promptBinding="SCHEMA@dbUIMsg"
                         id="searchColumnsSchema"
                         name="searchColumnsSchema"
                         columns="40"
                         textBinding="searchColumnsSchema@maskingBean@servletRequest"
                         searchDescBinding="CLICK_TO_SELECT_SCHEMA@dmUIMsg"
                         onClick="startLov('searchColumnsSchema','ListSchema')"/>
                    <!-- Table Name -->
                    <uix:messageTextInput                                     
                         promptBinding="TABLE_NAME@dmUIMsg"
                         id="searchColumnsTable"
                         name="searchColumnsTable"
                         columns="40"
                         textBinding="searchColumnsTable@maskingBean@servletRequest"/>
                    <!-- Search Button -->
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton 
                         name="event"
                         value="searchColumns"
                         shortDescBinding="SEARCH@dbUIMsg"
                         textBinding="SEARCH@dbUIMsg"/>

                </uix:contents>
              </uix:labeledFieldLayout>
  </uix:cellFormat>
  <uix:cellFormat vAlign="top">
              <uix:labeledFieldLayout labelWidth="30%">
                <uix:contents>
                    <!-- Column Name -->
                    <uix:messageTextInput                                     
                         promptBinding="COLUMN_NAME@dmUIMsg"
                         id="searchColumnsColumn"
                         name="searchColumnsColumn"
                         columns="44"
                         textBinding="searchColumnsColumn@maskingBean@servletRequest"/>
                    <!-- Column Comments -->
                    <uix:messageTextInput                                     
                         promptBinding="COLUMN_COMMENT@dmUIMsg"
                         id="searchColumnsComment"
                         name="searchColumnsComment"
                         columns="44"
                         textBinding="searchColumnsComment@maskingBean@servletRequest"
                         tipBinding="SEARCH_USING_COMMENTS_TIP@dmUIMsg"/>
                </uix:contents>
              </uix:labeledFieldLayout>
  </uix:cellFormat>
</uix:rowLayout>

<uix:spacer width="6"/>

              <uix:separator/>              
 
              <uix:rowLayout>
                 <uix:spacer height="4"/>
              </uix:rowLayout>

              <uix:checkBox
                  name="maskAsGroup"
                  textBinding="MASK_AS_GROUP@dmUIMsg"
                  checkedBinding="maskAsGroup@maskingBean@servletRequest"/>

              <uix:rowLayout>
                 <uix:spacer height="4"/>
              </uix:rowLayout>

<!-- Search Columns Results Table -->
<uix:stackLayout>
  <uix:contents>
    <uix:table 
         summaryBinding="SELECT_COLUMNS@dmUIMsg"
         partialRenderMode="self"
         id="searchColumns"
         name="searchColumns"
         alternateTextBinding="NO_COLUMNS@dmUIMsg"
         formSubmitted="true"
         width="80%"
         valueBinding="searchColumnsValue@maskingBean@servletRequest"
         maxValueBinding="searchColumnsMaxValue@maskingBean@servletRequest"
         blockSize="25"
         tableDataBinding="searchColumns@maskingBean@servletRequest"
         columnHeaderDataBinding="searchColumnsHeaders@maskingBean@servletRequest" 
         columnFormatsBinding="searchColumnsFormats@maskingBean@servletRequest">
    
         <uix:tableFormat tableBanding="rowBanding"/>
           <uix:columnHeaderStamp>
             <uix:sortableHeader textBinding="text"
                                 sortableBinding="sort"/>
           </uix:columnHeaderStamp>
           <uix:contents>
             <uix:styledText textBinding="OWNER"/>
             <uix:styledText textBinding="TABLE_NAME"/>
             <uix:styledText textBinding="COLUMN_NAME"/>
             <uix:styledText textBinding="DATA_TYPE"/>
             <uix:styledText textBinding="COMMENT"/>
           </uix:contents>
           <uix:tableSelection>
             <uix:multipleSelection
                  shortDescBinding="SELECT@dbUIMsg"
                  selectedBinding="selected"
                  disabledBinding="disabled">
             </uix:multipleSelection>
           </uix:tableSelection>
    </uix:table>
  </uix:contents>
</uix:stackLayout>
<!-- End Search Columns Results Table -->

</uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                     shortDescBinding="CANCEL@dbUIMsg"
                     name="event"
                     value="addColumnsCancel"
                     textBinding="CANCEL@dbUIMsg"/>
                <uix:submitButton
                     shortDescBinding="ADD@dbUIMsg"
                     name="event"
                     value="addColumnsOnly"
                     textBinding="ADD@dbUIMsg"/>
                <uix:submitButton
                     shortDescBinding="ADD_AND_CONFIG@dmUIMsg"
                     name="event"
                     value="addAndConfig"
                     textBinding="ADD_AND_CONFIG@dmUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
