<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       maskingWizAddDependents.jsp
 *
 *      NOTES
 *       Launched from 'Add' on masking page. 
 *
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    11/26/08 - Implement initial input focus
 *    kmckeen    06/26/08 - Implement new workflow
 *    xshen      08/18/07 - remove selection binding
 *    xshen      03/08/07 - ui changes
 *    xshen      03/06/07 - ui changes and clean up
 *    xshen      11/21/06 - more dependent work
 *    xshen      11/13/06 - created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<db:script src="/database/LOV.js"/>  

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg"
            class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].searchDepSchema.focus()">
      <db:form name="maskingForm" method="POST"
          destinationBinding="maskingDestination@maskingBean@servletRequest"
          copyParams="target,type">
      <uix:formValue name="pageName" value="/database/masking/maskingWizAddDependents"/>

        <uix:pageLayout titleBinding="titleString@maskingBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="DATABASE@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="target@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"
                      styleClass="OraDataText"
                      textBinding="tgtUser@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="PARENT_OWNER@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="currParentOwner@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="PARENT_TABLE@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="currParentTable@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="PARENT_COLUMN@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="currParentColumn@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="DATA_TYPE@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="currParentDataType@maskingBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page context information with a separator --%>
            <uix:separator/>

            <uix:rowLayout>
              <uix:messagePrompt 
                   promptBinding="ADD_RELATED_COLUMNS_INSTRUCTION@dmUIMsg"/>
            </uix:rowLayout>

            <uix:rowLayout width="100%">
                 <uix:spacer height="4"/>
            </uix:rowLayout>

            <%-- Search Dependent Columns --%>
            <uix:header textBinding="SEARCH@dbUIMsg">
                 <uix:rowLayout> 
                    <uix:messagePrompt promptBinding="SPECIFY_SEARCH_COLUMN_CRITERIA@dmUIMsg"/>
                 </uix:rowLayout>

            <uix:rowLayout width="80%">
              <uix:labeledFieldLayout labelWidth="30%">
                <uix:contents>
                    <!-- Schema Name -->
                    <uix:messageLovField                                     
                         promptBinding="SCHEMA@dbUIMsg"
                         id="searchDepSchema"
                         name="searchDepSchema"
                         columns="40"
                         textBinding="searchDepSchema@maskingBean@servletRequest"
                         searchDescBinding="CLICK_TO_SELECT_SCHEMA@dmUIMsg"
                         onClick="preserveCase();startLov('searchDepSchema','ListSchema')"/>
                    <!-- Table Name -->
                    <uix:messageTextInput
                         promptBinding="TABLE_NAME@dmUIMsg"
                         id="searchDepTable"
                         name="searchDepTable"
                         columns="40"
                         textBinding="searchDepTable@maskingBean@servletRequest"/>
                    <!-- Column Name -->
                    <uix:messageTextInput                                     
                         promptBinding="COLUMN_NAME@dmUIMsg"
                         id="searchDepColumn"
                         name="searchDepColumn"
                         columns="40"
                         textBinding="searchDepColumn@maskingBean@servletRequest"/>
                    <!-- Search Button -->
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton 
                         name="event"
                         value="searchDepedents"
                         shortDescBinding="SEARCH@dbUIMsg"
                         textBinding="SEARCH@dbUIMsg"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:rowLayout>
<uix:separator/>

            <uix:rowLayout> 
                 <uix:spacer height="2"/>
            </uix:rowLayout>

            <%-- Results Table --%>
    <uix:table 
         summaryBinding="SELECT_COLUMNS@dmUIMsg"
         partialRenderMode="self"
         id="currDependents"
         name="currDependents"
         alternateTextBinding="NO_COLUMNS@dmUIMsg"
         formSubmitted="true"
         width="80%"
         valueBinding="currDependentsValue@maskingBean@servletRequest"
         maxValueBinding="currDependentsMaxValue@maskingBean@servletRequest"
         blockSize="25"
         tableDataBinding="currDependents@maskingBean@servletRequest"
         columnHeaderDataBinding="currDependentsHeaders@maskingBean@servletRequest" 
         columnFormatsBinding="currDependentsFormats@maskingBean@servletRequest">
    
         <uix:tableFormat tableBanding="rowBanding"/>
           <uix:columnHeaderStamp>
             <uix:sortableHeader textBinding="text" sortableBinding="sort"/>
           </uix:columnHeaderStamp>
           <uix:contents>
             <uix:styledText textBinding="OWNER"/>
             <uix:styledText textBinding="TABLE_NAME"/>
             <uix:styledText textBinding="COLUMN_NAME"/>
             <uix:styledText textBinding="DATA_TYPE"/>
           </uix:contents>
           <uix:tableSelection>
             <uix:multipleSelection
                  shortDescBinding="SELECT@dbUIMsg"
                  selectedBinding="selected"
                  disabledBinding="disabled">
             </uix:multipleSelection>
           </uix:tableSelection>
    </uix:table> 

</uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                     shortDescBinding="CANCEL@dbUIMsg"
                     name="event"
                     value="addDependentsCancel"
                     textBinding="CANCEL@dbUIMsg"/>
                <uix:submitButton
                     shortDescBinding="ADD@dbUIMsg"
                     name="event"
                     value="addDependentsOk"
                     textBinding="ADD@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
