<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       maskingWizConfigColumnRule.jsp
 *
 *      NOTES
 *       Launched from 'Configure Rule' icon on masking page. 
 *
 * MODIFIED
 *    kmckeen    02/12/09 - Bug 7477370 - package is a JavaScript reserved word
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    vgoli      10/21/08 - fix OAC violations
 *    kmckeen    09/08/08 - 
 *    vgoli      09/05/08 - javascript changes to handle mixed case db object
 *                          names
 *    kmckeen    08/25/08 - do not use Table in javascript variable names
 *    vgoli      08/19/08 - Table Column validation
 *    kmckeen    08/12/08 - Handle UDF package/function
 *    vgoli      08/04/08 - new ui with hGrid
 *    kmckeen    08/01/08 - Get subset lov working
 *    kmckeen    06/26/08 - Implement new workflow
 *    xshen      02/15/08 - validation work
 *    xshen      02/14/08 - default condition work
 *    xshen      01/30/08 - conditional masking
 *    xshen      07/03/07 - onchange dest
 *    xshen      06/29/07 - ada fix
 *    xshen      03/06/07 - ui changes
 *    xshen      02/11/07 - show sample changes
 *    xshen      12/06/06 - read only mode
 *    xshen      08/29/06 - support bulk config
 *    xshen      07/21/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<db:script src="/database/LOV.js"/>  

<script language="JavaScript">

//~
// For debugging: put the textInput field under the pageStatus section below.
// Then uncomment one of the document.forms lines.
//
// <uix:textInput id="tstfld"/>
//
// document.forms[0].tstfld.value = packageField;
// document.forms[0].tstfld.value = row;
// document.forms[0].tstfld.value = schemaDotPackage.value;
// document.forms[0].tstfld.value = functionField;
//~

function launchFunctionLOV(packageField, row)
{
  document.forms[0].fvSchema.value = "";
  document.forms[0].fvPackage.value = "";

  var schemaDotPackage = eval(document.forms[0][packageField]);
  schemaDotPackage.value = trim(schemaDotPackage.value);

  var functionField = "rules:secondInput:"+row;

  if (schemaDotPackage.value == "")
  {
    startLov(functionField,'ListStandaloneFunction');
  }
  else
  {
    if ((schemaDotPackage.value.indexOf('"')) == 0)
    {
      var endSchema = schemaDotPackage.value.indexOf('".',1);
      if (endSchema != -1)
      {
        document.forms[0].fvSchema.value = schemaDotPackage.value.substring(1,endSchema);
        document.forms[0].fvPackage.value = trim(schemaDotPackage.value.substring(endSchema+2));
      }
    }
    else
    {
      var endSchema = schemaDotPackage.value.indexOf(".");
      if (endSchema != -1)
      {
        document.forms[0].fvSchema.value = schemaDotPackage.value.substring(0,endSchema);
        document.forms[0].fvPackage.value = trim(schemaDotPackage.value.substring(endSchema+1));
      }
    }

    if ((document.forms[0].fvPackage.value.indexOf('"')) == 0)
    {
      var endPackage = document.forms[0].fvPackage.value.indexOf('"',1);
      if (endPackage <= 1)
      {
        document.forms[0].fvPackage.value = "";
      }
    }

    setSearchFilter("fvSchema");
    setSearchFilter("fvPackage");

    // Note: there is a bug with disabling the filters, bug 7316613.
    setDisabledFilter('0');
    setDisabledFilter('1');

    startLov(functionField,'ListPackageFunction');
  }
}

function trim(sString)
{
  var lre = /^\s*/;
  var rre = /\s*$/;
  sString = sString.replace(lre, "");
  sString = sString.replace(rre, "");
  return sString;
}

function validateAndLaunchLOV(tableField, columnField, lovID)
{
  var schema = "";
  var table = "";

  var schemadottable = eval(document.forms[0][tableField]);
  schemadottable.value = trim(schemadottable.value);

  if (schemadottable.value != "")
  {
    if ((schemadottable.value.indexOf('"')) == 0)
    {
      var endSchema = schemadottable.value.indexOf('".',1);
      if (endSchema != -1)
      {
        schema = schemadottable.value.substring(1,endSchema);
        table = trim(schemadottable.value.substring(endSchema+2));
      }
    }
    else
    {
      var endSchema = schemadottable.value.indexOf(".");
      if (endSchema != -1)
      {
        schema = schemadottable.value.substring(0,endSchema);
        table = trim(schemadottable.value.substring(endSchema+1));
      }
    }

    if ((table.indexOf('"')) == 0)
    {
      var endidx = table.indexOf('"',1);
      if (endidx <= 1)
      {
        table = "";
      }
    }
  }

  if (schema != "" && table != "")
  {
    setInitFilterData(schema);
    setInitFilterData(table);

    setDisabledFilter('0');
    setDisabledFilter('1');

    startLov(columnField, lovID);
  }
  else
  {
    return false;
  }
}

</script>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg" class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="maskingForm" 
               method="POST"
               destinationBinding="maskingDestination@maskingBean@servletRequest"
               copyParams="target,type">
      <uix:formValue name="pageName" 
                     value="/database/masking/maskingWizConfigColumnRule"/>

      <uix:formValue name="fvSchema"/>
      <uix:formValue name="fvPackage"/>

        <uix:pageLayout 
             titleBinding="titleString@maskingBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

          <%-- Use the pageStatus tag to provide page context (target name) --%>
          <uix:pageStatus>
            <uix:labeledFieldLayout labelWidth="25%" columns="2" width="80%">
              <uix:contents>
                <uix:messagePrompt promptBinding="OWNER@dmUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                    textBinding="ownerString@currMaskingRule@maskingBean@servletRequest"/>
  
                <uix:messagePrompt promptBinding="TABLE@dmUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                    textBinding="tableString@currMaskingRule@maskingBean@servletRequest"/>
  
                <uix:messagePrompt promptBinding="COLUMN@dmUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                    textBinding="columnName@currMaskingRule@maskingBean@servletRequest"/>
  
                <uix:messagePrompt promptBinding="DATA_TYPE@dmUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                    textBinding="dataType@currMaskingRule@maskingBean@servletRequest"/>
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:pageStatus>
  
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/> 
          
          <uix:spacer height="4"/>

          <uix:stackLayout>
            <uix:tableLayout width="100%">
              <uix:rowLayout width="100%" vAlign="top"> 
                <uix:tableLayout width="100%"
                       renderedBinding="editable@maskingBean@servletRequest">
                  <uix:rowLayout>
                    <uix:messagePrompt promptBinding="ADVANCED_MASKING_OPTIONS_DESC@dmUIMsg"/>
                  </uix:rowLayout>
  
                  <uix:rowLayout>
                    <uix:spacer height="20"/>
                  </uix:rowLayout>

                  <!-- add condition buttion -->
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:submitButton name="event"
                              value="addSubset"
                              shortDescBinding="ADD_CONDITION@dmUIMsg"
                              textBinding="ADD_CONDITION@dmUIMsg"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout> 
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:hGrid id="rules"
                       partialRenderMode="self"
                       width="100%"
                       formSubmitted="true"
                       summaryBinding="RULE_ENTRIES@dmUIMsg"
                       renderedBinding="renderEditableEntries@maskingBean@servletRequest"
                       destinationBinding="maskingDestination@maskingBean@servletRequest"
                       treeDataBinding="treeData@currMaskingRule@maskingBean@servletRequest"
                       proxyBinding="proxy@servletRequest">
              <uix:nodeStamp>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="COL_CONDITION@dmUIMsg"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                  <uix:contents>
                    <uix:dataScope>
                      <uix:switcher childNameBinding="cclauseNode">
                        <uix:case name="true">
                          <uix:textInput name="cclause" columns="30"
                              shortDescBinding="COL_CONDITION@dmUIMsg"
                              textBinding="cclause"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:styledText textBinding="text"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:dataScope>
                  </uix:contents>
                </uix:column>
              </uix:nodeStamp>

              <uix:columnGroup>
                <uix:columnHeader>
                  <uix:styledText textBinding="COL_FMT_ENTRY_PROPS@dmUIMsg"/>
                </uix:columnHeader>

                <uix:contents>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:styledText textBinding="COL_PROPERTY@dmUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                    <uix:styledText textBinding="firstInputLabel"/>
                  </uix:column>

                  <uix:column> 
                    <uix:columnHeader>
                      <uix:styledText textBinding="COL_VALUE@dmUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                    <uix:dataScope>
                      <uix:switcher childNameBinding="leafNode">
                        <uix:case name="true">

                          <uix:switcher childNameBinding="isDT">
                            <uix:case name="false">
                              <uix:dataScope>
                                <uix:textInput name="firstInput"
                                        textBinding="firstInput"
                                            columns="10"
                                   shortDescBinding="firstInputLabel"
                                    renderedBinding="disableFirstInputLov"/>
                                <uix:lovField name="firstInput"
                                        textBinding="firstInput"
                                            columns="10"
                                   shortDescBinding="firstInputLabel"
                                  searchDescBinding="firstInputSearchDesc"
                                     onClickBinding="firstLovDest"
                                    renderedBinding="enableFirstInputLov"/>
                              </uix:dataScope>
                            </uix:case>
                            <uix:case name="true">
                              <uix:dataScope>
                                <uix:dateField name="firstInput"
                                       valueBinding="firstInput"
                                   shortDescBinding="firstInputLabel"
                                            columns="10">
                                  <uix:onSubmitValidater>
                                    <uix:date dateStyle="medium"/>
                                  </uix:onSubmitValidater>
                                </uix:dateField>
                              </uix:dataScope>
                            </uix:case>
                          </uix:switcher>

                        </uix:case>
                      </uix:switcher>
                    </uix:dataScope>
                  </uix:column> 
                  
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="COL_PROPERTY@dmUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                    <uix:styledText textBinding="secondInputLabel"/>
                  </uix:column>
                  
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="COL_VALUE@dmUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                    <uix:switcher childNameBinding="leafNode">
                      <uix:case name="true">

                        <uix:switcher childNameBinding="isDT">
                          <uix:case name="false">
                            <uix:dataScope>
                              <uix:textInput name="secondInput"
                                      textBinding="secondInput"
                                          columns="10"
                                 shortDescBinding="secondInputLabel"
                                  renderedBinding="disableSecondInputLov"/>
                                <uix:lovField name="secondInput"
                                        textBinding="secondInput"
                                            columns="10"
                                   shortDescBinding="secondInputLabel"
                                  searchDescBinding="secondInputSearchDesc"
                                     onClickBinding="secondLovDest"
                                    renderedBinding="enableSecondInputLov"/>
                            </uix:dataScope>
                          </uix:case>
                          <uix:case name="true">
                            <uix:dataScope>
                              <uix:dateField name="secondInput"
                                     valueBinding="secondInput"
                                          columns="10">
                                <uix:onSubmitValidater>
                                  <uix:date dateStyle="medium"/>
                                </uix:onSubmitValidater>
                              </uix:dateField>
                            </uix:dataScope>
                          </uix:case>
                        </uix:switcher>

                      </uix:case>
                    </uix:switcher>
                  </uix:column>
                </uix:contents>
              </uix:columnGroup>

              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="SAMPLE_OUTPUT@dmUIMsg"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                <uix:dataScope>
                  <uix:styledText textBinding="sample"/>
                  <uix:image shortDescBinding="REFRESH@dmUIMsg"
                         sourceBinding="sampleDataIconSource@maskingBean@servletRequest"
                         renderedBinding="showSample"
                         onClickBinding="sampleDataDest" />
                </uix:dataScope>
              </uix:column>

              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="REMOVE@dmUIMsg"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="iconButtonFormat" width="5%"/>
                  <uix:switcher childNameBinding="removable">
                    <uix:case name="true">
                      <uix:dataScope>
                        <uix:image shortDescBinding="REMOVE@dmUIMsg"
                               sourceBinding="removeIconSource@maskingBean@servletRequest"
                               renderedBinding="leafNode"
                               onClickBinding="removeRuleRowDest" />
                        <uix:image shortDescBinding="REMOVE@dmUIMsg"
                               sourceBinding="removeIconSource@maskingBean@servletRequest"
                               renderedBinding="cclauseNode"
                               onClickBinding="removeSubsetDest" />
                      </uix:dataScope>
                    </uix:case>
                  </uix:switcher>
              </uix:column>

              <!-- single selection table -->
              <uix:tableSelection>
                <uix:singleSelection
                    renderedBinding="selectable"
                    shortDescBinding="COL_CONDITION@dmUIMsg"
                    selectedIndexBinding="selectedChildIndex@currMaskingRule@maskingBean@servletRequest">
                  <uix:contents>
                    <!-- Import Format button -->
                    <uix:submitButton name="event" 
                                      value="importRule"
                                      shortDescBinding="IMPORT_FROM_LIBRARY@dmUIMsg"
                                      textBinding="IMPORT_FROM_LIBRARY@dmUIMsg"/>

                    <uix:spacer width="20"/>

                    <!-- format entry type drop down -->
                    <uix:messageChoice 
                            shortDescBinding="RULE_TYPE@dmUIMsg"
                            name="ruleType" 
                            promptBinding="RULE_ENTRY@dmUIMsg"                            
                            selectedValueBinding="selectedRuleType@currMaskingRule@maskingBean@servletRequest">
                      <uix:contents childDataBinding="ruleTypes@currMaskingRule@maskingBean@servletRequest">
                        <uix:option textBinding="text" valueBinding="value"/>
                      </uix:contents>
                    </uix:messageChoice>

                    <!-- Add button -->
                    <uix:submitButton name="event" 
                            value="addRuleEntry"
                            shortDescBinding="ADD@dmUIMsg"
                            textBinding="ADD@dmUIMsg"/>
                  </uix:contents>
                </uix:singleSelection>
              </uix:tableSelection>
            </uix:hGrid>

          </uix:stackLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton
                   renderedBinding="editable@maskingBean@servletRequest"
                   shortDescBinding="CANCEL@dbUIMsg"
                   name="event"
                   value="configRuleCancel"
                   textBinding="CANCEL@dbUIMsg"/>
              <uix:submitButton
                   renderedBinding="editable@maskingBean@servletRequest"
                   shortDescBinding="OK@dbUIMsg"
                   name="event"
                   value="configRuleOk"
                   textBinding="OK@dbUIMsg"/>
              <uix:submitButton
                   renderedBinding="readOnly@maskingBean@servletRequest"
                   shortDescBinding="RETURN@dbUIMsg"
                   name="event"
                   value="configRuleCancel"
                   textBinding="RETURN@dbUIMsg"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

