<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       maskingWizDefinition.jsp
 *
 *      NOTES
 *       Masking definition page.
 *
 *
 * MODIFIED
 *    vgoli      02/12/09 - adv options: ignore orphan rows
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    11/26/08 - Implement initial input focus
 *    vgoli      10/30/08 - adv options: parallel degree
 *    vgoli      10/21/08 - fix OAC violations
 *    kmckeen    08/18/08 - Implement compound masking
 *    vgoli      06/17/08 - dm advanced options
 *    kmckeen    06/12/08 - Implement new workflow
 *    rpattabh   12/31/07 - Project 25671: Masking integration with Clone
 *    xshen      08/18/07 - column span sort
 *    xshen      06/29/07 - ada fix
 *    xshen      03/01/07 - ui change
 *    xshen      12/03/06 - add form submit for read only mode
 *    xshen      11/21/06 - more dependent work
 *    xshen      11/06/06 - support user defined constraint
 *    xshen      08/25/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<db:script src="/page/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg" class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>
<uix:bundle name="ReorgBundle" class="oracle.sysman.db.rsc.reorg.ReorgMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].defName.focus()">
      <db:form name="maskingForm" method="POST" destinationBinding="maskingDestination@maskingBean@servletRequest" copyParams="target,type">
      <uix:formValue name="pageName" value="/database/masking/maskingWizDefinition"/>
      <uix:formValue name="type" valueBinding="targetType@maskingBean@servletRequest"/>
      <%-- uix:formValue name="target" valueBinding="target@maskingBean@servletRequest"/ --%>

        <uix:pageLayout titleBinding="titleString@maskingBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

            <!-- General Information Section -->
<uix:rowLayout width="80%">
	    <uix:cellFormat width="200">
              <uix:spacer width="10"/>
	    </uix:cellFormat>
 
	    <uix:cellFormat>
              <uix:contents>
                <uix:labeledFieldLayout renderedBinding="editable@maskingBean@servletRequest" labelWidth="40%" width="80%">
                  <uix:contents>
                    <uix:messageTextInput
                         shortDescBinding="NAME@dmUIMsg"
                         promptBinding="NAME@dmUIMsg"
                         id="defname"
                         name="defName"
                         columns="60"
                         required="uiOnly"
                         maximumLength="40"
                         textBinding="defName@maskingBean@servletRequest"/>
                           
                    <uix:messageLovField                                     
                         shortDescBinding="DATABASE@dmUIMsg"
                         promptBinding="DATABASE@dmUIMsg"
                         required="uiOnly"
                         id="targetName"
                         name="targetName"
                         columns="60"
                         textBinding="targetName@maskingBean@servletRequest"
                         searchDescBinding="CLICK_TO_SELECT_DATABASE@dmUIMsg"
                         onClick="preserveCase();startLov('targetName','ListDatabaseCM')"/>

	            <uix:messageTextInput
                         promptBinding="DESCRIPTION@dmUIMsg"
                         shortDescBinding="DESCRIPTION@dmUIMsg"
                         name="description"
			 maximumLength="2000"
                         columns="60"
                         textBinding="description@maskingBean@servletRequest"/>

                  </uix:contents>
                </uix:labeledFieldLayout>

                <uix:labeledFieldLayout renderedBinding="readOnly@maskingBean@servletRequest" labelWidth="40%" width="80%">
                  <uix:contents>
                    <uix:messagePrompt promptBinding="NAME@dmUIMsg"/>
                    <uix:styledText styleClass="OraDataText" textBinding="defName@maskingBean@servletRequest"/>
                           
                    <uix:messagePrompt promptBinding="DATABASE@dmUIMsg"/>
                    <uix:styledText styleClass="OraDataText" textBinding="target@maskingBean@servletRequest"/>

                    <uix:messagePrompt promptBinding="DESCRIPTION@dmUIMsg"/>
                    <uix:styledText styleClass="OraDataText" textBinding="description@maskingBean@servletRequest"/>

                  </uix:contents>
                </uix:labeledFieldLayout>

              </uix:contents>
            </uix:cellFormat>

</uix:rowLayout>

            <!-- Add Table Columns Table: selected columns -->
            <uix:header textBinding="COLUMNS@dmUIMsg">
            <uix:stackLayout>
             <uix:contents>
              <uix:rowLayout renderedBinding="editable@maskingBean@servletRequest" vAlign="bottom">
                <uix:cellFormat width="100%" vAlign="bottom">
                 <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText"
                     textBinding="COLUMNS_AND_RULES_INSTRUCTION@dmUIMsg"/>
                 </uix:stackLayout>
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" vAlign="bottom">
                  <uix:submitButton textBinding="ADD@dmUIMsg"
                                    shortDescBinding="ADD@dmUIMsg"
                                    name="event" value="addColumns"/>
                </uix:cellFormat>
              </uix:rowLayout>
<uix:spacer height="2"/>

           <%-------------------------------------
            -  Columns and Rules
            --------------------------------------%>

              <uix:table renderedBinding="editable@maskingBean@servletRequest" 
                       width="100%"
                       formSubmitted="true"
                       summaryBinding="ADD@dmUIMsg"
                       partialRenderMode="self"
                       id="selectedColumnsTable"
                       name="selectedColumnsTable"
                       alternateTextBinding="NO_COLUMNS_ADDED@dmUIMsg"
                       valueBinding="selectedColumnsValue@maskingBean@servletRequest"
                       maxValueBinding="selectedColumnsMaxValue@maskingBean@servletRequest"
                       blockSize="10"
                       tableDataBinding="selectedColumns@maskingBean@servletRequest"
                       columnHeaderDataBinding="selectedColumnsHeaders@maskingBean@servletRequest" 
                       columnFormatsBinding="selectedColumnsFormats@maskingBean@servletRequest">
                      <uix:tableFormat tableBanding="rowBanding"/>
                      <uix:contents>
                      
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="OWNER@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                          <uix:styledText textBinding="OWNER"/>    
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="TABLE@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                          <uix:styledText textBinding="TABLE_NAME"/>    
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="COLUMN@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                          <uix:styledText textBinding="COLUMN_NAME"/>    
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="COLUMN_GROUP@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                          <uix:styledText textBinding="COLUMN_GROUP"/>    
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="DATA_TYPE@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                          <uix:styledText textBinding="DATA_TYPE"/>    
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="FORMAT@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="iconButtonFormat" width="6%"/>
                          <uix:image 
                             shortDescBinding="CONFIGURE_RULE@dmUIMsg"
                             sourceBinding="configIconSource@maskingBean@servletRequest"
                             onClickBinding="configRowDest@maskingBean@servletRequest" />
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="FOREIGN_KEY_COLUMNS@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat" width="8%"/>
                          <uix:styledText textBinding="FOREIGN_KEY_COLUMNS"/>    
                        </uix:column>
                        
                        <uix:columnGroup>
                           <uix:columnHeader>
                              <uix:sortableHeader textBinding="DEPENDENT_COLUMNS@dmUIMsg"/>
                           </uix:columnHeader>
                           
                           <uix:contents>
                           
                             <uix:column>
                               <uix:columnHeader>
                                 <uix:sortableHeader textBinding="COUNT@dmUIMsg" sortableBinding="sort"/>
                               </uix:columnHeader>
                               <uix:columnFormat columnDataFormat="numberFormat" width="8%"/>
                               <uix:styledText textBinding="DEPENDENT_COLUMNS"/>    
                             </uix:column>
                             
                             <uix:column>
                               <uix:columnHeader>
                                 <uix:sortableHeader textBinding="ADD@dmUIMsg" sortableBinding="sort"/>
                               </uix:columnHeader>
                               <uix:columnFormat columnDataFormat="iconButtonFormat" width="8%"/>
                               <uix:image 
                                    shortDescBinding="ADD@dmUIMsg"
                                    source="/em/images/addicon_enabled.gif"
                                    onClickBinding="addRelatedDest@maskingBean@servletRequest" />
                             </uix:column>
                             
                           </uix:contents>
                        </uix:columnGroup>
                      </uix:contents>
           <uix:tableSelection>
             <uix:multipleSelection
                  shortDescBinding="SELECT@dbUIMsg"
                  selectedBinding="selected"
                  disabledBinding="disabled">
                      <%--
                      <uix:submitButton
                           name="event"
                           value="bulkConfig"
                           shortDescBinding="CONFIGURE_RULE@dmUIMsg"
                           textBinding="CONFIGURE_RULE@dmUIMsg"/>
                      <uix:spacer width="2"/>
                      --%>
                      <uix:submitButton
                           name="event"
                           value="bulkRemove"
                           shortDescBinding="REMOVE@dmUIMsg"
                           textBinding="REMOVE@dmUIMsg"/>
             </uix:multipleSelection>
           </uix:tableSelection>
                    </uix:table>

              <uix:table renderedBinding="readOnly@maskingBean@servletRequest" 
                       width="100%"
                       formSubmitted="true"
                       summaryBinding="ADD@dmUIMsg"
                       partialRenderMode="self"
                       id="selectedColumnsTable"
                       name="selectedColumnsTable"
                       alternateTextBinding="NO_COLUMNS_ADDED@dmUIMsg"
                       valueBinding="selectedColumnsValue@maskingBean@servletRequest"
                       maxValueBinding="selectedColumnsMaxValue@maskingBean@servletRequest"
                       blockSize="10"
                       tableDataBinding="selectedColumns@maskingBean@servletRequest"
                       columnHeaderDataBinding="selectedColumnsHeaders@maskingBean@servletRequest" 
                       columnFormatsBinding="selectedColumnsFormats@maskingBean@servletRequest">
                      <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:contents>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="OWNER@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:styledText textBinding="OWNER"/>
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="TABLE@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:styledText textBinding="TABLE_NAME"/>
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="COLUMN@dbUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:styledText textBinding="COLUMN_NAME"/>
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="COLUMN_GROUP@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:styledText textBinding="COLUMN_GROUP"/>    
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="DATA_TYPE@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:styledText textBinding="DATA_TYPE"/>    
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="FORMAT@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                            <uix:image 
                             shortDescBinding="FORMAT@dmUIMsg"
                             source="/em/images/eyeglasses.gif"
                             onClickBinding="configRowDest@maskingBean@servletRequest" />
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="FOREIGN_KEY_COLUMNS@dmUIMsg" sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="FOREIGN_KEY_COLUMNS"/>    
                        </uix:column>
                        
                        <uix:column>
                          <uix:columnHeader>
                            <uix:sortableHeader textBinding="DEPENDENT_COLUMNS@dmUIMsg"  sortableBinding="sort"/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="numberFormat"/>
                          <uix:styledText textBinding="DEPENDENT_COLUMNS"/>
                        </uix:column>
                        
                      </uix:contents>
                    </uix:table>

           <%-------------------------------------
            -  Partial Configuration Icon Legend
            --------------------------------------%>
              <uix:rowLayout renderedBinding="showConfigIconLegand@maskingBean@servletRequest">
                 <uix:labeledFieldLayout labelWidth="1%">
                   <uix:contents>
                     <uix:image source="/em/images/database/config/configure_required.gif" shortDescBinding="CONFIGURE_RULE@dmUIMsg"/>
                     <uix:styledText styleClass="OraTipText" 
                          textBinding="CONFIGURE_RULE_ICON_TIP@dmUIMsg"/>
                   </uix:contents>
                 </uix:labeledFieldLayout>
                 <uix:spacer height="5"/>
              </uix:rowLayout>

                  </uix:contents>
                </uix:stackLayout>
            </uix:header>

            <!-- Foreign Key Columns Table -->
            <uix:header textBinding="FOREIGN_KEY_COLUMNS@dmUIMsg">

                  <uix:table width="100%"
                       summaryBinding="FOREIGN_KEY_COLUMNS@dmUIMsg"
                       partialRenderMode="self"
                       id="selectedChildColumnsTable"
                       name="selectedChildColumnsTable"
                       alternateTextBinding="NO_FOREIGN_KEY_COLUMNS@dmUIMsg"
                       formSubmitted="true"
                       valueBinding="selectedChildColumnsValue@maskingBean@servletRequest"
                       maxValueBinding="selectedChildColumnsMaxValue@maskingBean@servletRequest"
                       blockSize="10"
                       tableDataBinding="selectedChildColumns@maskingBean@servletRequest"
                       columnHeaderDataBinding="selectedChildColumnsHeaders@maskingBean@servletRequest" 
                       columnFormatsBinding="selectedChildColumnsFormats@maskingBean@servletRequest">
                      <uix:tableFormat tableBanding="rowBanding"/>
                      <uix:columnHeaderStamp>
                        <uix:sortableHeader textBinding="text" sortableBinding="sort"/>
                      </uix:columnHeaderStamp>
                      <uix:contents>
                            <uix:styledText textBinding="CHILD_OWNER"/>    
                            <uix:styledText textBinding="CHILD_TABLE"/>    
                            <uix:styledText textBinding="CHILD_COLUMN"/>    
                            <uix:styledText textBinding="PARENT_OWNER"/>    
                            <uix:styledText textBinding="PARENT_TABLE"/>    
                            <uix:styledText textBinding="PARENT_COLUMN"/>    
                      </uix:contents>
                    </uix:table>
            </uix:header>

            <!-- Dependent Columns Table -->
            <uix:header textBinding="DEPENDENT_COLUMNS@dmUIMsg">
             
                    <%-- Edit Mode --%>
                    <uix:table renderedBinding="editable@maskingBean@servletRequest"
                       width="100%"
                       summaryBinding="DEPENDENT_COLUMNS@dmUIMsg"
                       partialRenderMode="self"
                       id="userDefinedDependentsTable"
                       name="userDefinedDependentsTable"
                       alternateTextBinding="NO_DEPENDENT_COLUMNS_ADDED@dmUIMsg"
                       formSubmitted="true"
                       valueBinding="userDefinedDependentsValue@maskingBean@servletRequest"
                       maxValueBinding="userDefinedDependentsMaxValue@maskingBean@servletRequest"
                       blockSize="10"
                       tableDataBinding="userDefinedDependentColumns@maskingBean@servletRequest"
                       columnHeaderDataBinding="userDefinedDependentColumnsHeaders@maskingBean@servletRequest" 
                       columnFormatsBinding="userDefinedDependentColumnsFormats@maskingBean@servletRequest">
                       <uix:tableFormat tableBanding="rowBanding"/>
                       <uix:columnHeaderStamp>
                         <uix:sortableHeader textBinding="text" sortableBinding="sort"/>
                       </uix:columnHeaderStamp>
                       <uix:contents>
                            <uix:styledText textBinding="CHILD_OWNER"/>    
                            <uix:styledText textBinding="CHILD_TABLE"/>    
                            <uix:styledText textBinding="CHILD_COLUMN"/>    
                            <uix:styledText textBinding="PARENT_OWNER"/>    
                            <uix:styledText textBinding="PARENT_TABLE"/>    
                            <uix:styledText textBinding="PARENT_COLUMN"/>    
                            <uix:image shortDescBinding="REMOVE@dmUIMsg"
                                 sourceBinding="removeIconSource@maskingBean@servletRequest"
                                 onClickBinding="removeRelatedColumnDest@maskingBean@servletRequest" />
                      </uix:contents>
                    </uix:table>

                    <%-- ReadOnly Mode --%>
                    <uix:table renderedBinding="readOnly@maskingBean@servletRequest"
                       width="100%"
                       summaryBinding="DEPENDENT_COLUMNS@dmUIMsg"
                       partialRenderMode="self"
                       id="userDefinedDependentsTable"
                       name="userDefinedDependentsTable"
                       alternateTextBinding="NO_DEPENDENT_COLUMNS_ADDED@dmUIMsg"
                       formSubmitted="true"
                       valueBinding="userDefinedDependentsValue@maskingBean@servletRequest"
                       maxValueBinding="userDefinedDependentsMaxValue@maskingBean@servletRequest"
                       blockSize="10"
                       tableDataBinding="userDefinedDependentColumns@maskingBean@servletRequest"
                       columnHeaderDataBinding="userDefinedDependentColumnsHeaders@maskingBean@servletRequest" 
                       columnFormatsBinding="userDefinedDependentColumnsFormats@maskingBean@servletRequest">
                       <uix:tableFormat tableBanding="rowBanding"/>
                       <uix:columnHeaderStamp>
                         <uix:sortableHeader textBinding="text" sortableBinding="sort"/>
                       </uix:columnHeaderStamp>
                       <uix:contents>
                            <uix:styledText textBinding="CHILD_OWNER"/>    
                            <uix:styledText textBinding="CHILD_TABLE"/>    
                            <uix:styledText textBinding="CHILD_COLUMN"/>    
                            <uix:styledText textBinding="PARENT_OWNER"/>    
                            <uix:styledText textBinding="PARENT_TABLE"/>    
                            <uix:styledText textBinding="PARENT_COLUMN"/>    
                      </uix:contents>
                    </uix:table>

            </uix:header>

            <!-- Show/Hide Advanced Options -->
            <uix:spacer height="20"/>
            <uix:hideShow disclosedTextBinding="HIDE_DM_ADV_OPTIONS@dmUIMsg"
                    undisclosedTextBinding="SHOW_DM_ADV_OPTIONS@dmUIMsg"
                    id="hideShowAdvOptions"
                    formSubmitted="true"
                    partialRenderMode="self"
                    disclosedBinding="showAdvOptions@maskingBean@servletRequest">

              <uix:contents>

                <%-- DM Advanced Options --%>
                <uix:header textBinding="DM_ADV_OPTIONS@dmUIMsg">
                
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:checkBox
                           name="disableLogs"
                           textBinding="DM_ADV_OPTION_DISABLE_LOGS@dmUIMsg"
                           checkedBinding="disableLogs@maskingBean@servletRequest"/>
                      <uix:checkBox
                           name="refreshStats"
                           textBinding="DM_ADV_OPTION_REFRESH_STATS@dmUIMsg"
                           checkedBinding="refreshStats@maskingBean@servletRequest"/>
                      <uix:checkBox
                           name="dropTempTables"
                           textBinding="DM_ADV_OPTION_DROP_TEMP_TABLES@dmUIMsg"
                           checkedBinding="dropTempTables@maskingBean@servletRequest"/>
                      <uix:checkBox
                           name="ignoreOrphanRows"
                           textBinding="DM_ADV_OPTION_IGNORE_ORPHAN_ROWS@dmUIMsg"
                           checkedBinding="ignoreOrphanRows@maskingBean@servletRequest"/>

                      <uix:checkBox
                          name="parallel"
                          checkedBinding="parallel@maskingBean@servletRequest"
                          textBinding="OBJ_PARS_USE_PAR@ReorgBundle"/>

                      <uix:labeledFieldLayout labelWidth="16%">
                        <uix:contents>
                          <uix:messagePrompt promptBinding="OBJ_PARS_PAR_DEGREE@ReorgBundle"/>
                          <uix:flowLayout>
                            <uix:contents>
                              <uix:radioButton
                                  name="parallelDegreeOption"
                                  textBinding="OBJ_PARS_PAR_DEFAULT@ReorgBundle"
                                  selectedValueBinding="parallelDegreeOption@maskingBean@servletRequest"
                                  valueBinding="PARALLEL_DEGREE_DEFAULT@maskingBean@servletRequest"/>
                              <uix:radioButton
                                  name="parallelDegreeOption"
                                  textBinding="OBJ_PARS_PAR_VALUE@ReorgBundle"
                                  selectedValueBinding="parallelDegreeOption@maskingBean@servletRequest"
                                  valueBinding="PARALLEL_DEGREE_VALUE@maskingBean@servletRequest"/>
                              <uix:textInput
                                  shortDescBinding="OBJ_PARS_PAR_VALUE@ReorgBundle"
                                  name="parallelDegreeValue"
                                  textBinding="parallelDegreeValue@maskingBean@servletRequest"
                                  columns="5"/>
                            </uix:contents>
                          </uix:flowLayout>
                        </uix:contents>
                      </uix:labeledFieldLayout>

                    </uix:stackLayout>
                  </uix:contents>

                </uix:header>

                <!-- User Defined Post Mask Script -->
                <uix:header textBinding="POST_MASK_SCRIPT@dmUIMsg">
                 
                      <uix:contents>
                      <uix:stackLayout>

                        <uix:styledText styleClass="OraInstructionText"
                           textBinding="POST_MASK_SCRIPT_INSTRUCTION@dmUIMsg"/>

                        <uix:spacer height="10"/>

                        <uix:messageTextInput
                             name="postMaskingScript"
                             rows="5"
                             columns="100"
                             shortDescBinding="POST_MASK_SCRIPT@dmUIMsg"
                             renderedBinding="editable@maskingBean@servletRequest" 
                             readOnlyBinding="readOnly@maskingBean@servletRequest" 
                             textBinding="postMaskingScript@maskingBean@servletRequest"/>
                        <uix:textInput 
                             wrap="off"
                             rows="5"
                             columns="100"
                             readOnly="true"
                             shortDescBinding="POST_MASK_SCRIPT@dmUIMsg"
                             renderedBinding="readOnly@maskingBean@servletRequest" 
                             textBinding="postMaskingScript@maskingBean@servletRequest"/>
                      </uix:stackLayout>
                      </uix:contents>
                </uix:header>

              </uix:contents>
            </uix:hideShow>

            <%@ include file="/database/masking/maskingWizPageButtons.jspf" %>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

