<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       maskingWizImpactReport.jsp
 *
 *      NOTES
 *       jsp for Create Masking Job UI - Impact Report page 
 *       The key to the bean supporting the page
 *       is 'maskingBean'
 *       
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    06/19/08 - Implement new workflow
 *    xshen      06/29/07 - ada fix
 *    xshen      07/25/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg"
            class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="maskingForm" 
               method="POST"
               destinationBinding="maskingDestination@maskingBean@servletRequest"
               copyParams="target, type">
      <uix:formValue name="pageName" 
                     value="/database/masking/maskingWizImpactReport"/>

        <uix:pageLayout 
             titleBinding="titleString@maskingBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="DATABASE@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="target@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="TOTAL_TABLES@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="totalSelectedTables@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"
                      styleClass="OraDataText"
                      textBinding="tgtUser@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="TOTAL_COLUMNS@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="totalSelectedColumns@maskingBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <uix:header textBinding="SCRIPT_OPTIONS@dmUIMsg">
              <uix:rowLayout>
                <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:styledText 
                      styleClass="OraInstructionText"
                      textBinding="INFO_USE_SCRIPT_TO_CLONE@dmUIMsg"/>
                </uix:cellFormat>
                <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:spacer width="5"/>
                  <uix:submitButton
                      name="event"
                      value="optionCloneAndMask"
                      disabledBinding="cloneAndMaskDisabled@maskingBean@servletRequest"
                      shortDescBinding="CLONE_AND_MASK@dmUIMsg"
                      textBinding="CLONE_AND_MASK@dmUIMsg"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:spacer height="5"/>
              <uix:rowLayout>
                <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:styledText 
                      styleClass="OraInstructionText"
                      textBinding="INFO_SCHEDULE_DATA_MASKING_JOB@dmUIMsg"/>
                </uix:cellFormat>
                <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:spacer width="5"/>
                  <uix:submitButton
                      name="event"
                      value="optionScheduleJob"
                      disabledBinding="scheduleJobDisabled@maskingBean@servletRequest"
                      shortDescBinding="SCHEDULE_JOB@dmUIMsg"
                      textBinding="SCHEDULE_JOB@dmUIMsg"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:header>

            <uix:hideShowHeader
                id="hideShowScript"
                disclosedBinding="discloseScript@maskingBean@servletRequest"
                textBinding="SCRIPT@dmUIMsg"
                formSubmitted="true"
                partialRenderMode="self">
              <uix:stackLayout renderedBinding="scriptNotAvailable@maskingBean@servletRequest">
                <uix:contents>
                  <uix:styledText 
                      styleClass="OraInstructionText"
                      textBinding="scriptNotAvailableText@maskingBean@servletRequest"/>
                </uix:contents>
              </uix:stackLayout>
              <uix:stackLayout renderedBinding="scriptAvailable@maskingBean@servletRequest">
                <uix:contents>
                  <uix:borderLayout>
                    <uix:contents>
                      <uix:styledText 
                          styleClass="OraInstructionText"
                          textBinding="SCRIPT_INFO@dmUIMsg"/>
                    </uix:contents>
                    <uix:right>
                      <uix:rowLayout>
                        <uix:spacer width="5"/>
                        <uix:submitButton
                            shortDescBinding="SAVE_FULL_SCRIPT@dmUIMsg"                              
                            textBinding="SAVE_FULL_SCRIPT@dmUIMsg"
                            name="event" 
                            value="saveScript"/>
                      </uix:rowLayout>
                    </uix:right>
                  </uix:borderLayout>
                  <uix:spacer height="5"/>
                  <uix:labeledFieldLayout labelWidth="5%">
                    <uix:messagePrompt
                        promptBinding="VIEW@dbUIMsg"/>
                    <uix:flowLayout>
                      <uix:radioButton
                          name="viewScriptOption"
                          selectedValueBinding="viewScriptOption@maskingBean@servletRequest"
                          textBinding="SCRIPT_SUMMARY@dmUIMsg"
                          value="s"
                          onClick="submitForm('maskingForm',true,{'event':'scriptSummaryClicked'})"/>
                      <uix:radioButton
                          name="viewScriptOption"
                          selectedValueBinding="viewScriptOption@maskingBean@servletRequest"
                          textBinding="FULL_SCRIPT@dmUIMsg"
                          value="f"
                          onClick="submitForm('maskingForm',true,{'event':'fullScriptClicked'})"/>
                    </uix:flowLayout>
                  </uix:labeledFieldLayout>
                  <uix:switcher childNameBinding="viewScriptOption@maskingBean@servletRequest">
                    <uix:case name="s">
                      <uix:textInput
                          shortDescBinding="SCRIPT_SUMMARY@dmUIMsg"
                          columns="120" rows="16" wrap="soft"
                          textBinding="scriptSummary@maskingBean@servletRequest"/>
                    </uix:case>
                    <uix:case name="f">
                      <uix:textInput
                          shortDescBinding="FULL_SCRIPT@dmUIMsg"
                          columns="120" rows="16" wrap="soft"
                          textBinding="fullScript@maskingBean@servletRequest"/>
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:stackLayout>
            </uix:hideShowHeader>

            <uix:hideShowHeader
                id="hideShowImpactReport"
                disclosedBinding="discloseImpactReport@maskingBean@servletRequest"
                textBinding="IMPACT_REPORT@dmUIMsg"
                formSubmitted="true"
                partialRenderMode="self">
              <uix:stackLayout renderedBinding="impactReportNotAvailable@maskingBean@servletRequest">
                <uix:contents>
                  <uix:styledText 
                      styleClass="OraInstructionText"
                      textBinding="impactReportNotAvailableText@maskingBean@servletRequest"/>
                </uix:contents>
              </uix:stackLayout>
              <uix:stackLayout renderedBinding="impactReportAvailable@maskingBean@servletRequest">
                <uix:contents>
                  <!-- Script Generation General Summary -->
                  <uix:header textBinding="IR_SCR_GEN_SUMMARY@dmUIMsg">
                    <uix:labeledFieldLayout labelWidth="30%">
                      <uix:contents>
                        <uix:messageStyledText
                             promptBinding="IR_MOST_SERIOUS_MSG@dmUIMsg"
                             styleClass="OraDataText"
                             textBinding="generationSeverityText@maskingBean@servletRequest"/>
                        <uix:messageStyledText 
                             promptBinding="IR_SCR_GEN_STARTED@dmUIMsg"
                             styleClass="OraDataText"
                             textBinding="generationStartTime@maskingBean@servletRequest"/>
                        <uix:messageStyledText 
                             promptBinding="IR_SCR_GEN_COMPLETED@dmUIMsg"
                             styleClass="OraDataText"
                             textBinding="generationCompleteTime@maskingBean@servletRequest"/>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:header>
                  <!-- Script Generation Information -->
                  <uix:header textBinding="IR_SCR_GEN_INFO@dmUIMsg">
                    <uix:rowLayout>
                      <uix:styledText styleClass="OraInstructionText"
                           textBinding="IR_SCR_GEN_INFO_TIP@dmUIMsg"/>
                    </uix:rowLayout>
                    <oem:table alternateTextBinding="NO_MESSAGE@dmUIMsg"
                            name="impactReportTable"
                            dataSourceProp="impactReportTable"
                            beanKey="maskingBean"
                            width="100%" 
                            blockSize="10"
                            summaryBinding="IR_SCR_GEN_INFO@dmUIMsg"
                            formSubmitted="true">
                        </oem:table>
                  </uix:header>
                </uix:contents>
              </uix:stackLayout>
            </uix:hideShowHeader>

            <%-- TBD: Printable Page --%>

            <%@ include file="/database/masking/maskingWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
