<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       maskingWizImportFromLibrary.jsp
 *
 *      NOTES
 *       Launched from 'Configure Rule' icon on masking page. 
 *
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    11/26/08 - Implement initial input focus
 *    kmckeen    06/26/08 - Implement new workflow
 *    xshen      03/10/07 - Created
 *    xshen      07/23/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg" class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].searchName.focus()">
      <db:form name="maskingForm" 
               method="POST"
               destinationBinding="maskingDestination@maskingBean@servletRequest"
               copyParams="target,type">
      <uix:formValue name="pageName" value="/database/masking/maskingWizImportFromLibrary"/>

        <uix:pageLayout titleBinding="titleString@maskingBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="DATABASE@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="target@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"
                      styleClass="OraDataText"
                      textBinding="tgtUser@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="OWNER@dmUIMsg"
                      styleClass="OraDataText" 
                      textBinding="ownerString@currMaskingRule@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="COLUMN@dmUIMsg"
                      styleClass="OraDataText" 
                      textBinding="columnName@currMaskingRule@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="TABLE@dmUIMsg"
                      styleClass="OraDataText" 
                      textBinding="tableString@currMaskingRule@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="DATA_TYPE@dmUIMsg"
                      styleClass="OraDataText" 
                      textBinding="dataType@currMaskingRule@maskingBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page context information with a separator --%>
            <uix:separator/>

<!-- Common Section of Import From Library Page: Bean key: importRuleBean -->
            <uix:header textBinding="SEARCH@dbUIMsg">
               <uix:labeledFieldLayout width="80%" labelWidth="200">
                 <uix:contents>
                    <!-- Template Name -->
                    <uix:messageTextInput                               
                         promptBinding="NAME@dbUIMsg"
                         id="searchName"
                         name="searchName"
                         columns="40"
                         textBinding="searchName@ruleTemplateBean@servletRequest"/>
                    <!-- Template Owner -->
                    <uix:messageTextInput                               
                         promptBinding="OWNER@dmUIMsg"
                         id="searchOwner"
                         name="searchOwner"
                         columns="40"
                         textBinding="searchOwner@ruleTemplateBean@servletRequest"/>
                    <!-- Search Button -->
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton 
                         name="event"
                         value="searchTemplates"
                         shortDescBinding="SEARCH@dbUIMsg"
                         textBinding="SEARCH@dbUIMsg"/>
                </uix:contents>
               </uix:labeledFieldLayout>

               <uix:separator/>

               <oem:table name="templatesTable"
                           id="templatesTable"
                           summaryBinding="RULE_TEMPLATES_LIBRARY@dmUIMsg"
                           copyParams=""
                           destinationBinding="templatesDestination@importRuleBean@servletRequest"
                           width="100%"
                           blockSize="25"
                           beanKey="importRuleBean"
                           formSubmitted="true"
                           dataSourceProp="templatesTable"
                           alternateTextBinding="NO_TEMPLATES@dmUIMsg">
                  <uix:tableSelection>
                    <uix:singleSelection 
                           shortDescBinding="SELECT@dbUIMsg"
                           selectedIndexBinding="selectedIndex@importRuleBean@servletRequest"/>
                  </uix:tableSelection>                         
                </oem:table>

            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                     shortDescBinding="CANCEL@dbUIMsg"
                     name="event"
                     value="importRuleCancel"
                     textBinding="CANCEL@dbUIMsg"/>
                <uix:submitButton
                     shortDescBinding="OK@dbUIMsg"
                     name="event"
                     value="importRuleOk"
                     textBinding="IMPORT@dmUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
