<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       maskingWizSchedule.jsp
 *
 *      NOTES
 *       jsp for Create Masking Job UI - Job Schedule page 
 *       The key to the bean supporting the page
 *       is 'maskingBean'
 *       
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    11/26/08 - Implement initial input focus
 *    vgoli      10/21/08 - fix OAC violations
 *    kmckeen    06/21/08 - Implement new workflow
 *    xshen      02/20/07 - job name length
 *    xshen      07/25/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<db:script src="/database/utils.js"/>
<db:script src="/database/LOV.js"/>
<db:script src="/database/dbclone/remoteSelector.js"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg"
            class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>

        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        function setLovName(name)
        {
            document.forms[0].lovName.value = name;
        }
        </script>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].jobName.focus()">
      <db:form name="maskingForm" 
               method="POST"
               destinationBinding="maskingDestination@maskingBean@servletRequest"
               copyParams="target, type">
      <uix:formValue name="pageName" 
                     value="/database/masking/maskingWizSchedule"/>
      <uix:formValue name="lovName"/>

        <uix:pageLayout 
             titleBinding="titleString@maskingBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

            <uix:pageStatus>
              <uix:labeledFieldLayout columns="2">
                <uix:contents>
                  <uix:messageStyledText
                      promptBinding="DATABASE@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="target@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="TOTAL_TABLES@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="totalSelectedTables@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"
                      styleClass="OraDataText"
                      textBinding="tgtUser@maskingBean@servletRequest"/>
                  <uix:messageStyledText
                      promptBinding="TOTAL_COLUMNS@dmUIMsg"
                      styleClass="OraDataText"
                      textBinding="totalSelectedColumns@maskingBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <uix:separator/>

            <!-- Job Name & Description -->
              <uix:labeledFieldLayout labelWidth="0%">
                <uix:contents>
                  <uix:messageTextInput
                       promptBinding="JOB_NAME@dmUIMsg"
                       required="uiOnly"
                       columns="40" 
                       id="jobName"
                       name="jobName"
                       maximumLength="64"
                       textBinding="jobName@maskingBean@servletRequest"/>
                  <uix:messageTextInput
                       promptBinding="JOB_DESCRIPTION@dmUIMsg"
                       columns="40" 
                       maximumLength="4000"
                       name="jobDescription"
                       textBinding="jobDescription@maskingBean@servletRequest"/>
                  <uix:messageLovField 
                      id="scriptDirectory" 
                      name="scriptDirectory"
                      columns="40"
                      onClick="setLovName(document.forms[0].scriptDirectory.name);openWindow(window, '/em/console/page/rfs/postBackWithEvent', 'lovWindow', {width:750, height:550}, true, 'dialog', '');"
                      textBinding="scriptDirectory@maskingBean@servletRequest"
                      searchDescBinding="CLICK_TO_SELECT_SCRIPT_LOCATION@dmUIMsg"
                      promptBinding="SCRIPT_DIRECTORY@dmUIMsg"/>
                  <uix:messageTextInput
                      name="scriptNameOnly"
                      columns="40" 
                      textBinding="scriptNameOnly@maskingBean@servletRequest"
                      promptBinding="SCRIPT_NAME@dmUIMsg"/>
                </uix:contents>
              </uix:labeledFieldLayout>

            <!-- Host Credential -->
              <uix:header textBinding="HOST_CREDENTIALS@dmUIMsg">
                <uix:contents>
                  <!-- $SRCHOME/emcore/sysman/webapps/em/credentials.jspf -->
                  <%@ include file="/credentials.jspf"%>
                </uix:contents>
              </uix:header>

              <%@ include file="/sdk/schedule/start.jspf"%>

            <%@ include file="/database/masking/maskingWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
