<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2008, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 * NAME
 *    processing.jsp
 *
 * NOTES
 *    Processing page for generate script.
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    11/26/08 - Use getProcessingPageBrowserTitle()
 *    kmckeen    06/26/08 - Implement new workflow
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext" ><oem:setURLEncoder id="renderingContext"/> 

<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg"
            class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="processingPageBrowserTitle@maskingBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form
            name="maskingForm"
            method="post"
            destinationBinding="maskingDestination@maskingBean@servletRequest"
            copyParams="target,type">

          <uix:formValue
              name="pageName"
              value="/database/masking/processing"/>

          <uix:pageLayout>

            <%@ include file="/database/global.jspf" %>

            <!-- Messaging Area -->
            <%-- Messages should not be displayed on the processing page.
              -- Instead, they should appear on the next page.
            <%@ include file="/database/masking/dmMsging.jspf" %>   
            --%>

            <uix:header
                textBinding="PROCESSING_HDR@dmUIMsg"
                icon="/em/images/processl.gif">

              <uix:borderLayout>
                <uix:left>
                  <uix:labeledFieldLayout columns="2" labelWidth="20%">
                    <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@dmUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="target@maskingBean@servletRequest"/>
                  <uix:messagePrompt
                      promptBinding="TOTAL_TABLES@dmUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="totalSelectedTables@maskingBean@servletRequest"/>
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="tgtUser@maskingBean@servletRequest"/>
                  <uix:messagePrompt
                      promptBinding="TOTAL_COLUMNS@dmUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="totalSelectedColumns@maskingBean@servletRequest"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:left>
                <uix:right>
                  <uix:tableLayout width="100%">
                    <uix:rowLayout hAlign="right">
                      <uix:submitButton
                          name="event"
                          value="cancelProcessing"
                          textBinding="CANCEL@dbUIMsg"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:right>
              </uix:borderLayout>

              <uix:tableLayout width="100%" hAlign="center">

                <uix:rowLayout>
                  <uix:separator/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="left">
                  <uix:flowLayout>
                    <uix:styledText
                        styleClass="OraInstructionText"
                        textBinding="PROCESSING_INSTRUCTION@dmUIMsg"/>
                  </uix:flowLayout>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="20"/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="center">
                  <uix:cellFormat hAlign="center">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:processing timeInterval="<%=processingPageInterval%>"/>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>

            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancelProcessing"
                    textBinding="CANCEL@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:contentFooter>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

