<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       ruleEntry.jsp
 *
 *      NOTES
 *       Launched from Add Rule Entry for rule template page. 
 *
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    11/26/08 - Implement initial input focus
 *    vgoli      08/13/08 - add tip to second input field
 *    xshen      09/13/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg" class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@ruleTemplateBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].firstInput.focus()">
      <db:form name="manageTemplateForm" 
               method="POST"
               destinationBinding="ruleTemplateDest@ruleTemplateBean@servletRequest"
               copyParams="target,type,rule_guid">
      <uix:formValue name="pageName" 
                     value="/database/masking/ruleEntry"/>

        <uix:pageLayout 
             titleBinding="titleString@ruleTemplateBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

            <uix:header textBinding="headerString@currRuleEntry@ruleTemplateBean@servletRequest">
  	      <!-- Instruction -->
              <uix:rowLayout width="100%" vAlign="top">
                    <uix:styledText styleClass="OraInstructionText" 
                                    textBinding="instructionString@currRuleEntry@ruleTemplateBean@servletRequest"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="6"/>
              </uix:rowLayout>

  	      <!-- Input Fields -->
<uix:switcher childNameBinding="isDT@currRuleEntry@ruleTemplateBean@servletRequest">
  <uix:case name="false">
              <uix:labeledFieldLayout labelWidth="16%">

                <uix:messageTextInput
                     shortDescBinding="firstInputLabel@currRuleEntry@ruleTemplateBean@servletRequest"
                     promptBinding="firstInputLabel@currRuleEntry@ruleTemplateBean@servletRequest"
                     name="firstInput"
                     tipBinding="firstInputTip@currRuleEntry@ruleTemplateBean@servletRequest"
                     columns="50"
                     textBinding="firstInput@currRuleEntry@ruleTemplateBean@servletRequest"
                     messageBinding="(NAME@dmUIMsg)@messages@servletRequest"
                     messageTypeBinding="(NAME@cmUIMsg)@messageTypes@servletRequest"/>

                <uix:messageTextInput
                     renderedBinding="secondInputNeeded@currRuleEntry@ruleTemplateBean@servletRequest"
                     shortDescBinding="secondInputLabel@currRuleEntry@ruleTemplateBean@servletRequest"
                     promptBinding="secondInputLabel@currRuleEntry@ruleTemplateBean@servletRequest"
                     name="secondInput"
                     tipBinding="secondInputTip@currRuleEntry@ruleTemplateBean@servletRequest"
                     columns="50"
                     textBinding="secondInput@currRuleEntry@ruleTemplateBean@servletRequest"
                     messageBinding="(NAME@dmUIMsg)@messages@servletRequest"
                     messageTypeBinding="(NAME@cmUIMsg)@messageTypes@servletRequest"/>

              <!-- Case Options for Random String -->
              </uix:labeledFieldLayout>                 
  </uix:case>
  <uix:case name="true">
              <uix:labeledFieldLayout labelWidth="16%">
                 <uix:messageDateField
                      promptBinding="firstInputLabel@currRuleEntry@ruleTemplateBean@servletRequest"
                      id="firstInput"
                      name="firstInput"
                      valueBinding="firstInput@currRuleEntry@ruleTemplateBean@servletRequest"
                      tipBinding="firstInputTip@currRuleEntry@ruleTemplateBean@servletRequest"
                      shortDescBinding="firstInputLabel@currRuleEntry@ruleTemplateBean@servletRequest"
                      columns="50">
                   <uix:onSubmitValidater>
                     <uix:date dateStyle="medium"/> 
                   </uix:onSubmitValidater>
                 </uix:messageDateField>

                 <uix:messageDateField
                      promptBinding="secondInputLabel@currRuleEntry@ruleTemplateBean@servletRequest"
                      id="secondInput"
                      name="secondInput"
                      valueBinding="secondInput@currRuleEntry@ruleTemplateBean@servletRequest"
                      tipBinding="secondInputTip@currRuleEntry@ruleTemplateBean@servletRequest"
                      shortDescBinding="secondInputLabel@currRuleEntry@ruleTemplateBean@servletRequest"
                      columns="50">
                   <uix:onSubmitValidater>
                     <uix:date dateStyle="medium"/> 
                   </uix:onSubmitValidater>
                 </uix:messageDateField>
              <!-- Case Options for Random String -->
              </uix:labeledFieldLayout>                 
  </uix:case>
</uix:switcher>

            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                     shortDescBinding="CANCEL@dbUIMsg"
                     name="event"
                     value="ruleEntryCancel"
                     textBinding="CANCEL@dbUIMsg"/>
                <uix:submitButton
                     shortDescBinding="OK@dbUIMsg"
                     name="event"
                     value="ruleEntryOk"
                     textBinding="OK@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


