<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       ruleTemplates.jsp
 *
 *      NOTES
 *       Common jsp for rule template list UI.  The bean has a 
 *       key supporting this view 'maskingRuleTemplatesBean'
 *       
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    xshen      06/26/07 - enable import export
 *    xshen      11/09/06 - ui changes
 *    xshen      08/10/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg"
            class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>
<uix:bundle name="mntrResourceBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingRuleTemplatesBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="templatesForm"
               method="POST"
               destinationBinding="templatesDestination@maskingRuleTemplatesBean@servletRequest"
               copyParams="target,type">
      <uix:formValue name="pageName" 
                     value="/database/masking/ruleTemplates"/>
      <uix:formValue name="event" value="searchTemplates"/>

        <uix:pageLayout 
             titleBinding="titleString@maskingRuleTemplatesBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

        <!-- Messaging Area -->
        <%@ include file="/database/masking/dmMsging.jspf" %>   

            <!-- Instruction Text -->
            <uix:rowLayout>
              <uix:messagePrompt
                   promptBinding="RULE_TEMPLATES_LIBRARY_INFO@dmUIMsg"/>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="4"/>
            </uix:rowLayout>

<uix:separator/>

            <uix:rowLayout>
              <uix:spacer height="4"/>
            </uix:rowLayout>

            <uix:tableLayout width="100%">
              <uix:rowLayout width="100%">
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" 
			          vAlign="top">
                   <uix:contents>
                    <uix:tableLayout>
                     <uix:rowLayout>
                  <uix:messageChoice 
                            shortDescBinding="SEARCH@dbUIMsg"
                            name="searchType" 
                            promptBinding="SEARCH@dbUIMsg"
                            selectedValueBinding="searchType@maskingRuleTemplatesBean@servletRequest">
                         <uix:contents childDataBinding="searchTypes@maskingRuleTemplatesBean@servletRequest">
                         <uix:option textBinding="text"
                                     valueBinding="value"/>
                         </uix:contents>
                       </uix:messageChoice>                         
                       <uix:spacer width="6"/>
                       <uix:messageTextInput 
                            name="searchValue"
                            textBinding="searchValue@maskingRuleTemplatesBean@servletRequest"
                            shortDescBinding="ENTER_OBJECT_NAME@dbUIMsg"/>
                       <uix:spacer width="6"/>
                       <uix:submitButton name="event" 
                                         value="searchTemplates"
                                         shortDescBinding="GO@dbUIMsg"
                                         textBinding="GO@dbUIMsg"/>
                    </uix:rowLayout>
                   </uix:tableLayout>
                  </uix:contents>
                 </uix:cellFormat>

                 <!-- Create Button -->
                 <uix:cellFormat wrappingDisabled="true" hAlign="right" vAlign="top">
                  <uix:contents>
                    <uix:submitButton disabledBinding="exportDisabled@maskingRuleTemplatesBean@servletRequest"
                         textBinding="EXPORT@dmUIMsg"
                         shortDescBinding="EXPORT@dmUIMsg"
                         name="event"
                         value="launchExport"/>   
                    <uix:spacer width="2"/>
                    <uix:submitButton textBinding="IMPORT@dmUIMsg"
                         shortDescBinding="IMPORT@dmUIMsg"
                         name="event"
                         value="launchImport"/>
                    <uix:spacer width="2"/>
                    <uix:submitButton textBinding="CREATE@dbUIMsg"
                         shortDescBinding="CREATE@dbUIMsg"
                         name="event"
                         value="createTemplate"/>
                  </uix:contents>
                 </uix:cellFormat>

                </uix:contents>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:rowLayout>
              <uix:spacer height="4"/>
            </uix:rowLayout>

            <!-- Object List Results Table -->
              
                <!-- Results Table -->
                <!-- Notes: do not copy target, type since this messup 
                  --   the target home page URL (each row might be for 
                  --   different target where as hidden param is global)
                  --   The same reason for specType when it comes to 
                  --   comparisons - a baseline link should not copy type
                  -->

                <oem:table name="templatesTable"
                           id="templatesTable"
                           summaryBinding="RULE_TEMPLATES_LIBRARY@dmUIMsg"
                           copyParams=""
                           destinationBinding="templatesDestination@maskingRuleTemplatesBean@servletRequest"
                           width="100%"
                           blockSize="25"
                           beanKey="maskingRuleTemplatesBean"
                           formSubmitted="true"
                           dataSourceProp="templatesTable"
                           alternateTextBinding="NO_TEMPLATES@dmUIMsg">
                  <uix:tableSelection>
                    <uix:singleSelection 
                           shortDescBinding="SELECT@dbUIMsg"
                           selectedIndexBinding="selectedIndex@maskingRuleTemplatesBean@servletRequest">

                      <!-- View  -->
                      <uix:submitButton
                           name="event"
                           value="viewTemplate"
                           shortDescBinding="VIEW_BUTTON@dbUIMsg"
                           textBinding="VIEW_BUTTON@dbUIMsg"/>
                      <uix:spacer width="2"/>

                      <!-- Create Like  -->
                      <uix:submitButton
                           name="event"
                           value="createLikeTemplate"
                           shortDescBinding="CREATE_LIKE@dbUIMsg"
                           textBinding="CREATE_LIKE@dbUIMsg"/>
                      <uix:spacer width="2"/>

                      <!-- Edit  -->
                      <uix:submitButton
                           name="event"
                           value="editTemplate"
                           shortDescBinding="EDIT@dbUIMsg"
                           textBinding="EDIT@dbUIMsg"/>
                      <uix:spacer width="2"/>

                      <!-- Delete -->
                      <uix:submitButton
                           name="event"
                           value="deleteTemplate"
                           shortDescBinding="DELETE@dbUIMsg"
                           textBinding="DELETE@dbUIMsg"/>

                    </uix:singleSelection>
                  </uix:tableSelection>                         
                </oem:table>

            
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
