<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       viewDefinition.jsp
 *
 *      NOTES
 *       Common jsp for masking definitions list UI.
 *       The bean key supporting this view is 'maskingDefinitionBean'
 *       
 *
 * MODIFIED
 *    vgoli      02/12/09 - adv options: ignore orphan rows
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    vgoli      11/05/08 - adv options: parallel degree
 *    vgoli      10/21/08 - fix OAC violations
 *    kmckeen    07/04/08 - Implement new workflow
 *    vgoli      06/18/08 - add advanced options
 *    rpattabh   01/01/08 - add post mask script
 *    xshen      03/01/07 - ui changes
 *    xshen      12/05/06 - informal constraint work
 *    xshen      11/09/06 - ui changes
 *    xshen      08/08/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg"
            class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>
<uix:bundle name="ReorgBundle"
            class="oracle.sysman.db.rsc.reorg.ReorgMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingDefinitionBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="definitionForm"
               method="POST"
               destinationBinding="definitionDestination@maskingDefinitionBean@servletRequest"
               copyParams="target,type,ss_guid">
      <uix:formValue name="pageName" value="/database/masking/viewDefinition"/>
        <uix:pageLayout 
             titleBinding="titleString@maskingDefinitionBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="/database/masking/dmMsging.jspf" %>   

            <!-- General Information -->
            <uix:header textBinding="GENERAL@dbUIMsg">
              <uix:labeledFieldLayout>
                <uix:messageStyledText
                    promptBinding="NAME@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="defName@maskingDefinitionBean@servletRequest"/>
                <uix:messageStyledText
                    promptBinding="DATABASE@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="target@maskingDefinitionBean@servletRequest"/>
                <uix:messageStyledText
                    promptBinding="DESCRIPTION@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="description@maskingDefinitionBean@servletRequest"/>
              </uix:labeledFieldLayout>  
            </uix:header>

            <!-- Columns and Rules -->
            <uix:header textBinding="COLUMNS_AND_RULES@dmUIMsg">
              <uix:rowLayout>
                <uix:spacer height="2"/>
              </uix:rowLayout>

                <oem:table name="columnsTable"
                           id="columnsTable"
                           summaryBinding="COLUMNS_AND_RULES@dmUIMsg"
                           destinationBinding="definitionDestination@maskingDefinitionBean@servletRequest"
                           width="80%"
                           blockSize="25"
                           beanKey="maskingDefinitionBean"
                           formSubmitted="true"
                           dataSourceProp="columnsTable"
                           alternateTextBinding="NO_COLUMNS@dmUIMsg"/>
            </uix:header>
            
            <!-- Foreign Key Columns -->
            <uix:header textBinding="FOREIGN_KEY_COLUMNS@dmUIMsg">
              <uix:rowLayout>
                <uix:spacer height="2"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="2"/>
              </uix:rowLayout>

                <oem:table name="dependentsTable"
                           id="dependentsTable"
                           summaryBinding="FOREIGN_KEY_COLUMNS@dmUIMsg"
                           destinationBinding="definitionDestination@maskingDefinitionBean@servletRequest"
                           width="80%"
                           blockSize="25"
                           beanKey="maskingDefinitionBean"
                           formSubmitted="true"
                           dataSourceProp="dependentsTable"
                           alternateTextBinding="NO_FOREIGN_KEY_COLUMNS@dmUIMsg"/>
            </uix:header>

            <!-- Dependent Columns: Related Columns -->
            <uix:header textBinding="DEPENDENT_COLUMNS@dmUIMsg">
              <uix:rowLayout>
                <uix:spacer height="2"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:spacer height="2"/>
              </uix:rowLayout>

                <oem:table name="relatedColumnsTable"
                           id="relatedColumnsTable"
                           summaryBinding="DEPENDENT_COLUMNS@dmUIMsg"
                           destinationBinding="definitionDestination@maskingDefinitionBean@servletRequest"
                           width="80%"
                           blockSize="25"
                           beanKey="maskingDefinitionBean"
                           formSubmitted="true"
                           dataSourceProp="relatedColumnsTable"
                           alternateTextBinding="NO_DEPENDENT_COLUMNS@dmUIMsg"/>
            </uix:header>
            
            <!-- Jobs -->
            <uix:header textBinding="MASKING_JOBS@dmUIMsg">
              <uix:rowLayout>
                <uix:spacer height="2"/>
              </uix:rowLayout>

                <oem:table name="maskingJobsTable"
                           id="maskingJobsTable"
                           summaryBinding="MASKING_JOBS@dmUIMsg"
                           destinationBinding="definitionDestination@maskingDefinitionBean@servletRequest"
                           width="80%"
                           blockSize="25"
                           beanKey="maskingDefinitionBean"
                           formSubmitted="true"
                           dataSourceProp="maskingJobsTable"
                           alternateTextBinding="NO_MASKING_JOBS@dmUIMsg"/>
            </uix:header>

            <%-- DM Advanced Options --%>
            <uix:header textBinding="DM_ADV_OPTIONS@dmUIMsg">
            
              <uix:contents>
                <uix:stackLayout>
                  <uix:checkBox
                       name="disableLogs"
                       readOnly="true"
                       textBinding="DM_ADV_OPTION_DISABLE_LOGS@dmUIMsg"
                       checkedBinding="disableLogs@maskingDefinitionBean@servletRequest"/>
                  <uix:checkBox
                       name="refreshStats"
                       readOnly="true"
                       textBinding="DM_ADV_OPTION_REFRESH_STATS@dmUIMsg"
                       checkedBinding="refreshStats@maskingDefinitionBean@servletRequest"/>
                  <uix:checkBox
                       name="dropTempTables"
                       readOnly="true"
                       textBinding="DM_ADV_OPTION_DROP_TEMP_TABLES@dmUIMsg"
                       checkedBinding="dropTempTables@maskingDefinitionBean@servletRequest"/>
                  <uix:checkBox
                       name="ignoreOrphanRows"
                       readOnly="true"
                       textBinding="DM_ADV_OPTION_IGNORE_ORPHAN_ROWS@dmUIMsg"
                       checkedBinding="ignoreOrphanRows@maskingDefinitionBean@servletRequest"/>
                  <uix:checkBox
                      name="parallel"
                      readOnly="true"
                      checkedBinding="parallel@maskingDefinitionBean@servletRequest"
                      textBinding="OBJ_PARS_USE_PAR@ReorgBundle"/>

                  <uix:labeledFieldLayout labelWidth="16%">
                    <uix:contents>
                      <uix:messagePrompt promptBinding="OBJ_PARS_PAR_DEGREE@ReorgBundle"/>
                      <uix:flowLayout>
                        <uix:contents>
                          <uix:radioButton
                              name="parallelDegreeOption"
                              readOnly="true"
                              textBinding="OBJ_PARS_PAR_DEFAULT@ReorgBundle"
                              selectedBinding="defaultDegree@maskingDefinitionBean@servletRequest"/>
                          <uix:radioButton
                              name="parallelDegreeOption"
                              readOnly="true"
                              textBinding="OBJ_PARS_PAR_VALUE@ReorgBundle"
                              selectedBinding="parallelDegree@maskingDefinitionBean@servletRequest"/>
                          <uix:textInput
                              shortDescBinding="OBJ_PARS_PAR_VALUE@ReorgBundle"
                              name="parallelDegreeValue"
                              disabled="true"
                              textBinding="parallelDegreeValue@maskingDefinitionBean@servletRequest"
                              columns="5"/>
                        </uix:contents>
                      </uix:flowLayout>
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:stackLayout>
              </uix:contents>

            </uix:header>

            <!-- User Defined Post Mask Script -->
            <uix:header textBinding="POST_MASK_SCRIPT@dmUIMsg">
             
                  <uix:contents>

                  <uix:stackLayout>

                    <uix:styledText styleClass="OraInstructionText"
                       textBinding="POST_MASK_SCRIPT_INSTRUCTION@dmUIMsg"/>

                    <uix:spacer height="10"/>

                    <uix:textInput 
                         wrap="off"
                         rows="5"
                         columns="100"
                         readOnly="true" 
                         shortDescBinding="POST_MASK_SCRIPT@dmUIMsg"
                         textBinding="postMaskingScript@maskingDefinitionBean@servletRequest"/>
                  </uix:stackLayout>

                  </uix:contents>
            </uix:header>

            <!-- Page Buttons: OK -->

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button
                    shortDescBinding="CREATE_LIKE@dbUIMsg"
                    textBinding="CREATE_LIKE@dbUIMsg"
                    destinationBinding="maskDataDestCreateLike@maskingDefinitionBean@servletRequest"/>
                <uix:button
                    shortDescBinding="EDIT@dbUIMsg"
                    textBinding="EDIT@dbUIMsg"
                    destinationBinding="maskDataDestEdit@maskingDefinitionBean@servletRequest"/>
                <uix:button
                    shortDescBinding="OK@dbUIMsg"
                    textBinding="OK@dbUIMsg"
                    destinationBinding="maskDataDestOK@maskingDefinitionBean@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
