<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       viewMaskingRule.jsp
 *
 *      NOTES
 *       Launched from 'View Masking Definition' page. 
 *
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    vgoli      10/21/08 - fix OAC violations
 *    kmckeen    10/17/08 - Add preserve original data checkbox
 *    kmckeen    08/21/08 - Implement compound masking
 *    vgoli      08/04/08 - conditional masking - new ui changes
 *    xshen      03/03/08 - view masking format using new data model
 *    xshen      03/07/07 - ui changes
 *    xshen      09/13/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg" class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingDefinitionBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="maskingForm" 
               method="POST"
               destinationBinding="definitionDestination@maskingDefinitionBean@servletRequest"
               copyParams="target,type">
      <uix:formValue name="pageName" value="/database/masking/viewMaskingRule"/>

        <uix:pageLayout titleBinding="titleString@maskingDefinitionBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Messaging Area -->
            <%@ include file="/database/masking/dmMsging.jspf" %>   

          <uix:spacer height="4"/>
  
          <%-- General Section Table, Column, Type, Size --%>
          <uix:pageStatus>
            <uix:labeledFieldLayout columns="2">
              <uix:contents>
                <uix:messageStyledText
                    renderedBinding="singleColumn@maskingDefinitionBean@servletRequest"
                    promptBinding="OWNER@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="ownerString@currMaskingRule@maskingDefinitionBean@servletRequest"/>
                <uix:messageStyledText 
                    renderedBinding="singleColumn@maskingDefinitionBean@servletRequest"
                    promptBinding="TABLE@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="tableString@currMaskingRule@maskingDefinitionBean@servletRequest"/>
                <uix:messageStyledText
                    renderedBinding="singleColumn@maskingDefinitionBean@servletRequest"
                    promptBinding="COLUMN@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="columnName@currMaskingRule@maskingDefinitionBean@servletRequest"/>
                <uix:messageStyledText 
                    renderedBinding="singleColumn@maskingDefinitionBean@servletRequest"
                    promptBinding="DATA_TYPE@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="dataType@maskingDefinitionBean@servletRequest"/>
                <uix:messageStyledText
                    renderedBinding="maskGroup@maskingDefinitionBean@servletRequest"
                    promptBinding="OWNER@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="maskGroupOwner@maskingDefinitionBean@servletRequest"/>
                <uix:messageStyledText 
                    renderedBinding="maskGroup@maskingDefinitionBean@servletRequest"
                    promptBinding="TABLE@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="maskGroupTable@maskingDefinitionBean@servletRequest"/>
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:pageStatus>
  
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/> 
          
          <uix:stackLayout 
              renderedBinding="singleColumn@maskingDefinitionBean@servletRequest">

            <uix:hGrid id="rules"
                       partialRenderMode="self"
                       width="100%"
                       summaryBinding="RULE_ENTRIES@dmUIMsg"
                       treeDataBinding="treeData@currMaskingRule@maskingDefinitionBean@servletRequest">
              <uix:nodeStamp>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="COL_CONDITION@dmUIMsg"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" width="40%"/>
                  <uix:contents>
                    <uix:dataScope>
                      <uix:switcher childNameBinding="cclauseNode">
                        <uix:case name="true">
                          <uix:styledText textBinding="cclause" truncateAt="50"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:styledText textBinding="text" truncateAt="50"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:dataScope>
                  </uix:contents>
                </uix:column>
              </uix:nodeStamp>

              <uix:columnGroup>
                <uix:columnHeader>
                  <uix:styledText textBinding="COL_FMT_ENTRY_PROPS@dmUIMsg"/>
                </uix:columnHeader>

                <uix:contents>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:styledText textBinding="COL_PROPERTY@dmUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                    <uix:styledText textBinding="firstInputLabel"/>
                  </uix:column>

                  <uix:column> 
                    <uix:columnHeader>
                      <uix:styledText textBinding="COL_VALUE@dmUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                    <uix:dataScope>
                      <uix:switcher childNameBinding="leafNode">
                        <uix:case name="true"> 
                          <uix:dataScope>
                            <uix:styledText textBinding="firstInput" truncateAt="20"/>
                          </uix:dataScope>
                        </uix:case>
                      </uix:switcher>
                    </uix:dataScope>
                  </uix:column> 
                  
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="COL_PROPERTY@dmUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                    <uix:styledText textBinding="secondInputLabel"/>
                  </uix:column>
                  
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="COL_VALUE@dmUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                    <uix:dataScope>
                      <uix:switcher childNameBinding="leafNode">
                        <uix:case name="true">
                          <uix:styledText textBinding="secondInput" truncateAt="20"
                                      renderedBinding="secondInputNeeded"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:dataScope>
                  </uix:column>
                </uix:contents>
              </uix:columnGroup>

            </uix:hGrid>
            
            <uix:spacer height="20"/>

          </uix:stackLayout>

          <%--
            <uix:header textBinding="RULE_ENTRIES@dmUIMsg"> </uix:header>
          --%>

          <uix:labeledFieldLayout 
              renderedBinding="maskGroup@maskingDefinitionBean@servletRequest"
              labelWidth="10%">
            <uix:contents>
              <uix:messageStyledText
                  styleClass="OraDataText"
                  promptBinding="RULE_TYPE@dmUIMsg"
                  textBinding="maskGroupFormat@maskingDefinitionBean@servletRequest"/>
              <uix:messageStyledText
                  renderedBinding="renderMaskTableLOV@maskingDefinitionBean@servletRequest"
                  styleClass="OraDataText"
                  promptBinding="MASKING_TABLE@dmUIMsg"
                  textBinding="maskGroupMaskingTable@maskingDefinitionBean@servletRequest"/>
            </uix:contents>
          </uix:labeledFieldLayout>

          <uix:table 
              renderedBinding="maskGroup@maskingDefinitionBean@servletRequest"
              id="maskGroupColumnsTable"
              name="maskGroupColumnsTable"
              width="100%"
              formSubmitted="true"
              partialRenderMode="self"
              summaryBinding="DEFINE_GROUP_MASK@dmUIMsg"
              alternateTextBinding="NO_COLUMNS_ADDED@dmUIMsg"
              tableDataBinding="maskGroupColumns@maskingDefinitionBean@servletRequest"
              columnHeaderDataBinding="maskGroupColumnsHeaders@maskingDefinitionBean@servletRequest" 
              columnFormatsBinding="maskGroupColumnsFormats@maskingDefinitionBean@servletRequest">
            <uix:contents>

              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="COLUMN@dmUIMsg"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="COLUMN_NAME"/>
              </uix:column>

              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="DATA_TYPE@dmUIMsg"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="DATA_TYPE"/>
              </uix:column>

              <uix:column renderedBinding="renderMaskTableLOV@maskingDefinitionBean@servletRequest">
                <uix:columnHeader>
                  <uix:styledText textBinding="MASKING_COLUMN@dmUIMsg"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="MASKING_COLUMN"/>    
              </uix:column>

              <uix:columnGroup renderedBinding="renderUserDefinedFunctionLOV@maskingDefinitionBean@servletRequest">
                <uix:columnHeader>
                  <uix:styledText textBinding="USER_DEFINED_FUNCTION@dmUIMsg"/>
                </uix:columnHeader>
                <uix:contents>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="PACKAGE@dbUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="PACKAGE"/>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="FUNCTION@dbUIMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="FUNCTION"/>
                  </uix:column>

                </uix:contents>
              </uix:columnGroup>

              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="PRESERVE_ORIG_DATA@dmUIMsg"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="PRESERVE_ORIG_DATA"/>
              </uix:column>

            </uix:contents>
          </uix:table>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button 
                     destinationBinding="viewMaskingRuleReturnURL@maskingDefinitionBean@servletRequest"
                     shortDescBinding="RETURN@dbUIMsg"
                     textBinding="RETURN@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


