<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type">
      <uix:formValue name="pageNum" value="19"/>
      <uix:formValue name="dn" valueBinding="dn@devicesBean@obBean@servletRequest"/>
      <uix:formValue name="newdn" valueBinding="dn@devicesBean@obBean@servletRequest"/>
      <uix:formValue name="dtype" valueBinding="dtype@devicesBean@obBean@servletRequest"/>
      <uix:formValue name="deviceCommand" valueBinding="deviceCommand@devicesBean@obBean@servletRequest"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

       <style selector=".OraMonoText">
          <property name="font-family">Currier,Currier New</property>
          <property name="font-size">8pt</property>    
          <property name="color">#000000</property>
       </style>

       <uix:header textBinding="deviceText@devicesBean@obBean@servletRequest">
          <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
         <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="left" columnSpan="2">
              <uix:styledText textBinding="deviceOutput@devicesBean@obBean@servletRequest" 
                              styleClass="OraInstructionText"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:labeledFieldLayout width="70%">
          <uix:messageStyledText promptBinding="DEVICE_NAME@obBundle@servletRequest"
                                 styleClass="OraDataText"
                                 textBinding="dn@devicesBean@obBean@servletRequest"/>
          <uix:messageStyledText promptBinding="DEVICE_TYPE@obBundle@servletRequest"
                                 styleClass="OraDataText"
                                 textBinding="dtype@devicesBean@obBean@servletRequest"/>
        </uix:labeledFieldLayout>

        <uix:header textBinding="COMMAND_OPTIONS@obBundle@servletRequest">
          <uix:spacer height="10"/>
          <uix:switcher childNameBinding="deviceCommand@devicesBean@obBean@servletRequest">
            <uix:case name="identifyvol">
              <uix:tableLayout cellSpacing="5" width="60%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="SE@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />

                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                     <uix:textInput name="se"
                                    shortDescBinding="SE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">

                    <uix:styledText textBinding="SE_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="30%">
                    <uix:checkBox name="import"
                                     value="yes"
                                     shortDescBinding="IMPORT@obBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="IMPORT_TIP@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="borrow">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="NONE_UC@obBundle@servletRequest" 
                                    styleClass="OraInstructionText"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="return">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="NONE_UC@obBundle@servletRequest" 
                                    styleClass="OraInstructionText"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="clean">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="ES@obBundle@servletRequest" 
                                    styleClass="OraInstructionText"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="50%">
                    <uix:textInput name="es"
                                   shortDescBinding="ES@obBundle@servletRequest"/>

                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="50%">
                    <uix:styledText textBinding="ES_CL_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:checkBox name="force"
                                  value="yes"
                                  shortDescBinding="OB_FORCE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" columnSpan="2">
                    <uix:styledText textBinding="OB_FORCE@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="50%">
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="showVols@devicesBean@obBean@servletRequest">
            <uix:case name="vol">
              <uix:header textBinding="VIEW_DEVICE_VOLUMES@obBundle@servletRequest">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:textInput name="deviceVolumes"
                                     shortDescBinding="VIEW_DEVICE_VOLUMES@obBundle@servletRequest"
                                     textBinding="deviceVolumes@devicesBean@obBean@servletRequest"
                                     readOnly="true"
                                     wrap="false"
                                     columns="120"
                                     styleClass="OraMonoText"
                                     rows="15"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:case>
          </uix:switcher>
      </uix:header>
    </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:flowLayout>
                <uix:submitButton 
                   textBinding="CANCEL@obBundle@servletRequest" 
                   name="event" 
                   value="manageDevices"/>
                <uix:spacer width="5" />
                <uix:submitButton 
                   textBinding="OK@obBundle@servletRequest" 
                   name="event" 
                   value="deviceCommand"/>
              </uix:flowLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
