<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="0"/>
    <uix:formValue name="basePage" value="base"/>
    <uix:formValue name="type" value="host"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

       <uix:header textBinding="ORACLE_BACKUP@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="100%">
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="HEADING_AH@obBundle@servletRequest" />
            </uix:cellFormat>
         </uix:rowLayout>
       <uix:header textBinding="ADMIN_HOST@obBundle@servletRequest">

         <uix:switcher childNameBinding="noAdminServers@obBean@servletRequest">
           <uix:case name="noDevices">
             <uix:tableLayout cellSpacing="5" width="80%">
               <uix:rowLayout width="100%">
                  <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                    <uix:contents>
                      <uix:contentContainer textBinding="OB_OVERVIEW@obBundle@servletRequest" 
                                            width="100%" icon="/em/images/infoicon_active.gif">
                        <uix:contents>
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="OB_HELP_TEXT@obBundle@servletRequest"/>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:contents>
                      </uix:contentContainer>
                    </uix:contents>
                 </uix:cellFormat>
               </uix:rowLayout>
             </uix:tableLayout>
           </uix:case>
         </uix:switcher>

         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="right" vAlign="top" width="100%">
              <uix:submitButton textBinding="ADD@obBundle@servletRequest" 
                                name="event" 
                                value="addAdmin"/>
            </uix:cellFormat>
         </uix:rowLayout>


        <uix:stackLayout>
        <uix:contents>
          <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                name="adminhostUI"
                dataSourceProp="adminhostUI"
                destination="/console/database/ob/obAdmin"
                beanKey="adminhostDataSourceBean"
                copyParams="target,type"
                summaryBinding="ADMIN_HOST@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection 
                       shortDescBinding="SELECT@obBundle@servletRequest" 
                       selectedIndexBinding="selectedAH@obBean@servletRequest">
                  <uix:submitButton
                      formName="foo"
                      textBinding="REMOVE@obBundle@servletRequest"
                      name="event"
                      value="confirmRemoveAdminhost"/>
                  <uix:spacer width="5" />
                  <uix:submitButton
                      formName="foo"
                      textBinding="EDIT@obBundle@servletRequest"
                      name="event"
                      value="updateAdmin"/>
                  </uix:singleSelection>
                </uix:tableSelection>
          </oem:table>

        </uix:contents>
        </uix:stackLayout>
       </uix:header>
          <uix:spacer height="10"/>
           <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest">
             <uix:tableLayout cellSpacing="5" width="70%">
               <uix:rowLayout>
                  <uix:cellFormat hAlign="left" width="20%">
                    <db:link textBinding="JOBS@obBundle@servletRequest"
                           destinationBinding="jobLink@obBean@servletRequest"/>
                 </uix:cellFormat>
                 <uix:cellFormat hAlign="left"  >
                    <db:link textBinding="VIEW_BACKUP_REPORTS@obBundle@servletRequest"
                           destinationBinding="backupReportLink@obBean@servletRequest"/>
                 </uix:cellFormat>
                 <uix:cellFormat hAlign="left">
                    <db:link textBinding="RECOVERY_CATALOG@obBundle@servletRequest"
                           destinationBinding="recoveryCatalogLink@obBean@servletRequest"/>
                 </uix:cellFormat>
               </uix:rowLayout>
             </uix:tableLayout>
            <uix:spacer height="10"/>
         </uix:header>
       </uix:header>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
