<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destination="/console/database/ob" method="post" copyParams="target,type">
        <uix:formValue name="pageNum" value="111"/>
        <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
        <uix:formValue name="adminName" valueBinding="adminName@obBean@servletRequest"/>
        <uix:formValue name="viewOptions" valueBinding="switch@obBean@servletRequest"/>
        <uix:formValue name="optionChoice" valueBinding="adminSelection@obBean@servletRequest"/>
        <uix:formValue name="returnUrl" valueBinding="returnUrl@servletRequest"/>

      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %>
        
      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      destTableBinding="infoUrls@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      destTableBinding="errorUrls@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:switcher childNameBinding="obType@obBean@servletRequest">
     <uix:case name="true">
      <uix:header textBinding="SELECT_ADMINHOST@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5" width="75%">
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt labeledNodeId="dr"
                promptBinding="AH_SELECTOR@obBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <oem:choice name="adminNameWrapper"
                   id="dr"
                   shortDescBinding="AH_SELECTOR_TIP@obBundle@servletRequest"
                   optionsBinding="obAdminHosts@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>
     </uix:case>
    </uix:switcher>

      <!-- OSB Credentials -->
      <uix:header textBinding="OSB_CREDENTIALS@obBundle@servletRequest">

        <uix:styledText styleClass="OraInstructionText" textBinding="OSB_CREDENTIALS_TEXT@obBundle@servletRequest" />
        <uix:stackLayout>
        <uix:contents>
        <uix:labeledFieldLayout labelWidthBinding="credsLabelWidth@credsBean@servletRequest">
          <uix:contents>
            <uix:messageTextInput name="adminUserName"
                                  textBinding="settingsUser@obBean@servletRequest"
                                  promptBinding="OB_USER_NAME@obBundle@servletRequest"
                                  shortDescBinding="OB_USER_NAME@obBundle@servletRequest"
                                  tipBinding="OB_USER_NAME_TIP@obBundle@servletRequest"
                                  required="uiOnly"
                                  noAutoComplete="true"
                                  columns="40"/>
            <uix:messageTextInput name="adminUserPassword"
                                  promptBinding="OB_USER_PASSWORD@obBundle@servletRequest"
                                  textBinding="settingsPass@obBean@servletRequest"
                                  secret="true"
                                  shortDescBinding="OB_USER_PASSWORD@obBundle@servletRequest"
                                  required="uiOnly"
                                  noAutoComplete="true"
                                  columns="40" />
          </uix:contents>
        </uix:labeledFieldLayout>
       </uix:contents>
       </uix:stackLayout>
      </uix:header>

      <uix:spacer height="10"/>

      <!-- Host Credentials -->
      <uix:header textBinding="HOST_CREDENTIALS@obBundle@servletRequest">
        <uix:styledText styleClass="OraInstructionText" textBinding="OS_CREDENTIALS@obBundle@servletRequest" />
          <%@ include file="/credentials.jspf"%>
      </uix:header>

      <uix:contentFooter> 
        <uix:pageButtonBar>
          <uix:submitButton 
               textBinding="CANCEL@obBundle@servletRequest" 
               name="event" 
               value="cancelObCred" />
          <uix:submitButton 
               textBinding="OK@obBundle@servletRequest" 
               name="event" 
               value="okCred" />
        </uix:pageButtonBar>
      </uix:contentFooter>
 
      </uix:pageLayout>
    </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

