<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destination="/console/database/ob" method="post" copyParams="target,type">
        <uix:formValue name="pageNum" value="7"/>

      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %>
        
      <uix:header textBinding="DB_AH_SELECTOR@obBundle@servletRequest">

          <oem:messageBox messageType="info"
                               errorTableBinding="info@servletRequest"
                               destTableBinding="infoUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                               errorTableBinding="errors@servletRequest"
                               destTableBinding="errorUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout cellSpacing="5" width="75%">

          <%-- Intro text --%>
          <uix:spacer height="5"/>
          <uix:rowLayout>
          <uix:cellFormat columnSpan="4">
            <uix:styledText textBinding="text@obBean@servletRequest" 
              styleClass="OraInstructionText"/>
          </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

          <%-- List of administrative hosts--%>
        <uix:spacer height="5"/>
        <uix:tableLayout cellSpacing="5" width="75%">
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="DB_AH_SELECTOR_TARGET@obBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
                  <uix:styledText
                       textBinding="databaseName@obBean@servletRequest"
                       styleClass="OraDataText"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="DB_AH_SELECTOR_TYPE@obBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
                  <uix:styledText
                       textBinding="databaseType@obBean@servletRequest"
                       styleClass="OraDataText"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt labeledNodeId="dr" 
                promptBinding="AH_SELECTOR@obBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <oem:choice name="adminNameWrapper"
                   shortDescBinding="AH_SELECTOR@obBundle@servletRequest"
                   optionsBinding="obAdminHosts@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
                  <uix:submitButton textBinding="ADD@obBundle@servletRequest" 
                    name="event" value="addAdmin"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

        </uix:header>

      <uix:contentFooter> 
        <uix:pageButtonBar>
          <uix:submitButton 
               textBinding="CANCEL@obBundle@servletRequest" 
               name="event" 
               value="cancelDBAH" />
          <uix:submitButton 
               textBinding="OK@obBundle@servletRequest" 
               name="event" 
               value="setDBAH" />

        </uix:pageButtonBar>
      </uix:contentFooter>
 
      </uix:pageLayout>
    </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

