<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="adminName,target,type"> 
    <uix:formValue name="pageNum" value="21"/>
    <uix:formValue name="adminName" valueBinding="adminNameShort@obBean@servletRequest"/>

     <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

      <uix:header textBinding="adminName@obBean@servletRequest">
      <uix:contents>
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="0">
              <uix:link textBinding="HOME@obBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'21'})"/>
              <uix:link textBinding="ADMINISTRATION@obBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'40'})"/>
            </uix:subTabBar>
          </uix:subTabs>


      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
     <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
        <uix:contents>
         <uix:spacer height="10"/>
         <uix:styledText styleClass="OraInstructionText" 
                         textBinding="AS_HOME_HEADING@obBundle@servletRequest" />
         <uix:tableLayout cellSpacing="5" width="100%">
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" width="10%"/>
              <uix:cellFormat hAlign="right" vAlign="top">
               <uix:rowLayout vAlign="top"> 
                 <%@ include file="refreshTime.jspf" %>
               </uix:rowLayout>
             </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat vAlign="top" hAlign="left" width="10%">
                <uix:header textBinding="GENERAL@obBundle@servletRequest" size="1">
		
		<uix:stackLayout>
		    <uix:tableLayout cellSpacing="5" width="100%">
                      <uix:switcher childNameBinding="adminStatus@obBean@servletRequest">
                        <uix:case name="Not in service">
		          <uix:rowLayout>
                            <uix:cellFormat hAlign="right" >
                              <uix:styledText styleClass="OraInstructionText" 
			                      textBinding="STATUS@obBundle@servletRequest" />
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center" width="2%">
                              <uix:image source="/em/images/database/ob/notinservice.gif" 
			                 shortDescBinding="STATUS_TIP@obBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraInstructionText" 
			                      textBinding="NOTINSERVICE@obBundle@servletRequest" />
                             </uix:cellFormat>
			  </uix:rowLayout>
                        </uix:case>
                        <uix:case name="In service">
			  <uix:rowLayout>
                            <uix:cellFormat hAlign="right" >
                              <uix:styledText styleClass="OraInstructionText" 
			                      textBinding="STATUS@obBundle@servletRequest" />
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="center" width="2%">
                              <uix:image source="/em/images/database/ob/inservice.gif" 
			                 shortDescBinding="adminStatus@obBean@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:styledText styleClass="OraInstructionText" 
			                      textBinding="INSERVICE@obBundle@servletRequest" />
                            </uix:cellFormat>
			  </uix:rowLayout>
                        </uix:case>
		      </uix:switcher>
		      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" width="5%">
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="HOST@obBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="center" width="2%"/>
                        <uix:cellFormat hAlign="left" >
                           <db:link textBinding="adminNameShort@obBean@servletRequest"
                                    destinationBinding="hostLink@obBean@servletRequest" 
                                     copyParams="adminName,target,type"/>
                        </uix:cellFormat>
		      </uix:rowLayout>
		      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" >
                          <uix:styledText styleClass="OraInstructionText" text="Version" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="center" width="2%"/>
                        <uix:cellFormat hAlign="left" width="31%" >
                          <uix:styledText styleClass="OraInstructionText"
                                         textBinding="obVersion@obBean@servletRequest" />
                        </uix:cellFormat>
		      </uix:rowLayout>
		      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" >
                          <uix:styledText styleClass="OraInstructionText" textBinding="SETTINGS@obBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="center" width="2%"/>
                        <uix:cellFormat hAlign="left" width="31%" >
                        <uix:link textBinding="EDIT@obBundle@servletRequest"
                             onClick="submitForm('foo', true, {event:'doLoad',pageNum:'22'})"/>
                        </uix:cellFormat>
		      </uix:rowLayout>
		    </uix:tableLayout>
		  </uix:stackLayout>

		</uix:header>
              </uix:cellFormat>
              <uix:cellFormat vAlign="top" hAlign="left" width="10%">
                <uix:header textBinding="RESOURCES@obBundle@servletRequest" size="1">

		 <uix:stackLayout>
		    <uix:tableLayout cellSpacing="5" width="100%">
		      <uix:rowLayout>
                        <uix:cellFormat hAlign="center" width="30%">
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="INTERRUPTED_OPS@obBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="3%">
                          <uix:link textBinding="userInputPending@obBean@servletRequest" 
                                   targetFrame="_new"
                                   destinationBinding="phpJobIPLink@obBean@servletRequest"/>
                        </uix:cellFormat>
		      </uix:rowLayout>
 
		      <uix:rowLayout>
                        <uix:cellFormat hAlign="center" width="30%">
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="WAITING_OPS@obBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="3%">
                          <uix:link textBinding="pending@obBean@servletRequest" 
                                   targetFrame="_new"
                                   destinationBinding="phpJobPLink@obBean@servletRequest"/>
                        </uix:cellFormat>
		      </uix:rowLayout>
                   </uix:tableLayout>
		 </uix:stackLayout>

		</uix:header>
              </uix:cellFormat>
            </uix:rowLayout>
         </uix:tableLayout>
      <uix:header textBinding="DEVICES@obBundle@servletRequest" size="1"/>
         <uix:tableLayout cellSpacing="5" width="100%">
              <uix:switcher childNameBinding="problemDeviceCount@obBean@servletRequest">
                 <uix:case name="0">
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="middle">
                          <uix:styledText styleClass="OraPromptText"
                                    textBinding="VIEW_DEVICE@obBundle@servletRequest"/>
                          <uix:spacer width="2"/>
                          <uix:choice name="deviceListOptions"
                              onChange="submitForm('foo', true, {'event':'adminObject'})"
                              shortDescBinding="VIEW_DEVICE@obBundle@servletRequest"
                              disabledBinding="readOnly@obBean@servletRequest"
                              selectedValueBinding="optype@obBean@servletRequest">
                              <uix:option textBinding="PROBLEM_DEVICES@obBundle@servletRequest" value="probDevices"/>
                              <uix:option textBinding="ACTIVE_DEVICES@obBundle@servletRequest" value="activeDevices"/>
                              <uix:option textBinding="ALL_DEVICES@obBundle@servletRequest" value="allDevices"/>
                          </uix:choice>
                             <uix:spacer width="20"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="PROBLEM@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="problemDeviceCount@devicesBean@obBean@servletRequest"/>
                             <uix:spacer width="15"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="ACTIVE@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="activeDeviceCount@devicesBean@obBean@servletRequest"/>
                             <uix:spacer width="15"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="TOTAL@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="allDeviceCount@devicesBean@obBeanservletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                 </uix:case>
                 <uix:default>
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="middle">
                          <uix:styledText styleClass="OraPromptText"
                                    textBinding="VIEW_DEVICE@obBundle@servletRequest"/>
                          <uix:spacer width="2"/>
                          <uix:choice name="deviceListOptions"
                              onChange="submitForm('foo', true, {'event':'adminObject'})"
                              shortDescBinding="VIEW_DEVICE@obBundle@servletRequest"
                              disabledBinding="readOnly@obBean@servletRequest"
                              selectedValueBinding="optype@obBean@servletRequest">
                              <uix:option textBinding="PROBLEM_DEVICES@obBundle@servletRequest" value="probDevices"/>
                              <uix:option textBinding="ACTIVE_DEVICES@obBundle@servletRequest" value="activeDevices"/>
                              <uix:option textBinding="ALL_DEVICES@obBundle@servletRequest" value="allDevices"/>
                          </uix:choice>
                             <uix:spacer width="10"/>
                             <uix:image source="/em/images/criticalind_status.gif"
                                   shortDescBinding="mediaserverTip@obBean@servletRequest"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="PROBLEM@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="problemDeviceCount@devicesBean@obBean@servletRequest"/>
                             <uix:spacer width="15"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="ACTIVE@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="activeDeviceCount@devicesBean@obBean@servletRequest"/>
                             <uix:spacer width="15"/>
                             <uix:styledText styleClass="OraPromptText"
                                             textBinding="TOTAL@obBundle@servletRequest"/>
                             <uix:spacer width="5"/>
                             <uix:styledText styleClass="OraDataText"
                                             textBinding="allDeviceCount@devicesBean@obBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                 </uix:default>
              </uix:switcher>
         </uix:tableLayout>

               <uix:hGrid id="devicesUI"
                    width="100%"
                    formSubmitted="true"
                    treeDataBinding="treeData@devicesDataSourceBean@servletRequest"
                    columnHeaderDataBinding="columnHeaderData@devicesDataSourceBean@servletRequest"
                    columnFormatsBinding="columnFormatData@devicesDataSourceBean@servletRequest"
                    alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest"
                    summaryBinding="MANAGE_DEVICES@obBundle@servletRequest"
                    proxyBinding="proxy@servletRequest">
                                                                                
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="NAME@obBundle@servletRequest"
                          sortableBinding="firstColSortState@devicesDataSourceBean@servletRequest"
                          valueBinding="firstColSortIndex@devicesDataSourceBean@servletRequest"/>
                      </uix:columnHeader>
                    </uix:column>
                  </uix:nodeStamp>
                                                                                
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text"
                      sortableBinding="sortState"
                      valueBinding="sortIndex"/>
                  </uix:columnHeaderStamp>
                                                                                
                  <uix:styledText textBinding="type"/>
                  <uix:styledText textBinding="dte"/>
                  <uix:image sourceBinding="status" shortDescBinding="STATUS@obBundle@servletRequest"/>
                  <uix:styledText textBinding="state"/>
                  <uix:styledText textBinding="clean"/>
                  <uix:styledText textBinding="host"/>
                  <uix:styledText textBinding="vendor"/>
                  <uix:styledText textBinding="firmware"/>

                  <%-- Support for selected item. --%>
                  <uix:formValue name="itemName" valueBinding="text"/>
              </uix:hGrid>
          </uix:contents>

          <uix:spacer height="10"/>
           <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest" size="1">
             <uix:tableLayout hAlign="center" cellSpacing="0" width="100%">
               <uix:rowLayout>
                  <uix:cellFormat hAlign="left" width="15%">
                    <db:link textBinding="DATABASE_BACKUPS@obBundle@servletRequest"
                           destinationBinding="jobLink@obBean@servletRequest"/>
                 </uix:cellFormat>
                 <uix:cellFormat hAlign="left" width="15%" >
                    <db:link textBinding="ALERTS@obBundle@servletRequest"
                           destinationBinding="alertsLink@obBean@servletRequest"/>
                  </uix:cellFormat>
               </uix:rowLayout>
             </uix:tableLayout>
           </uix:header>

          </uix:subTabLayout>
        </uix:contents>

        </uix:header>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
