<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="adminName,target,type"> 
    <uix:formValue name="pageNum" value="21"/>
    <uix:formValue name="origAdmin" valueBinding="settingsName@obBean@servletRequest"/>
    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="returnUrl" valueBinding="returnUrl@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
         <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

         <uix:switcher childNameBinding="introText@obBean@servletRequest">
           <uix:case name="yes">
             <uix:contentContainer textBinding="NEW_ADMIN_HEADING@obBundle@servletRequest" width="100%" icon="/em/images/infoicon_active.gif">
                <uix:contents>
                 <uix:stackLayout>
                  <uix:contents>
                   <uix:styledText styleClass="OraInstructionText"
                        textBinding="NEW_ADMIN_OVERVIEW@obBundle@servletRequest"/>
                  </uix:contents>
                 </uix:stackLayout>
                </uix:contents>
              </uix:contentContainer>
             <uix:spacer height="10" />
           </uix:case>
         </uix:switcher>

         <uix:header textBinding="adminName@obBean@servletRequest">
           <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
                <uix:styledText textBinding="text@obBean@servletRequest"
                             styleClass="OraInstructionText" />
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
                <uix:spacer height="10"/>
              </uix:cellFormat>
            </uix:rowLayout>
           </uix:tableLayout>

               <uix:switcher childNameBinding="status@obBean@servletRequest">
                 <uix:case name="addAdminds">
                   <uix:labeledFieldLayout width="70%" labelWidth="25%">
                    <uix:contents>
                     <uix:messageTextInput name="adminHostName"
                                           readOnly="true"
                                           textBinding="settingsName@obBean@servletRequest"
                                           promptBinding="AH_SELECTOR@obBundle@servletRequest"
                                           shortDescBinding="settingsName@obBean@servletRequest"
                                           styleClass="OraDataText"
                                           columns="30"/>
                     <uix:messageTextInput name="installPath"
                                           textBinding="settingsPath@obBean@servletRequest"
                                           promptBinding="INSTALL_PATH@obBundle@servletRequest"
                                           shortDescBinding="settingsPath@obBean@servletRequest"
                                           tipBinding="INSTALL_PATH_TIP@obBundle@servletRequest"
                                           columns="60"/>
                    </uix:contents>

                     <uix:switcher childNameBinding="status@obBean@servletRequest">
                       <uix:case name="updateAdmin">
                         <uix:checkBox name="msr"
                                       value="true"
                                       textBinding="MS_ROLE@obBundle@servletRequest"
                                       checkedBinding="msRole@obBean@servletRequest"/>
                       </uix:case>
                     </uix:switcher>
                   </uix:labeledFieldLayout>
                 </uix:case>
                 <uix:case name="addAdmin">
                   <uix:labeledFieldLayout width="70%" labelWidth="25%">
                    <uix:contents>
                      <uix:messagePrompt labeledNodeId="hvrt"  promptBinding="AH_SELECTOR@obBundle@servletRequest"/>
                      <uix:lovInput name="adminHostName" 
                                    id="hvrt"
                                    columns="30"  
                                    destinationBinding="dest@obBean@servletRequest"
                                    searchDescBinding="settingsName@obBean@servletRequest"
                                    textBinding="settingsName@obBean@servletRequest" />
                     <uix:messageTextInput name="installPath"
                                           textBinding="settingsPath@obBean@servletRequest"
                                           promptBinding="INSTALL_PATH@obBundle@servletRequest"
                                           shortDescBinding="settingsPath@obBean@servletRequest"
                                           tipBinding="INSTALL_PATH_TIP@obBundle@servletRequest"
                                           columns="60"/>
                    </uix:contents>
                   </uix:labeledFieldLayout>
                 </uix:case>
                 <uix:case name="updateAdmin">
                   <uix:labeledFieldLayout width="70%" labelWidth="25%">
                    <uix:contents>
                     <uix:messageStyledText promptBinding="AH_SELECTOR@obBundle@servletRequest"
                                            styleClass="OraDataText"
                                            textBinding="settingsName@obBean@servletRequest"/>
                     <uix:messageTextInput name="installPath"
                                           textBinding="settingsPath@obBean@servletRequest"
                                           promptBinding="INSTALL_PATH@obBundle@servletRequest"
                                           shortDescBinding="settingsPath@obBean@servletRequest"
                                           tipBinding="INSTALL_PATH_TIP@obBundle@servletRequest"
                                           columns="60"/>
                     <uix:switcher childNameBinding="status@obBean@servletRequest">
                       <uix:case name="updateAdmin">
                         <uix:checkBox name="msr"
                                       value="true"
                                       textBinding="MS_ROLE@obBundle@servletRequest"
                                       checkedBinding="msRole@obBean@servletRequest"/>
                       </uix:case>
                     </uix:switcher>
                    </uix:contents>
                   </uix:labeledFieldLayout>
                 </uix:case>
               </uix:switcher>
        </uix:header>

        <uix:pageButtons>
          <uix:pageButtonBar>
                  <uix:flowLayout>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelAH"
                                      formName="foo"/>
                    <uix:spacer width="5" />
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitAdminHost"
                                      formName="foo"/>
                  </uix:flowLayout>

          </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
