<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="35"/>
    <uix:formValue name="opageNum" valueBinding="actionObject@obBean@servletRequest"/>
    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="newdn" valueBinding="dn@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="ADD_ATTACHMENTS@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="100%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="HEADING_ATTACHMENTS@obBundle@servletRequest" />
            </uix:cellFormat>
         </uix:rowLayout>

          <uix:header textBinding="SETTINGS@obBundle@servletRequest">
            <uix:labeledFieldLayout width="55%">
              <uix:contents>
                <uix:messagePrompt promptBinding="MS_HOSTS@obBundle@servletRequest"/>
                <uix:stackLayout>
                  <oem:choice name="host"
                              shortDescBinding="MS_HOSTS@obBundle@servletRequest"
                              optionsBinding="obMS@obBean@servletRequest"/>
                  <uix:styledText styleClass="OraInlineInfoText"
                                  textBinding="ATT_MS@obBundle@servletRequest"/>
                </uix:stackLayout>
                <uix:messageTextInput name="file"
                                      promptBinding="RAW_DEVICE@obBundle@servletRequest"
                                      shortDescBinding="RAW_DEVICE@obBundle@servletRequest"
                                      tipBinding="RAW_DEVICE_TIP@obBundle@servletRequest"
                                      columns="30"/>
              </uix:contents>
            </uix:labeledFieldLayout>

            <uix:header textBinding="NDMP_SETTINGS@obBundle@servletRequest">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="ATT_NDMP_WARNING@obBundle@servletRequest" />
              <uix:labeledFieldLayout width="65%">
                <uix:contents>
                  <uix:messageTextInput name="stdevice"
                                        promptBinding="ST_DEVICE@obBundle@servletRequest"
                                        shortDescBinding="ST_DEVICE@obBundle@servletRequest"
                                        tipBinding="ST_DEVICE_TIP@obBundle@servletRequest"
                                        columns="30"/>
                  <uix:messageTextInput name="sttarget"
                                        promptBinding="ST_TARGET@obBundle@servletRequest"
                                        shortDescBinding="ST_TARGET@obBundle@servletRequest"
                                        tipBinding="ST_TARGET_TIP@obBundle@servletRequest"
                                        columns="10"/>
                  <uix:messageTextInput name="stcontroller"
                                        promptBinding="ST_CONTROLLER@obBundle@servletRequest"
                                        shortDescBinding="ST_CONTROLLER@obBundle@servletRequest"
                                        tipBinding="ST_CONTROLLER_TIP@obBundle@servletRequest"
                                        columns="10"/>
                  <uix:messageTextInput name="stlun"
                                        promptBinding="ST_LUN@obBundle@servletRequest"
                                        shortDescBinding="ST_LUN@obBundle@servletRequest"
                                        tipBinding="ST_LUN_TIP@obBundle@servletRequest"
                                        columns="10"/>
                  <uix:messageTextInput name="scsidevice"
                                        promptBinding="SCSI_DEVICE@obBundle@servletRequest"
                                        shortDescBinding="SCSI_DEVICE@obBundle@servletRequest"
                                        tipBinding="SCSI_DEVICE_TIP@obBundle@servletRequest"
                                        columns="30"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:header>
          </uix:header>
        </uix:header>

        <uix:pageButtons>
          <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="canelAttachments"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitAttachments"
                                      formName="foo"/>

          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
