<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob"  copyParams="target,type"> 

    <uix:formValue name="pageNum" value="56"/>
    <uix:formValue name="prevpage" value="brjobs"/>


     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="BKP_RST_JOBS_PAGE_TITLE@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="middle">
              <uix:rowLayout>
                <%@ include file="refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:cellFormat>
         </uix:rowLayout>
        <uix:spacer width="10px"/>
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="right" vAlign="middle"  width="5%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="STATUS@obBundle@servletRequest" />
            <uix:spacer width="5"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" vAlign="middle">
                    <uix:choice name="viewOptions"
                        onChange="submitForm('foo', true, {'event':'brjobs'})"
                        shortDescBinding="SELECT@obBundle@servletRequest"
                        selectedValueBinding="optype@obBean@servletRequest">
                        <uix:option textBinding="ALL_JOBS@obBundle@servletRequest" value="all"/>
                        <uix:option textBinding="ACTIVEJ@obBundle@servletRequest" value="active"/>
                        <uix:option textBinding="USER_INPUT_REQUESTED@obBundle@servletRequest" value="inputrequested"/>
                        <uix:option textBinding="PENDING@obBundle@servletRequest" value="pending"/>
                        <uix:option textBinding="COMPLETE@obBundle@servletRequest" value="complete"/>
                        <uix:option textBinding="FAILED@obBundle@servletRequest" value="failed"/>
                    </uix:choice>
            </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="right" vAlign="middle"  width="90%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="VIEW@obBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" vAlign="middle" width="3%">
              <uix:spacer width="5"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" vAlign="middle" width="5%">
                    <uix:choice name="viewfilter"
                        onChange="submitForm('foo', true, {'event':'brjobs'})"
                        shortDescBinding="SELECT@obBundle@servletRequest"
                        selectedValueBinding="filter@jobBean@obBean@servletRequest">
                        <uix:option textBinding="ALL@obBundle@servletRequest" value="all"/>
                        <uix:option textBinding="FILTER_LAST_24_HOURS@obBundle@servletRequest" value="24hours"/>
                        <uix:option textBinding="FILTER_LAST_7_DAYS@obBundle@servletRequest" value="7days"/>
                        <uix:option textBinding="FILTER_LAST_MONTH@obBundle@servletRequest" value="month"/>
                    </uix:choice>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" vAlign="middle">
            </uix:cellFormat>
         </uix:rowLayout>
        <uix:stackLayout>
        <uix:contents>
              <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                name="jobUI"
                id="jobUI"
                dataSourceProp="jobUI"
                beanKey="brjobDataSourceBean"
                copyParams="target,type,adminName"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedJob@jobBean@obBean@servletRequest">
                  <uix:submitButton
                      formName="foo"
                      textBinding="VIEW_TRANSCRIPT@obBundle@servletRequest"
                      name="event"
                      value="viewTranscript"/>
                  <uix:spacer width="2px"/>
                  <uix:submitButton
                      formName="foo"
                      textBinding="RUN@obBundle@servletRequest"
                      name="event"
                      value="runJob"/>
                  <uix:spacer width="2px"/>
                  <uix:submitButton
                      formName="foo"
                      textBinding="CANCEL_JOB@obBundle@servletRequest"
                      name="event"
                      value="cancelJob"/>
                  <uix:spacer width="2px"/>
                  <uix:submitButton
                      formName="foo"
                      textBinding="REMOVE@obBundle@servletRequest"
                      name="event"
                      value="confirmRemoveJob"/>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>
          </uix:contents>
          </uix:stackLayout>
        </uix:header>
        <uix:spacer height="10"/>

        <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="70%">
            <uix:rowLayout>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="EM_JOB_LINK@obBundle@servletRequest"
                           destination="/console/jobs/jobsTable"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="BACKUP_REPORTS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'gotoFSBkprpt',pageNum:'100'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="DEVICES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'7'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="MANAGE_VOLUMES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'5'})"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>


      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
