<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<script>

  function myCallBack(lovWindow, event)
  {
    return true;
  }

  function setLovName(name)
  {
    document.forms[0].lovName.value = name;
  }

</script>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsbackup" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="81"/>
    <uix:formValue name="source"/>
    <uix:formValue name="value" />
    <uix:formValue name="lovName"/>
    <uix:formValue name="selFileName"/>

     <uix:pageLayout titleBinding="pageHeader@fsBackupBean@servletRequest">
       <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/ob/backupTrainMessages.jspf" %>

       <uix:switcher childNameBinding="modeScript@datasetDetailsDS@fsBackupBean@servletRequest">
        <uix:case name="true"> 
          <uix:labeledFieldLayout width="75%">
            <uix:messageTextInput name="datasetName"
                 id="datasetName"
                 promptBinding="DS_NAME@obBundle@servletRequest"
                 styleClass="OraInstructionText"
                 textBinding="datasetName@datasetDetailsDS@fsBackupBean@servletRequest"
                 tipBinding="DS_NAME_TIP1@obBundle@servletRequest" 
                 disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                 required="no"/>
               <%--uix:messagePrompt labeledNodeId="datasetScript" required="yes" 
                   promptBinding="DS_SCRIPT@obBundle@servletRequest"/--%>
               <uix:messageTextInput name="datasetScript"
                   id="datasetScript"
                   styleClass="OraInstructionText"
                   columns="50"
                   rows="10"
                   promptBinding="DS_SCRIPT@obBundle@servletRequest"
                   tipBinding="ONLY_SCRIPT_SUPPORT_TEXT@obBundle@servletRequest" 
                   textBinding="datasetScript@datasetDetailsDS@fsBackupBean@servletRequest"
                   disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                   required="yes"/>

          </uix:labeledFieldLayout>
        </uix:case>
        <uix:case name="false"> 
         <uix:stackLayout>
          <uix:labeledFieldLayout width="75%">
            <uix:messageTextInput name="datasetName"
                 id="datasetName"
                 promptBinding="DS_NAME_OPTIONAL@obBundle@servletRequest"
                 styleClass="OraInstructionText"
                 textBinding="datasetName@datasetDetailsDS@fsBackupBean@servletRequest"
                 tipBinding="DS_NAME_TIP1@obBundle@servletRequest" 
                 disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                 required="no"/>
          </uix:labeledFieldLayout>

          <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                          <uix:submitButton textBinding="ADD_ROW@obBundle@servletRequest"
                                            shortDescBinding="ADD_ROW@obBundle@servletRequest"
                                            name="event"
                                            disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                                            value="addDSRow"/>
              </uix:cellFormat>
           </uix:rowLayout>

          <uix:table name="datasetPathTable"
                     id="datasetPathTable"
                     width="100%"
                     tableDataBinding="datasetPathList@datasetDetailsDS@fsBackupBean@servletRequest"
                     formSubmitted="true"
                     summaryBinding="BKP_DS_PANEL_HEADER@obBundle@servletRequest"
                     showAll="yes"
                     alternateTextBinding="NONE@obBundle@servletRequest">
                    <uix:tableSelection>
                       <uix:multipleSelection 
                            shortDescBinding="SELECT@obBundle@servletRequest"
                            disabledBinding="readOnlyDataset@fsBackupBean@servletRequest">
                          <uix:submitButton textBinding="DELETE_ROW@obBundle@servletRequest"
                                            shortDescBinding="DELETE_ROW@obBundle@servletRequest"
                                            name="event"
                                            disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                                            value="deleteDSRow"/>
                       </uix:multipleSelection>
                    </uix:tableSelection>
 
                    <uix:tableFormat tableBanding="rowBanding"/>
                       <uix:column>
                         <uix:columnHeader>
                            <uix:styledText textBinding="HOST_NAME@obBundle@servletRequest"/>
                         </uix:columnHeader>
                         <uix:contents>
                           <uix:tableLayout>
                              <uix:cellFormat>
                               <uix:switcher childNameBinding="showLovForHosts@fsBackupBean@servletRequest">
                               <uix:case name="true">
                                  <uix:lovInput name="hostname" id="lovDatasetHosts"
                                       textBinding="clmn_host"
                                       disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                                       columns="20"
                                       destinationBinding="host_lov_url"
                                       noAutoComplete="true"/>
                                </uix:case>
                               <uix:default>
                                 <oem:choice name="hostname"
                                     optionsBinding="obHostList@fsBackupBean@servletRequest"
                                     disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                                     onChange="submitForm('foo',true, {event:'changeHostSel'})"
                                     selectedValueBinding="clmn_host"/>
                                </uix:default>
                               </uix:switcher>
                              </uix:cellFormat>
                           </uix:tableLayout>
                         </uix:contents>
                      </uix:column>
                       <uix:column>
                         <uix:columnHeader>
                            <uix:styledText textBinding="INCLUDED_PATH@obBundle@servletRequest"/>
                         </uix:columnHeader>
                         <uix:contents>
                           <uix:tableLayout>
                              <uix:cellFormat>
                               <uix:switcher childNameBinding="enableRfs">
                                <uix:default>
                                   <uix:textInput name="includedpath"
                                     columns="50"
                                     textBinding="clmn_includepath"
                                     disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"/>
                                </uix:default>
                                <uix:case name="true">
                                   <uix:lovField name="includedpath"
                                     columns="50"
                                     textBinding="clmn_includepath"
                                     disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                                     onClickBinding="include_lov_script"/>
                                </uix:case>
                               </uix:switcher>
                              </uix:cellFormat>
                           </uix:tableLayout>
                         </uix:contents>
                      </uix:column>
                      <uix:column>
                         <uix:columnHeader>
                            <uix:styledText textBinding="EXCLUDED_PATH@obBundle@servletRequest"/>
                         </uix:columnHeader>
                         <uix:contents>
                           <uix:tableLayout>
                              <uix:cellFormat>
                               <uix:switcher childNameBinding="enableRfs">
                                <uix:default>
                                    <uix:textInput name="excludedpath"
                                     columns="50"
                                     textBinding="clmn_excludepath"
                                     disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"/>
                                </uix:default>
                                <uix:case name="true">
                                <uix:lovField name="excludedpath"
                                     columns="50"
                                     textBinding="clmn_excludepath"
                                     disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                                     onClickBinding="exclude_lov_script"/>
                                </uix:case>
                               </uix:switcher>
                              </uix:cellFormat>
                           </uix:tableLayout>
                         </uix:contents>
                      </uix:column>
             </uix:table>
             <uix:spacer height="5px"/>
             <uix:messageCheckBox name="includeCatalog"
                   textBinding="INCLUDE_CATALOG@obBundle@servletRequest"
                   disabledBinding="readOnlyDataset@fsBackupBean@servletRequest"
                   checkedBinding="includeCatalog@datasetDetailsDS@servletRequest" />   

           </uix:stackLayout>
         </uix:case>
       </uix:switcher>
         <uix:spacer height="10px"/>
         <uix:rowLayout width="100%"  renderedBinding="readOnlyDataset@fsBackupBean@servletRequest">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="NO_MOD_DATASET_TIP@obBundle@servletRequest"/>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%" renderedBinding="modeGui@datasetDetailsDS@fsBackupBean@servletRequest">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:stackLayout>
                      <uix:styledText styleClass="OraInstructionText"
                                  textBinding="EM_HOST_ONLY_BROWSE_TIP@obBundle@servletRequest"/>
                      <uix:styledText styleClass="OraInstructionText"
                                  textBinding="DATASET_ADD_TIP1@obBundle@servletRequest"/>
                      <uix:styledText styleClass="OraInstructionText"
                                  textBinding="DATASET_ADD_TIP2@obBundle@servletRequest"/>
                  </uix:stackLayout>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@obBundle@servletRequest"/>
                          <uix:submitButton textBinding="EDIT@obBundle@servletRequest"
                                            name="event"
                                            renderedBinding="readOnlyDataset@fsBackupBean@servletRequest"
                                            value="editDS"
                                            shortDescBinding="EDIT@obBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@fsBackupBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@fsBackupBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
