<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsbackup" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="80"/>
    <uix:formValue name="source"/>
    <uix:formValue name="value" valueBinding="pageSequence@fsBackupBean@servletRequest"/>
    <uix:formValue name="pageSeq" valueBinding="pageSequence@fsBackupBean@servletRequest"/>

     <uix:pageLayout titleBinding="pageHeader@fsBackupBean@servletRequest">
       <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/ob/backupTrainMessages.jspf" %>

   <uix:tableLayout>
     <uix:contents>
     <uix:rowLayout>
      <uix:contents>

       <uix:cellFormat vAlign="top" width="60%">
        <uix:contents>

       <uix:tableLayout cellSpacing="5">
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
                <uix:messageRadioButton name="backupMode" value="tempDS"
                     selectedValueBinding="backupMode@fsBackupBean@servletRequest"
                     textBinding="BKP_SPY_FILES_DIR@obBundle@servletRequest"
                     shortDescBinding="SELECT_TEMP_DATASET_TIP@obBundle@servletRequest"
                     styleClass="OraInstructionText" />
            </uix:cellFormat>
         </uix:rowLayout>
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
                <uix:messageRadioButton name="backupMode" value="existingDS"
                     selectedValueBinding="backupMode@fsBackupBean@servletRequest"
                     disabledBinding="emptyDatasets@datasetDataSourceBean@servletRequest"
                     textBinding="BKP_SEL_DS@obBundle@servletRequest"
                     shortDescBinding="SELECT_EXISTING_DATASET_TIP@obBundle@servletRequest"
                     styleClass="OraInstructionText" />
            </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="center">
              <oem:table
                width="80%"
                blockSize="10"
                formSubmitted="true"
                id="datasetUI"
                name="datasetUI"
                dataSourceProp="datasetUI"
                beanKey="datasetDataSourceBean"
                copyParams="target,type,adminName"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                 <uix:tableSelection>
                   <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedDataset@datasetDataSourceBean@servletRequest">
                   </uix:singleSelection>
                 </uix:tableSelection>
               </oem:table>
           </uix:cellFormat>
         </uix:rowLayout>   
         <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:spacer height="5px"/>
                <uix:tip>
                  <uix:stackLayout>
                     <uix:styledText styleClass="OraInstructionText"
                                  textBinding="SELECT_DATASET@obBundle@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                  textBinding="SELECT_DATASET_TIP2@obBundle@servletRequest"/>
                  </uix:stackLayout>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>
       </uix:tableLayout>

         </uix:contents>
        </uix:cellFormat>
        <uix:cellFormat vAlign="top" hAlign="right">
         <uix:contents>

         <uix:contentContainer textBinding="OVERVIEW@obBundle@servletRequest" width="100%" icon="/em/images/infoicon_active.gif">
            <uix:contents>
             <uix:stackLayout>
              <uix:contents>
                 <uix:bulletedList>
                    <uix:styledText styleClass="OraInstructionText"
                      textBinding="BACKUP_OVERVIEW1@obBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                      textBinding="BACKUP_OVERVIEW2@obBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                      textBinding="BACKUP_OVERVIEW3@obBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                      textBinding="BACKUP_OVERVIEW4@obBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                      textBinding="BACKUP_OVERVIEW5@obBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                      textBinding="BACKUP_OVERVIEW6@obBundle@servletRequest"/>
                 </uix:bulletedList>
                </uix:contents>
               </uix:stackLayout>
              </uix:contents>
         </uix:contentContainer>
             
         </uix:contents>
        </uix:cellFormat>
       </uix:contents>
      </uix:rowLayout>
    </uix:contents>
   </uix:tableLayout>
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@obBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@fsBackupBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@fsBackupBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
