<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsbackup" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="82"/>
    <uix:formValue name="source"/>
    <uix:formValue name="value"/>

     <uix:pageLayout titleBinding="pageHeader@fsBackupBean@servletRequest">
       <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/ob/backupTrainMessages.jspf" %>

       <uix:header textBinding="OB_BKWIZ_LEVEL@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
                <uix:messageRadioButton name="levelType" value="full"
                     selectedValueBinding="levelType@fsBackupBean@servletRequest"
                     textBinding="FULL@obBundle@servletRequest"
                     tipBinding="BKP_SEL_LEV_FULL_DESC@obBundle@servletRequest"
                     styleClass="OraInstructionText" />
            </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" width="20%">
                <uix:messageRadioButton name="levelType" value="incr"
                     selectedValueBinding="levelType@fsBackupBean@servletRequest"
                     textBinding="INCR@obBundle@servletRequest"
                     tipBinding="BKP_LEV_INCR_DESC@obBundle@servletRequest"
                     styleClass="OraInstructionText" />
                <uix:spacer width="20"/>
                <uix:choice name="incrLevel" 
                            selectedValueBinding="incrLevel@fsBackupBean@servletRequest">

                            <uix:contents childDataBinding="availableIncrLevels@fsBackupBean@servletRequest">
                                <uix:option textBinding="text" valueBinding="val" />
                            </uix:contents>
                    </uix:choice>
            </uix:cellFormat>
         </uix:rowLayout>
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
                <uix:messageRadioButton name="levelType" value="offsite"
                     selectedValueBinding="levelType@fsBackupBean@servletRequest"
                     textBinding="OFFSITE@obBundle@servletRequest"
                     tipBinding="BKP_SEL_LEV_OFFSITE_DESC@obBundle@servletRequest"
                     styleClass="OraInstructionText" />
            </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>
       </uix:header>
       <uix:header textBinding="MF@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="MEDIA_FAMILY_TIP@obBundle@servletRequest" />

            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
              <uix:stackLayout>
                <uix:lovInput name="mediaFamily" id="lovMediaFamily"
                   shortDescBinding="MEDIA_FAMILY_TIP2@obBundle@servletRequest"
                   textBinding="mediaFamily@fsBackupBean@servletRequest"
                   columns="20"
                   partialRenderMode="self"
                   destinationBinding="mediafamilyLovUrl@fsBackupBean@servletRequest" 
                   noAutoComplete="true"/>
                <uix:styledText styleClass="OraInlineInfoText" textBinding="MEDIA_FAMILY_TIP2@obBundle@servletRequest"/>
              </uix:stackLayout>
            </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>
       </uix:header>
       <uix:header textBinding="POLICY@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
               <uix:messageCheckBox name="privilegedUser"
                   textBinding="BKP_PREV_USER@obBundle@servletRequest"
                   tipBinding="BACKUP_PREVI_TIP@obBundle@servletRequest"
                   checkedBinding="privilegedUser@fsBackupBean@servletRequest" />

            </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
          <uix:cellFormat hAlign="left">
            <uix:messagePrompt labeledNodeId="priority"
              promptBinding="OB_BKWIZ_PRI@obBundle@servletRequest"/>

            <oem:choice name="priority"
                 id="priority"
                 shortDescBinding="PRIORITY_TIP@obBundle@servletRequest"
                 optionsBinding="priorityOptions@fsBackupBean@servletRequest"
                 selectedValueBinding="priority@fsBackupBean@servletRequest"/>
            </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="80%">
            <uix:cellFormat hAlign="left">
               <uix:styledText styleClass="OraInlineInfoText" textBinding="PRIORITY_TIP@obBundle@servletRequest"/>
            </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>
       </uix:header>
       <uix:header textBinding="ENCRYPTION@obBundle@servletRequest"
                    renderedBinding="verEqlOrAbove10_2@fsBackupBean@servletRequest">
      <%--uix:hideShow id="panelAdvancedOptions"
            formSubmitted="true" 
            disclosedTextBinding="SECURITY_OPTIONS@obBundle@servletRequest"
            undisclosedTextBinding="SHOW_ADV@obBundle@servletRequest"
            unvalidated="false"
            disclosedBinding="showAdvancedOptions@fsBackupBean@servletRequest"
            renderedBinding="verEqlOrAbove10_2@fsBackupBean@servletRequest"--%>
        <uix:tableLayout cellSpacing="5">
         <uix:rowLayout width="100%">
          <uix:cellFormat hAlign="left" columnSpan="2">
              <uix:messageRadioButton name="encPolicy" value="no"
                     selectedValueBinding="encPolicy@fsBackupBean@servletRequest"
                     textBinding="NO@obBundle@servletRequest"
                     tipBinding="ENC_NO_TIP@obBundle@servletRequest"
                     styleClass="OraInstructionText" />
            </uix:cellFormat>
         </uix:rowLayout>
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" columnSpan="2">
              <uix:messageRadioButton name="encPolicy" value="yes"
                     selectedValueBinding="encPolicy@fsBackupBean@servletRequest"
                     textBinding="YES@obBundle@servletRequest"
                     tipBinding="ENC_YES_TIP@obBundle@servletRequest"
                     styleClass="OraInstructionText" />
            </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
          <uix:cellFormat hAlign="left" columnSpan="2">
              <uix:messageRadioButton name="encPolicy" value="forcedoff"
                     selectedValueBinding="encPolicy@fsBackupBean@servletRequest"
                     textBinding="FORCED_OFF@obBundle@servletRequest"
                     tipBinding="ENC_FORCEDOFF_TIP@obBundle@servletRequest"
                     styleClass="OraInstructionText" />
            </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
          <uix:cellFormat hAlign="left" columnSpan="2">
                <uix:messageRadioButton name="encPolicy" value="transient"
                     selectedValueBinding="encPolicy@fsBackupBean@servletRequest"
                     textBinding="TRANSIENT@obBundle@servletRequest"
                     tipBinding="ENC_TRANSIENT_TIP@obBundle@servletRequest"
                     styleClass="OraInstructionText" />
            </uix:cellFormat>
         </uix:rowLayout>
       </uix:tableLayout>
       <uix:tableLayout cellSpacing="5">
         <uix:rowLayout width="100%">
          <uix:cellFormat width="2%"/>
          <uix:cellFormat hAlign="left" width="10%">
             <uix:messageTextInput name="passPhrase"
                     secret="true"
                     columns="10"
                     promptBinding="PASSPHRASE@obBundle@servletRequest"
                     textBinding="passPhrase@fsBackupBean@servletRequest"/>
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" width="10%">
             <uix:messageTextInput name="verifyPassPhrase"
                     secret="true"
                     columns="10"
                     promptBinding="CONFIRM_PASSPHRASE@obBundle@servletRequest"
                     textBinding="verifyPassPhrase@fsBackupBean@servletRequest"/>
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" width="10%">
                <uix:messageChoice name="encAlgo"
                      promptBinding="ENC_ALGO@obBundle@servletRequest"
                      selectedValueBinding="encAlgo@fsBackupBean@servletRequest">
                         <uix:option textBinding="ENC_ALGO_AES128@obBundle@servletRequest" value="aes128"/>
                         <uix:option textBinding="ENC_ALGO_AES192@obBundle@servletRequest" value="aes192"/>
                         <uix:option textBinding="ENC_ALGO_AES256@obBundle@servletRequest" value="aes256"/>
                 </uix:messageChoice>
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" width="10%">
                 <uix:messageCheckBox name="storeKey"
                     textBinding="STORE_KEY@obBundle@servletRequest"
                     checkedBinding="storeKey@fsBackupBean@servletRequest" />
           </uix:cellFormat>
           <uix:cellFormat width="10%"/>
         </uix:rowLayout>
        </uix:tableLayout>
        <uix:tip>
           <uix:styledText styleClass="OraInstructionText"
                textBinding="ENC_TRANSIENT_TIP2@obBundle@servletRequest"/>
        </uix:tip>
        <%--/uix:hideShow--%>
       </uix:header>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@obBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@fsBackupBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@fsBackupBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
