<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsbackup" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="85"/>
    <uix:formValue name="source"/>
    <uix:formValue name="value"/>

     <uix:pageLayout  titleBinding="pageHeader@fsBackupBean@servletRequest">
       <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/ob/backupTrainMessages.jspf" %>

     <uix:header textBinding="OB_BKWIZ_OPTIONS@obBundle@servletRequest">
       <uix:labeledFieldLayout width="75%">
            <uix:messagePrompt promptBinding="OB_BKWIZ_LEVEL@obBundle@servletRequest"/>
            <uix:switcher childNameBinding="levelType@fsBackupBean@servletRequest">
             <uix:case name="full">
               <uix:textInput 
                   styleClass="OraInstructionText"
                   textBinding="OB_BKWIZ_FULL@obBundle@servletRequest"
                   readOnly="true"/>
             </uix:case>
             <uix:case name="incr">
               <uix:textInput 
                   styleClass="OraInstructionText"
                   textBinding="incrLevelNumber@fsBackupBean@servletRequest"
                   readOnly="true"/>
             </uix:case>
             <uix:case name="offsite">
               <uix:textInput 
                   styleClass="OraInstructionText"
                   textBinding="OFFSITE@obBundle@servletRequest"
                   readOnly="true"/>
             </uix:case>
           </uix:switcher>
            <uix:messagePrompt promptBinding="MF@obBundle@servletRequest" renderedBinding="nonEmptyMediaFamily@fsBackupBean@servletRequest"/>
            <uix:textInput 
                 styleClass="OraInstructionText"
                 textBinding="mediaFamily@fsBackupBean@servletRequest"
                 renderedBinding="nonEmptyMediaFamily@fsBackupBean@servletRequest"
                 readOnly="true"/>
            <uix:messagePrompt promptBinding="BKP_PREV_USER@obBundle@servletRequest"/>
            <uix:switcher childNameBinding="privilegedUser@fsBackupBean@servletRequest">
             <uix:case name="true">
               <uix:textInput 
                   styleClass="OraInstructionText"
                   textBinding="YES@obBundle@servletRequest"
                   readOnly="true"/>
             </uix:case>
             <uix:case name="false">
               <uix:textInput 
                   styleClass="OraInstructionText"
                   textBinding="NO@obBundle@servletRequest"
                   readOnly="true"/>
             </uix:case>
           </uix:switcher>
            <uix:messagePrompt promptBinding="OB_BKWIZ_PRI@obBundle@servletRequest"/>
            <uix:textInput 
                styleClass="OraInstructionText"
                textBinding="priority@fsBackupBean@servletRequest"
                readOnly="true"/>

            <uix:messagePrompt promptBinding="DEVICE_POOL@obBundle@servletRequest"/>
            <uix:switcher childNameBinding="deviceUsage@fsBackupBean@servletRequest">
             <uix:case name="useany">
               <uix:textInput 
                  styleClass="OraInstructionText"
                  textBinding="DEFAULT@obBundle@servletRequest"
                  readOnly="true"/>
             </uix:case>
             <uix:default>
               <uix:textInput 
                  styleClass="OraInstructionText"
                  textBinding="devicePool@fsBackupBean@servletRequest"
                  readOnly="true"/>
             </uix:default>
            </uix:switcher> 
       </uix:labeledFieldLayout>
     </uix:header>

     <uix:header textBinding="RESTORE_JOB_DETAILS@obBundle@servletRequest">
       <uix:labeledFieldLayout width="75%">
            <uix:messagePrompt promptBinding="RESTORE_JOB_NAME@obBundle@servletRequest"/>
            <uix:textInput 
                 styleClass="OraInstructionText"
                 textBinding="jobName@fsBackupBean@servletRequest"
                 readOnly="true"/>
            <uix:messagePrompt promptBinding="RESTORE_JOB_DESC@obBundle@servletRequest"/>
            <uix:textInput 
                 styleClass="OraInstructionText"
                 textBinding="jobDesc@fsBackupBean@servletRequest"
                 readOnly="true"/>
            <%--uix:messagePrompt promptBinding="RESTORE_JOB_SCHEDULE@obBundle@servletRequest"/>
            <uix:textInput 
                 styleClass="OraInstructionText"
                 text="TBD"
                 readOnly="true"/--%>
       </uix:labeledFieldLayout>
     </uix:header>
     <uix:header textBinding="OB_BKWIZ_DS@obBundle@servletRequest">
       <uix:labeledFieldLayout width="75%">
            <uix:messageTextInput 
                styleClass="OraInstructionText"
                promptBinding="DS_NAME@obBundle@servletRequest"
                textBinding="datasetName@datasetDetailsDS@servletRequest"
                renderedBinding="nonEmptyDatasetName@datasetDetailsDS@servletRequest"
                readOnly="true"/>
            <uix:messageTextInput 
                styleClass="OraInstructionText"
                promptBinding="DS_SCRIPT@obBundle@servletRequest"
                textBinding="datasetScript@datasetDetailsDS@servletRequest"
                 columns="50"
                 rows="10"
                 readOnly="true"/>
       </uix:labeledFieldLayout>
     </uix:header>
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@obBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@fsBackupBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@fsBackupBean@servletRequest"/>
                </uix:contents>
                <uix:submitButton formName="foo" textBinding="SUBMIT_JOB@obBundle@servletRequest" name="event" value="submit" shortDescBinding="SUBMIT_JOB@obBundle@servletRequest"/>

              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
