<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="34"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="opageOp" valueBinding="actionObject@obBean@servletRequest"/>
    <uix:formValue name="newdn" valueBinding="dn@devicesBean@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

     <uix:header textBinding="deviceText@devicesBean@obBean@servletRequest">
       <uix:header textBinding="DEV_CONFIG@obBundle@servletRequest">
          <uix:styledText textBinding="text@obBean@servletRequest"
                          styleClass="OraInstructionText" />
          <uix:switcher childNameBinding="oldEvent@obBean@servletRequest">
            <uix:case name="editDevice">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="NAME@obBundle@servletRequest"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText
                       textBinding="dn@devicesBean@obBean@servletRequest"
                       styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="TYPE@obBundle@servletRequest"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText textBinding="dtype@devicesBean@obBean@servletRequest"
                                  styleClass="OraDataText"/>
                  <uix:formValue name="dtype" 
                                 valueBinding="ocn@devicesBean@obBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>

             </uix:tableLayout>
            </uix:case>
            <uix:case name="createLib">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText
                       labeledNodeId="dn"
                       textBinding="NAME@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput
                       name="dn"
                       id="dn"
                       columns="20"
                       textBinding="dn@devicesBean@obBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="TYPE@obBundle@servletRequest"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText textBinding="dtype@devicesBean@obBean@servletRequest"
                                  styleClass="OraDataText" />
                  <uix:formValue name="dtype" 
                                 valueBinding="ocn@devicesBean@obBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>

             </uix:tableLayout>
            </uix:case>
            <uix:case name="createDrive">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText
                       labeledNodeId="dn"
                       textBinding="NAME@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput
                       name="dn"
                       id="dn"
                       columns="20"
                       textBinding="dn@devicesBean@obBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="TYPE@obBundle@servletRequest"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText textBinding="dtype@devicesBean@obBean@servletRequest"
                                  styleClass="OraDataText" />
                  <uix:formValue name="dtype" 
                                 valueBinding="ocn@devicesBean@obBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>

             </uix:tableLayout>
            </uix:case>
          </uix:switcher>

       <uix:switcher childNameBinding="switch@obBean@servletRequest">
         <uix:case name="inv">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="status"
                                    textBinding="STATUS@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                    <uix:choice name="status"
                                id="status"
                                selectedValueBinding="status@obBean@servletRequest">
                      <uix:option textBinding="MS_STATUS_IS@obBundle@servletRequest" value="is"/>
                      <uix:option textBinding="MS_STATUS_NIS@obBundle@servletRequest" value="nis"/>
                    </uix:choice>
                    <uix:spacer width="5" />
                    <uix:checkBox name="dii" id="dii" value="yes" />
                    <uix:styledText labeledNodeId="dii"
                                    textBinding="DEV_IS_INV@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
               <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="STATUS_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
         </uix:case>
         <uix:case name="noinv">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="status"
                                    textBinding="STATUS@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                    <uix:choice name="status"
                                id="status"
                                selectedValueBinding="status@obBean@servletRequest">
                      <uix:option textBinding="MS_STATUS_IS@obBundle@servletRequest" value="is"/>
                      <uix:option textBinding="MS_STATUS_NIS@obBundle@servletRequest" value="nis"/>
                    </uix:choice>
                  </uix:cellFormat>
                </uix:rowLayout>
               <uix:rowLayout>
                 <uix:cellFormat hAlign="left">
                 </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="STATUS_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>

       <uix:switcher childNameBinding="ocn@devicesBean@obBean@servletRequest">
         <uix:case name="tape">
          <uix:header textBinding="TAPE_SETTINGS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="80%">

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="library" 
                  textBinding="LIBRARY_TYPE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <oem:choice
                   name="library"
                   id="library"
                   selectedValueBinding="library@devicesBean@obBean@servletRequest"
                   optionsBinding="obAdminHosts@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="LIBRARY_TYPE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="dte" 
                  textBinding="DTE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput name="dte"
                      id="dte"
                      columns="5"
                      textBinding="dte@devicesBean@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="DTE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>
          </uix:tableLayout>

          <uix:hideShow id="hideShow"
                        formSubmitted="true" 
                        disclosedTextBinding="HIDE_ADV@obBundle@servletRequest"
                        undisclosedTextBinding="SHOW_ADV@obBundle@servletRequest"
                        unvalidated="false"
                        disclosedBinding="advancedOptions@obBean@servletRequest">

          <uix:tableLayout cellSpacing="5" width="80%">
           <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText
                   textBinding="AUTOMOUNT@obBundle@servletRequest"
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="automount"
                               value="yes"
                               id="amyes"
                               selectedValueBinding="automount@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="amyes" 
                              textBinding="LC_YES@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
              <uix:radioButton name="automount"
                               value="no"
                               id="amno"
                               selectedValueBinding="automount@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="amno" textBinding="LC_NO@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="AUTOMOUNT_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="errorRate" 
                  textBinding="ERROR_RATE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput name="errorRate"
                      id="errorRate"
                      columns="5"
                      textBinding="errorRate@devicesBean@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="ERROR_RATE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="blockingFactor" 
                  textBinding="BLOCKING_FACTOR@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput name="blockingFactor"
                      id="blockingFactor"
                      columns="5"
                      textBinding="blockingFactor@devicesBean@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="BLOCKING_FACTOR_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="maxBlockingFactor" 
                  textBinding="MAX_BLOCKING_FACTOR@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput name="maxBlockingFactor"
                      id="maxBlockingFactor"
                      columns="5"
                      textBinding="maxBlockingFactor@devicesBean@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="MAX_BLOCKING_FACTOR_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="cu" 
                  textBinding="USAGE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput name="usageValue"
                              id="cu"
                              columns="8"
                              textBinding="usageValue@devicesBean@obBean@servletRequest"/>
              <uix:choice name="usageUnit" 
                          selectedValueBinding="usageUnit@devicesBean@obBean@servletRequest" 
                          id="usageUnitx" >
                <uix:option textBinding="NONE_UC@obBundle@servletRequest" value="none"/>
                <uix:option textBinding="OB_SECONDS@obBundle@servletRequest" value="seconds"/>
                <uix:option textBinding="OB_MINUTES@obBundle@servletRequest" value="minutes"/>
                <uix:option textBinding="OB_HOURS@obBundle@servletRequest" value="hours"/>
                <uix:option textBinding="OB_DAYS@obBundle@servletRequest" value="days"/>
                <uix:option textBinding="OB_WEEKS@obBundle@servletRequest" value="weeks"/>
                <uix:option textBinding="OB_MONTHS@obBundle@servletRequest" value="months"/>
                <uix:option textBinding="OB_YEARS@obBundle@servletRequest" value="years"/>
                <uix:option textBinding="OB_FOREVER@obBundle@servletRequest" value="forever"/>
              </uix:choice>

             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 labeledNodeId="usageUnitx"
                 textBinding="USAGE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="currentTape" 
                  textBinding="CURRENT_TAPE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput name="currentTape"
                              id="currentTape"
                              columns="8"
                              textBinding="currentTape@devicesBean@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="CURRENT_TAPE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText textBinding="USE_LIST@obBundle@servletRequest" 
                               styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:radioButton name="useList" 
                                value="all" 
                                selectedValueBinding="useList@devicesBean@obBean@servletRequest" 
                                id="all"/>
              <uix:styledText labeledNodeId="all" 
                              textBinding="ALL@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="USE_LIST_ALL_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:radioButton name="useList" 
                                value="se" 
                                selectedValueBinding="useList@devicesBean@obBean@servletRequest" 
                                id="se"/>
              <uix:styledText labeledNodeId="se" 
                              textBinding="USE_LIST_RANGE@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
               <uix:textInput name="useListRange"
                              id="useListRange"
                              columns="8"
                              textBinding="useListRange@devicesBean@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText labeledNodeId="useListRange"
                 textBinding="USE_LIST_RANGE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:radioButton name="useList" 
                                value="none" 
                                selectedValueBinding="useList@devicesBean@obBean@servletRequest" 
                                id="none"/>
              <uix:styledText labeledNodeId="none" 
                              textBinding="NONE_UC@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="USE_LIST_NONE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

          </uix:tableLayout>
          </uix:hideShow>
          </uix:header>
         </uix:case>

         <uix:case name="library">
           <uix:hideShow id="hideShow"
                          formSubmitted="true"
                          disclosedTextBinding="HIDE_ADV@obBundle@servletRequest"
                          undisclosedTextBinding="SHOW_ADV@obBundle@servletRequest"
                          unvalidated="false"
                          disclosedBinding="advancedOptions@obBean@servletRequest">

          <uix:header textBinding="LIBRARY_SETTINGS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="80%">

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  textBinding="BARCODE_READER@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="barcodeReader"
                               value="default"
                               shortDescBinding="BARCODE_READER_DEFAULT@obBundle@servletRequest"
                               selectedValueBinding="barcodeReader@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText textBinding="BARCODE_READER_DEFAULT@obBundle@servletRequest" styleClass="OraInstructionText" />
              <uix:radioButton name="barcodeReader"
                               value="yes"
                               shortDescBinding="YES@obBundle@servletRequest"
                               selectedValueBinding="barcodeReader@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText textBinding="YES@obBundle@servletRequest" styleClass="OraInstructionText" />
              <uix:radioButton name="barcodeReader"
                               value="no"
                               id="no"
                               selectedValueBinding="barcodeReader@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="no" textBinding="NO@obBundle@servletRequest" styleClass="OraInstructionText" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="BARCODE_READER_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  textBinding="BARCODE_REQUIRED@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="barcodeRequired"
                               value="yes"
                               id="bryes"
                               selectedValueBinding="barcodeRequired@devicesBean@obBean@servletRequest"/>
              <uix:styledText labeledNodeId="bryes" textBinding="YES@obBundle@servletRequest" styleClass="OraInstructionText" />

              <uix:radioButton name="barcodeRequired"
                               value="no"
                               id="brno"
                               selectedValueBinding="barcodeRequired@devicesBean@obBean@servletRequest"/>
              <uix:styledText labeledNodeId="brno" textBinding="NO@obBundle@servletRequest" styleClass="OraInstructionText" />

             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="BARCODE_REQUIRED_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  textBinding="UNLOAD_REQUIRED@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="unloadRequired"
                               value="yes"
                               id="uryes"
                               selectedValueBinding="unloadRequired@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="uryes" 
                              textBinding="YES@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
              <uix:radioButton name="unloadRequired"
                               value="no"
                               id="urno"
                               selectedValueBinding="unloadRequired@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="urno" 
                              textBinding="NO@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="UNLOAD_REQUIRED_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  textBinding="AUTO_CLEAN@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="autoClean"
                               value="no"
                               id="acno"
                               textBinding="NO@obBean@servletRequest"
                               selectedValueBinding="autoClean@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="acno" 
                              textBinding="NO@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="autoClean"
                               value="yes"
                               id="acyes"
                               selectedValueBinding="autoClean@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="acyes" 
                              textBinding="CLEAN_SENSING@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="autoClean"
                               value="interval"
                               id="acint"
                               selectedValueBinding="autoClean@devicesBean@obBean@servletRequest"/>
               <uix:styledText 
                  labeledNodeId="acint" 
                  textBinding="CLEAN_INTERVAL@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
               <uix:textInput name="cleanIntervalValue"
                              shortDescBinding="CLEAN_INTERVAL@obBundle@servletRequest"
                              columns="8"
                              textBinding="cleanIntervalValue@devicesBean@obBean@servletRequest"/>
              <uix:choice name="cleanIntervalUnit" 
                          selectedValueBinding="cleanIntervalUnit@devicesBean@obBean@servletRequest" 
                          shortDescBinding="CLEAN_INTERVAL@obBundle@servletRequest" >
                <uix:option textBinding="OB_SECONDS@obBundle@servletRequest" value="seconds"/>
                <uix:option textBinding="OB_MINUTES@obBundle@servletRequest" value="minutes"/>
                <uix:option textBinding="OB_HOURS@obBundle@servletRequest" value="hours"/>
                <uix:option textBinding="OB_DAYS@obBundle@servletRequest" value="days"/>
                <uix:option textBinding="OB_WEEKS@obBundle@servletRequest" value="weeks"/>
                <uix:option textBinding="OB_MONTHS@obBundle@servletRequest" value="months"/>
                <uix:option textBinding="OB_YEARS@obBundle@servletRequest" value="years"/>
                <uix:option textBinding="OB_FOREVER@obBundle@servletRequest" value="forever"/>
              </uix:choice>

             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  textBinding="CLEAN_EMPTIEST@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="cleanEmptiest"
                               value="yes"
                               id="ceyes"
                               selectedValueBinding="cleanEmptiest@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="ceyes" 
                              textBinding="YES@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
              <uix:radioButton name="cleanEmptiest"
                               value="no"
                               id="ceno"
                               selectedValueBinding="cleanEmptiest@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="ceno" 
                              textBinding="NO@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="CLEAN_EMPTIEST_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  textBinding="EJECTION@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="ejection"
                               value="manual"
                               id="manual"
                               selectedValueBinding="ejection@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="ceyes" 
                              textBinding="MANUAL@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
              <uix:radioButton name="ejection"
                               value="auto"
                               id="automatic"
                               selectedValueBinding="ejection@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="ceyes" 
                              textBinding="AUTO@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
              <uix:radioButton name="ejection"
                               value="ondemand"
                               id="ondemand"
                               selectedValueBinding="ejection@devicesBean@obBean@servletRequest">
              </uix:radioButton>
              <uix:styledText labeledNodeId="ondemand" 
                              textBinding="ONDEMAND@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="EJECTION_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  textBinding="MINWRITABLEVOLUMES@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput name="minwritablevolumes"
                              id="minwritablevolumes"
                              columns="3"
                              textBinding="minwritablevolumes@devicesBean@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="MINWRITABLEVOLUMES_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

          </uix:tableLayout>
          </uix:header>
          </uix:hideShow>
         </uix:case>
       </uix:switcher>

       <uix:header textBinding="ATTACHMENTS@obBundle@servletRequest">
         <uix:tableLayout cellSpacing="5" width="100%">
           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:submitButton
                      formName="foo"
                      textBinding="ADD@obBundle@servletRequest"
                      name="event"
                      value="addAttachments"/>
             </uix:cellFormat>
           </uix:rowLayout>
         </uix:tableLayout>
         <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                name="attachmentsUI"
                id="attachmentsUI"
                dataSourceProp="attachmentsUI"
                beanKey="attachmentsDataSourceBean"
                copyParams="target,type"
                summaryBinding="DEV_CONFIG@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest">
                  <uix:submitButton
                      formName="foo"
                      textBinding="REMOVE@obBundle@servletRequest"
                      name="event"
                      value="removeAttachments"/>
                  </uix:singleSelection>
                </uix:tableSelection>
          </oem:table>
       </uix:header>
     </uix:header>
     </uix:header>

    <uix:pageButtons>
      <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelDev"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitDev"
                                      formName="foo"/>

      </uix:pageButtonBar>
    </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
