<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="ename" valueBinding="duplication@duplicationBean@obBean@servletRequest"/>
    <uix:formValue name="pageNum" value="62"/>

     <uix:pageLayout titleBinding="text@duplicationBean@obBean@servletRequest">
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="text@obBean@servletRequest">
        <uix:spacer height="10"/>

          <uix:switcher childNameBinding="oldEvent@obBean@servletRequest">
            <uix:case name="edit">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="80%">
                  <uix:styledText 
                       textBinding="duplication@duplicationBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
            <uix:case name="add">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       labeledNodeId="duplication" 
                       textBinding="NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="80%">
                  <uix:textInput 
                       name="duplication" 
                       id="duplication" 
                       columns="20" 
                       textBinding="duplication@duplicationBean@obBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
          </uix:switcher>

          <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout width="100%">
                  <uix:cellFormat hAlign="right">
                     <uix:styledText labeledNodeId="triggerUnits" textBinding="TRIGGER@obBundle@servletRequest" styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%"  wrappingDisabled="true">
              <uix:choice name="eventType"
                        shortDescBinding="DUP_EVENT@obBundle@servletRequest"
                        selectedValueBinding="triggerEvent@duplicationItem@duplicationBean@obBean@servletRequest">
                        <uix:option textBinding="FIRST_WRITE@obBundle@servletRequest" value="firstwrite"/>
                        <uix:option textBinding="LAST_WRITE@obBundle@servletRequest" value="lastwrite"/>
                        <uix:option textBinding="WINDOW_CLOSED@obBundle@servletRequest" value="windowclosed"/>
                        <uix:option textBinding="NONWRITABLE@obBundle@servletRequest" value="nonwritable"/>
                        <uix:option textBinding="FIRST_MOVE@obBundle@servletRequest" value="firstmove"/>
               </uix:choice>
               <uix:textInput name="triggerUnits"
                              id="triggerUnits"
                              textBinding="triggerUnits@duplicationItem@duplicationBean@obBean@servletRequest"
                              columns="4" />
              <uix:choice name="triggerType"
                        shortDescBinding="RECALL_TIME@obBundle@servletRequest"
                        selectedValueBinding="triggerType@duplicationItem@duplicationBean@obBean@servletRequest">
                        <uix:option textBinding="OB_SECONDS@obBundle@servletRequest" value="seconds"/>
                        <uix:option textBinding="OB_MINUTES@obBundle@servletRequest" value="minutes"/>
                        <uix:option textBinding="OB_HOURS@obBundle@servletRequest" value="hours"/>
                        <uix:option textBinding="OB_DAYS@obBundle@servletRequest" value="days"/>
                    </uix:choice>

                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                    <uix:styledText 
                       textBinding="TRIGGER_TIP@obBundle@servletRequest" 
                       styleClass="OraInlineInfoText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:messageCheckBox name="migrate"
                                         checkedBinding="migrate@duplicationItem@duplicationBean@obBean@servletRequest"
                                         textBinding="MIGRATE_COLUMN@obBundle@servletRequest"
                                         shortDescBinding="MIGRATE@obBundle@servletRequest"
                                         tipBinding="MIGRATE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

          <uix:rowLayout width="100%">
             <uix:cellFormat hAlign="right">
               <uix:styledText textBinding="DUPLICATION_POLICY_RULES@obBundle@servletRequest" styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="right" width="65%">
                    <uix:submitButton textBinding="ADD@obBundle@servletRequest" name="event" value="addDupRule"/>
        <uix:stackLayout>
        <uix:contents>

              <oem:table
                width="100%"
                blockSize="8"
                formSubmitted="true"
                id="dupRuleUI"
                name="dupRuleUI"
                dataSourceProp="dupRuleUI"
                beanKey="dupruleDataSourceBean"
                copyParams="target,type"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       disabled="origin@ruleItem@duplicationBean@obBean@servletRequest"
                       selectedIndexBinding="selectedRule@duplicationBean@obBean@servletRequest">
                  <uix:submitButton
                      formName="foo"
                      textBinding="REMOVE@obBundle@servletRequest"
                      name="event"
                      value="removeDupRule"/>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>
         </uix:contents>
          </uix:stackLayout>
             </uix:cellFormat>
          </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                    <uix:styledText 
                       textBinding="DUPLICATION_RULE_TIP@obBundle@servletRequest" 
                       styleClass="OraInlineInfoText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout width="100%">
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="DEVICE_POOL@obBundle@servletRequest" styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                   <oem:shuttle name="resdev"
                               size="5" reorderable="true">
                    <uix:leading>
                      <oem:list name="alldevices" optionsBinding="devices@obBean@servletRequest" shortDescBinding="SCAN_LOCATION_TIP1@recoveryBundle@servletRequest" multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list name="selecteddevices" optionsBinding="deviceRestrictions@duplicationBean@obBean@servletRequest" shortDescBinding="SELECTED_COLUMNS@recoveryBundle@servletRequest" multiple="true"/>
                    </uix:trailing>
                   </oem:shuttle>
                  </uix:cellFormat>
                </uix:rowLayout>

          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
        <uix:stackLayout>
        <uix:contents>

         </uix:contents>
          </uix:stackLayout>
             </uix:cellFormat>
          </uix:rowLayout>

         <uix:rowLayout width="100%">
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="ROT_TIP5@obBundle@servletRequest"/>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="ROT_TIP2@obBundle@servletRequest"/>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText labeledNodeId="comment" textBinding="COMMENT@obBundle@servletRequest" styleClass="OraInstructionText" />

                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput
                       name="comment"
                       id="comment"
                       textBinding="comment@duplicationItem@duplicationBean@obBean@servletRequest"
                       columns="60"
                       rows="5"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelDuplication"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitDuplication"
                                      formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
