<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="ename" valueBinding="duplication@duplicationBean@obBean@servletRequest"/>
    <uix:formValue name="duplication" valueBinding="name@duplicationItem@duplicationBean@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="RULE_SETTINGS@obBundle@servletRequest">
        <uix:spacer height="10"/>

        <uix:tableLayout cellSpacing="1" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   textBinding="DUPLICATION_RULE_SUMMARY@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
             </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:spacer height="10"/>
        <uix:tableLayout cellSpacing="5" width="100%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   labeledNodeId="dups"
                   textBinding="NUMBER_OF_DUPLICATES@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
                 <uix:textInput name="dups" id="dups" columns="4" />
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   labeledNodeId="mf"
                   textBinding="MF@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <oem:choice name="mf" 
                          id="mf"
                          optionsBinding="mediafamilies@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelDupRule"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitDupRule"
                                      formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
