<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="optype@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="ename" valueBinding="location@locationBean@obBean@servletRequest"/>
    <uix:formValue name="locationName" valueBinding="location@locationBean@obBean@servletRequest"/>
    <uix:formValue name="pageNum" value="50"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="LOCATIONS_SETTINGS@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="100%" columnSpan="2">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="heading@locationBean@obBean@servletRequest" />
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

          <uix:switcher childNameBinding="oldEvent@obBean@servletRequest">
            <uix:case name="edit">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="location@locationBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
            <uix:case name="add">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       labeledNodeId="ln" 
                       textBinding="NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput 
                       name="location" 
                       id="ln" 
                       columns="20" 
                       textBinding="location@locationBean@obBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
          </uix:switcher>
        <uix:switcher childNameBinding="type@locationItem@locationBean@obBean@servletRequest">
          <uix:case name="0">
            <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="ASSOCIATED_DEVICE@obBundle@servletRequest" styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText textBinding="device@locationItem@locationBean@obBean@servletRequest" styleClass="OraDataText" />
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
        </uix:switcher>

        <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="emailAddresses" textBinding="EMAIL_ADDRESSES@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:textInput name="emailAddresses"
                             id="emailAddresses"
                             shortDescBinding="EMAIL_ADDRESSES_TIP@obBundle@servletRequest"
                             columns="35"
                             textBinding="mailTo@locationItem@locationBean@obBean@servletRequest" />
            </uix:cellFormat>
	  </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="EMAIL_ADDRESSES_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:switcher childNameBinding="type@locationItem@locationBean@obBean@servletRequest">
          <uix:case name="0">
            <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText labeledNodeId="comment" textBinding="COMMENT@obBundle@servletRequest" styleClass="OraInstructionText" />

                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput
                       name="comment"
                       id="comment"
                       readOnly="true"
                       textBinding="comment@locationItem@locationBean@obBean@servletRequest"
                       columns="60"
                       rows="5"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:case>
          <uix:case name="1">
            <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText labeledNodeId="customerId" textBinding="CUSTOMER_ID@obBundle@servletRequest" styleClass="OraInstructionText" />

                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput
                       name="customerId"
                       id="customerId"
                       textBinding="customerId@locationItem@locationBean@obBean@servletRequest"
                       columns="35"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:styledText textBinding="CUSTOMER_ID_TIP@obBundle@servletRequest" 
                                  styleClass="OraInlineInfoText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="NOTIFICATION_TYPE@obBundle@servletRequest" styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:choice name="notificationType" selectedValueBinding="notificationType@locationItem@locationBean@obBean@servletRequest" shortDescBinding="NOTIFICATION_TIP@obBundle@servletRequest" >
                    <uix:option textBinding="NONE@obBundle@servletRequest" value="none"/>
                    <uix:option textBinding="IRON_MOUNTAIN@obBundle@servletRequest" value="imftp"/>
                  </uix:choice>
                </uix:cellFormat>
	      </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:styledText textBinding="NOTIFICATION_TIP@obBundle@servletRequest" 
                                  styleClass="OraInlineInfoText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="RECALL_TIME@obBundle@servletRequest" styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput name="recallTimeUnits"
                             shortDescBinding="RECALL_TIME_TIP@obBundle@servletRequest"
                             columns="5"
                             textBinding="recallTimeUnits@locationItem@locationBean@obBean@servletRequest" />
                  <uix:choice name="recallTimeType" selectedValueBinding="recallTimeType@locationItem@locationBean@obBean@servletRequest" shortDescBinding="RECALL_TIME_TIP@obBundle@servletRequest" >
                    <uix:option textBinding="OB_SECONDS@obBundle@servletRequest" value="seconds"/>
                    <uix:option textBinding="OB_MINUTES@obBundle@servletRequest" value="minutes"/>
                    <uix:option textBinding="OB_HOURS@obBundle@servletRequest" value="hours"/>
                    <uix:option textBinding="OB_DAYS@obBundle@servletRequest" value="days"/>
                    <uix:option textBinding="OB_WEEKS@obBundle@servletRequest" value="weeks"/>
                    <uix:option textBinding="OB_MONTHS@obBundle@servletRequest" value="months"/>
                    <uix:option textBinding="OB_YEARS@obBundle@servletRequest" value="years"/>
                    <uix:option textBinding="OB_FOREVER@obBundle@servletRequest" value="forever"/>
                    <uix:option textBinding="DISABLED_UC@obBundle@servletRequest" value="disabled"/>
                  </uix:choice>
                </uix:cellFormat>
	      </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:styledText textBinding="RECALL_TIME_TABLE_TIP@obBundle@servletRequest" 
                                  styleClass="OraInlineInfoText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText labeledNodeId="comment" textBinding="COMMENT@obBundle@servletRequest" styleClass="OraInstructionText" />

                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput
                       name="comment"
                       id="comment"
                       textBinding="comment@locationItem@locationBean@obBean@servletRequest"
                       columns="60"
                       rows="5"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:case>
        </uix:switcher>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelLocation"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitLocation"
                                      formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
