<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="optype@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageNum" value="1"/>
    <uix:formValue name="newmfn" valueBinding="mfn@mediafamilyBean@obBean@servletRequest"/>

     <uix:pageLayout titleBinding="text@mediafamilyBean@obBean@servletRequest">
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="MF_CONFIG@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="100%" columnSpan="2">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="heading@mediafamilyBean@obBean@servletRequest" />
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

          <uix:switcher childNameBinding="oldEvent@obBean@servletRequest">
            <uix:case name="edit">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       labeledNodeId="mfn" 
                       textBinding="MF_NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="mfn@mediafamilyBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
            <uix:case name="add">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       labeledNodeId="mfn" 
                       textBinding="MF_NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput 
                       name="mfn" 
                       id="mfn" 
                       columns="20" 
                       textBinding="mfn@mediafamilyBean@obBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
          </uix:switcher>

        <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="xt" textBinding="WW@obBundle@servletRequest" styleClass="OraInstructionText" />

            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:textInput name="xt" id="xt" columns="10" textBinding="xt@mediafamilyBean@obBean@servletRequest" />
              <uix:choice name="cxt" shortDescBinding="EXPIRE_TIME@obBundle@servletRequest" selectedValueBinding="cxt@mediafamilyBean@obBean@servletRequest">
                <uix:option textBinding="OB_SECONDS@obBundle@servletRequest" value="seconds"/>
                <uix:option textBinding="OB_MINUTES@obBundle@servletRequest" value="minutes"/>
                <uix:option textBinding="OB_HOURS@obBundle@servletRequest" value="hours"/>
                <uix:option textBinding="OB_DAYS@obBundle@servletRequest" value="days"/>
                <uix:option textBinding="OB_WEEKS@obBundle@servletRequest" value="weeks"/>
                <uix:option textBinding="OB_MONTHS@obBundle@servletRequest" value="months"/>
                <uix:option textBinding="OB_YEARS@obBundle@servletRequest" value="years"/>
                <uix:option textBinding="OB_FOREVER@obBundle@servletRequest" value="forever"/>
              </uix:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="WW_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="rt" textBinding="KVS@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="mfkvs" value="rt" id="rt" selectedValueBinding="rt@mediafamilyBean@obBean@servletRequest"/>
              <uix:styledText labeledNodeId="cnt" textBinding="MF_RETAIN_TIME@obBundle@servletRequest" styleClass="OraInstructionText" />
              <uix:textInput name="cnt"
                             id="cnt"
                             shortDescBinding="MF_RETAIN_TIME@obBundle@servletRequest"
                             columns="10"
                             textBinding="rtv@mediafamilyBean@obBean@servletRequest" />
              <uix:choice name="ccnt" selectedValueBinding="rtu@mediafamilyBean@obBean@servletRequest" shortDescBinding="MF_RETAIN_TIME@obBundle@servletRequest" >
                <uix:option textBinding="OB_SECONDS@obBundle@servletRequest" value="seconds"/>
                <uix:option textBinding="OB_MINUTES@obBundle@servletRequest" value="minutes"/>
                <uix:option textBinding="OB_HOURS@obBundle@servletRequest" value="hours"/>
                <uix:option textBinding="OB_DAYS@obBundle@servletRequest" value="days"/>
                <uix:option textBinding="OB_WEEKS@obBundle@servletRequest" value="weeks"/>
                <uix:option textBinding="OB_MONTHS@obBundle@servletRequest" value="months"/>
                <uix:option textBinding="OB_YEARS@obBundle@servletRequest" value="years"/>
                <uix:option textBinding="OB_FOREVER@obBundle@servletRequest" value="forever"/>
              </uix:choice>

            </uix:cellFormat>
	  </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="MF_RETAIN_TIME_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:radioButton name="mfkvs" value="content" id="content" selectedValueBinding="rt@mediafamilyBean@obBean@servletRequest"/>
              <uix:styledText labeledNodeId="content" 
                              textBinding="MF_CMV@obBundle@servletRequest" 
                              styleClass="OraInstructionText" />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="MF_CMV_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="rot" textBinding="ROTATION_POLICY@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <oem:choice name="rot"
                      id="rot"
                      optionsBinding="rotList@mediafamilyBean@obBean@servletRequest"
                      selectedValueBinding="rot@mediafamilyBean@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
	  </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="MF_ROTATION_POLICY_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="dup" textBinding="DUPLICATION_POLICY@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <oem:choice name="dup"
                      id="dup"
                      optionsBinding="dupList@mediafamilyBean@obBean@servletRequest"
                      selectedValueBinding="dup@mediafamilyBean@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
	  </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="MF_DUPLICATION_POLICY_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="append" textBinding="APP@obBundle@servletRequest" styleClass="OraInstructionText" />

            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
                  <uix:radioButton name="append" value="yes" id="appendyes" selectedValueBinding="append@mediafamilyBean@obBean@servletRequest"/>
                  <uix:styledText labeledNodeId="appendyes" textBinding="YES@obBundle@servletRequest" styleClass="OraInstructionText" />
                  <uix:radioButton name="appendno" value="no" id="append" selectedValueBinding="append@mediafamilyBean@obBean@servletRequest"/>
                  <uix:styledText labeledNodeId="appendno" textBinding="NO@obBundle@servletRequest" styleClass="OraInstructionText" />
                </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="APPENDABLE_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="comment" textBinding="COMMENT@obBundle@servletRequest" styleClass="OraInstructionText" />

            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput
                       name="comment"
                       id="comment"
                       textBinding="comment@mediafamilyBean@obBean@servletRequest"
                       columns="60"
                       rows="5"/>
                </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelMF"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitMF"
                                      formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
