<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="44"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="newmsn" valueBinding="msn@mediaserverBean@obBean@servletRequest"/>

     <uix:pageLayout titleBinding="text@obBean@servletRequest">
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

     <uix:header textBinding="MS_CONFIG@obBundle@servletRequest">
          <uix:styledText textBinding="heading@obBean@servletRequest"
                          styleClass="OraInstructionText" />
          <uix:switcher childNameBinding="oldEvent@obBean@servletRequest">
            <uix:case name="editMediaserver">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" width="25%">
                  <uix:styledText textBinding="NAME@obBundle@servletRequest"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText
                       textBinding="msn@mediaserverBean@obBean@servletRequest"
                       styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
            <uix:case name="add">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" width="25%">
                  <uix:styledText
                       labeledNodeId="msn"
                       textBinding="NAME@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput
                       name="msn"
                       id="msn"
                       columns="20"
                       textBinding="msn@mediaserverBean@obBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
          </uix:switcher>
        <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" width="25%">
              <uix:styledText
                   labeledNodeId="status"
                   textBinding="STATUS@obBundle@servletRequest"
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:choice
                   name="status"
                   id="status"
                   selectedValueBinding="status@obBean@servletRequest">
                <uix:option textBinding="MS_STATUS_IS@obBundle@servletRequest" value="is"/>
                <uix:option textBinding="MS_STATUS_NIS@obBundle@servletRequest" value="nis"/>
              </uix:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="STATUS_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText
                   labeledNodeId="msip"
                   textBinding="MS_IP@obBundle@servletRequest"
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:textInput
                   name="msip"
                   id="msip"
                   columns="30"
                   textBinding="ip@mediaserverBean@obBean@servletRequest" />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="IP_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>

         <uix:rowLayout>
           <uix:cellFormat hAlign="left">
           </uix:cellFormat>
           <uix:cellFormat hAlign="left">
             <uix:checkBox name="suppressComm"
                           value="yes"
                           textBinding="SUPRESS_COMM@obBundle@servletRequest"
                           checkedBinding="suppress@mediaserverBean@obBean@servletRequest" />
           </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout>
           <uix:cellFormat hAlign="left">
           </uix:cellFormat>
           <uix:cellFormat hAlign="left">
             <uix:styledText
               textBinding="NO_COMM_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
           </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout>
           <uix:cellFormat hAlign="right">
             <uix:styledText 
                  labeledNodeId="accessMode" 
                  textBinding="ACCESS_METHOD@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
           </uix:cellFormat>
           <uix:cellFormat hAlign="left">
             <uix:choice name="accessMode"
                      id="accessMode"
                      onChange="submitForm('foo', true, {'event':'createMS'})"
                      selectedValueBinding="accessMethod@mediaserverBean@obBean@servletRequest">
               <uix:option textBinding="NATIVE@obBundle@servletRequest" value="ob"/>
               <uix:option textBinding="NDMP@obBundle@servletRequest" value="ndmp"/>
             </uix:choice>
           </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout>
           <uix:cellFormat hAlign="left">
           </uix:cellFormat>
           <uix:cellFormat hAlign="left">
             <uix:styledText
               textBinding="ACCESS_METHOD_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
           </uix:cellFormat>
         </uix:rowLayout>
       </uix:tableLayout>

       <uix:switcher childNameBinding="accessMethod@mediaserverBean@obBean@servletRequest">
         <uix:case name="ndmp">
             <uix:tableLayout cellSpacing="0" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" width="23%">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
          <uix:header textBinding="NDMP_SETTINGS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="80%">
           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="authType" 
                  textBinding="AUTH_TYPE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:choice name="authType"
                      id="authType"
                      selectedValueBinding="authType@mediaserverBean@obBean@servletRequest">
                 <uix:option textBinding="NEGOCIATED@obBundle@servletRequest" value="negotiated"/>
                 <uix:option textBinding="DEFAULT@obBundle@servletRequest" value="default"/>
                 <uix:option textBinding="NONE_UC@obBundle@servletRequest" value="none"/>
                 <uix:option textBinding="TEXT@obBundle@servletRequest" value="text"/>
                 <uix:option textBinding="MD5@obBundle@servletRequest" value="md5"/>
               </uix:choice>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="AUTH_TYPE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="ndmpUser" 
                  textBinding="USERNAME@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput
                   name="ndmpUser"
                   id="ndmpUser"
                   noAutoComplete="true"
                   columns="20"
                   textBinding="ndmpUser@mediaserverBean@obBean@servletRequest" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="USERNAME_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="ndmpPass" 
                  textBinding="PASSWORD@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:radioButton name="passopt" 
                                value="default" 
                                id="def"
                                selectedValueBinding="ndmpPassOpt@mediaserverBean@obBean@servletRequest"/>
               <uix:styledText labeledNodeId="def" 
                               textBinding="USE_DEFAULT_PASS@obBundle@servletRequest" 
                               styleClass="OraInstructionText" />
             </uix:cellFormat>
           </uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:radioButton name="passopt" 
                                value="text" 
                                id="text" 
                                selectedValueBinding="ndmpPassOpt@mediaserverBean@obBean@servletRequest"/>
               <uix:styledText labeledNodeId="text" 
                               textBinding="USE_TEXT_PASS@obBundle@servletRequest" 
                               styleClass="OraInstructionText" />
               <uix:spacer width="5" />
               <uix:textInput
                   name="ndmpPass"
                   id="ndmpPass"
                   secret="true"
                   noAutoComplete="true"
                   columns="20"
                   textBinding="ndmpPass@mediaserverBean@obBean@servletRequest" />
             </uix:cellFormat>

           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="PASSWORD_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="backupType" 
                  textBinding="BACKUP_TYPE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput
                   name="backupType"
                   id="backupType"
                   columns="20"
                   textBinding="backupType@mediaserverBean@obBean@servletRequest" />
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="BACKUP_TYPE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="protoVer" 
                  textBinding="PROTO_VER@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:choice
                   name="protoVer"
                   id="protoVer"
                   selectedValueBinding="protoVer@mediaserverBean@obBean@servletRequest">
                 <uix:option textBinding="AS_PROPOSED@obBundle@servletRequest" value="1"/>
                 <uix:option textBinding="OB_TWO@obBundle@servletRequest" value="2"/>
                 <uix:option textBinding="OB_THREE@obBundle@servletRequest" value="3"/>
                 <uix:option textBinding="OB_FOUR@obBundle@servletRequest" value="4"/>
               </uix:choice>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
               <uix:styledText
                 textBinding="PROTO_VER_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="ndmpPort" 
                  textBinding="PORT@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput
                   name="ndmpPort"
                   id="ndmpPort"
                   columns="10"
                   textBinding="ndmpPort@mediaserverBean@obBean@servletRequest" />
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="PORT_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

<%--
           <uix:rowLayout>

             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="varsUI" 
                  textBinding="VARIABLES@obBundle@servletRequest"
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">

                <oem:table name="varsUI"
                           beanKey="varsDataSourceBean"
                           formSubmitted="true"
                           dataSourceProp="varsUI"
                           width="100%"
                           alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                  <uix:tableSelection>
                     <oem:singleSelection shortDesc="select" selectedIndex="0">
                       <uix:submitButton textBinding="DELETE@obBundle@servletRequest" name="event" value="deleteMSVarRow"/>
                     </oem:singleSelection>
                  </uix:tableSelection>
                  <uix:columnFooter>
                     <uix:submitButton textBinding="ADD_ANOTHER_ROW@obBundle@servletRequest"
                                        name="event" value="addMSVarRow" />
                  </uix:columnFooter>
                </oem:table>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>

             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="VARIABLES_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>

           </uix:rowLayout>
--%>
          </uix:tableLayout>
          </uix:header>
           </uix:cellFormat>
         </uix:rowLayout>
       </uix:tableLayout>
         </uix:case>
       </uix:switcher>
     </uix:header>


    <uix:pageButtons>
      <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelMS"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitMS"
                                      formName="foo"/>
      </uix:pageButtonBar>
    </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
