<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="ename" valueBinding="rotation@rotationBean@obBean@servletRequest"/>
    <uix:formValue name="rotationName" valueBinding="rotation@rotationBean@obBean@servletRequest"/>
    <uix:formValue name="pageNum" value="57"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="text@obBean@servletRequest">
        <uix:spacer height="10"/>

          <uix:switcher childNameBinding="oldEvent@obBean@servletRequest">
            <uix:case name="edit">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="rotation@rotationBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
            <uix:case name="add">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       labeledNodeId="ln" 
                       textBinding="NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput 
                       name="rotation" 
                       id="ln" 
                       columns="20" 
                       textBinding="rotation@rotationBean@obBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
          </uix:switcher>

          <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout width="100%">
             <uix:cellFormat hAlign="right">
               <uix:styledText textBinding="RULES@obBundle@servletRequest" styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="right" width="65%">
                    <uix:submitButton textBinding="ADD@obBundle@servletRequest" name="event" value="addRule"/>
             </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
        <uix:stackLayout>
        <uix:contents>

              <oem:table
                width="100%"
                blockSize="8"
                formSubmitted="true"
                id="ruleUI"
                name="ruleUI"
                dataSourceProp="ruleUI"
                beanKey="ruleDataSourceBean"
                copyParams="target,type"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       disabled="origin@ruleItem@rotationBean@obBean@servletRequest"
                       selectedIndexBinding="selectedRule@rotationBean@obBean@servletRequest">
                  <uix:submitButton
                      formName="foo"
                      textBinding="REMOVE@obBundle@servletRequest"
                      name="event"
                      value="removeRule"/>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>
         </uix:contents>
          </uix:stackLayout>
             </uix:cellFormat>
          </uix:rowLayout>

         <uix:rowLayout width="100%">
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="ROT_TIP5@obBundle@servletRequest"/>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="ROT_TIP2@obBundle@servletRequest"/>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>

           </uix:tableLayout>

            <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText labeledNodeId="comment" textBinding="COMMENT@obBundle@servletRequest" styleClass="OraInstructionText" />

                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput
                       name="comment"
                       id="comment"
                       textBinding="comment@rotationItem@rotationBean@obBean@servletRequest"
                       columns="60"
                       rows="5"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelRotation"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitRotation"
                                      formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
