<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="ename" valueBinding="rotation@rotationBean@obBean@servletRequest"/>
    <uix:formValue name="rotationName" valueBinding="selectedRotation@rotationBean@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="RULE_SETTINGS@obBundle@servletRequest">
        <uix:spacer height="10"/>

        <uix:tableLayout cellSpacing="1" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   textBinding="ROTATION_RULE_TIP@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
             </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:spacer height="10"/>
        <uix:tableLayout cellSpacing="5" width="100%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   labeledNodeId="position"
                   textBinding="ROTATION_RULE_POSITION@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <oem:choice name="position" 
                          id="position"
                          optionsBinding="position@obBean@servletRequest">
              </oem:choice>
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText 
                   textBinding="INSERT_RULE@obBundle@servletRequest" 
                   styleClass="OraInlineInfoText" />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   labeledNodeId="locations"
                   textBinding="LOCATIONS@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <oem:choice name="location" 
                          id="locations"
                          optionsBinding="locations@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText 
                   textBinding="ROT_TIP5@obBundle@servletRequest" 
                   styleClass="OraInlineInfoText" />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   textBinding="ROT_EVENT@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:choice name="eventType"
                        shortDescBinding="ROT_EVENT@obBundle@servletRequest"
                        disabledBinding="readOnly@obBean@servletRequest"
                        selectedValueBinding="optype@obBean@servletRequest">
                        <uix:option textBinding="FIRST_WRITE@obBundle@servletRequest" value="firstwrite"/>
                        <uix:option textBinding="LAST_WRITE@obBundle@servletRequest" value="lastwrite"/>
                        <uix:option textBinding="WINDOW_CLOSED@obBundle@servletRequest" value="windowclosed"/>
                        <uix:option textBinding="NONWRITABLE@obBundle@servletRequest" value="nonwritable"/>
                        <uix:option textBinding="ARRIVAL@obBundle@servletRequest" value="arrival"/>
                        <uix:option textBinding="EXPIRATION@obBundle@servletRequest" value="expiration"/>
               </uix:choice>
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText 
                   textBinding="ROT_TIP3@obBundle@servletRequest" 
                   styleClass="OraInlineInfoText" />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText 
                   textBinding="ROT_TIP4@obBundle@servletRequest" 
                   styleClass="OraInlineInfoText" />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   labeledNodeId="recalltime"
                   textBinding="DURATION@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
               <uix:textInput name="rtvalue" 
                                   id="recalltime" 
                                   columns="4" />
              <uix:choice name="rtunit"
                        shortDescBinding="RECALL_TIME@obBundle@servletRequest"
                        selectedValueBinding="optype@obBean@servletRequest">
                        <uix:option textBinding="OB_SECONDS@obBundle@servletRequest" value="seconds"/>
                        <uix:option textBinding="OB_MINUTES@obBundle@servletRequest" value="minutes"/>
                        <uix:option textBinding="OB_HOURS@obBundle@servletRequest" value="hours"/>
                        <uix:option textBinding="OB_DAYS@obBundle@servletRequest" value="days"/>
                        <uix:option textBinding="OB_WEEKS@obBundle@servletRequest" value="weeks"/>
                        <uix:option textBinding="OB_MONTHS@obBundle@servletRequest" value="months"/>
                        <uix:option textBinding="OB_YEARS@obBundle@servletRequest" value="years"/>
                        <uix:option textBinding="OB_FOREVER@obBundle@servletRequest" value="forever"/>
                        <uix:option textBinding="DISABLED_UC@obBundle@servletRequest" value="disabled"/>

                    </uix:choice>
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText 
                   textBinding="ROT_TIP2@obBundle@servletRequest" 
                   styleClass="OraInlineInfoText" />
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelRule"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitRule"
                                      formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
