<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageNum" value="59"/>
    <uix:formValue name="ename" valueBinding="scan@scanBean@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="text@obBean@servletRequest">
          <uix:spacer height="10"/>

          <uix:switcher childNameBinding="oldEvent@obBean@servletRequest">
            <uix:case name="edit">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="scan@scanBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       textBinding="TYPE@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText 
                       textBinding="textType@scanItem@scanBean@obBean@servletRequest" 
                       styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
            </uix:case>
            <uix:case name="add">
             <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText 
                       labeledNodeId="scan" 
                       textBinding="NAME@obBundle@servletRequest" 
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:textInput 
                       name="scan" 
                       id="scan" 
                       columns="20" 
                       textBinding="scan@scanBean@obBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" vAlign="top">
              <uix:styledText textBinding="TYPE@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:tableLayout cellSpacing="0" width="100%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                    <oem:radioButton name="stype"
                               value="duplication"
                               selectedValue="duplication"
                               textBinding="DUPLICATION_OP_TIP@obBundle@servletRequest"
                               shortDescBinding="SCHEDULE_TYPE_DUP@obBundle@servletRequest"
                               styleClass="OraInstructionText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                    <oem:radioButton name="stype"
                               value="mediamovement"
                               selectedValue="mediamovement"
                               textBinding="MEDIAMOVEMENT_OP_TIP@obBundle@servletRequest"
                               shortDescBinding="SCHEDULE_TYPE_MM@obBundle@servletRequest"
                               styleClass="OraInstructionText"/>
                  </uix:cellFormat>
	        </uix:rowLayout>
	      </uix:tableLayout>
            </uix:cellFormat>
	  </uix:rowLayout>
        </uix:tableLayout>
            </uix:case>
          </uix:switcher>

        <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="priority" textBinding="PRIORITY@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:textInput name="priority"
                             id="priority"
                             shortDescBinding="PRIORITY_TIP@obBundle@servletRequest"
                             columns="5"
                             textBinding="priority@scanItem@scanBean@obBean@servletRequest" />
            </uix:cellFormat>
	  </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="PRIORITY_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText textBinding="LOCATIONS@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
                  <oem:shuttle name="locations"
                               leadingHeaderBinding="SCAN_LOCATION_TIP1@recoveryBundle@servletRequest"
                               trailingHeaderBinding="SCAN_LOCATION_TIP2@recoveryBundle@servletRequest"
                               size="5" reorderable="true">
                    <uix:leading>
                      <oem:list name="alllocations" optionsBinding="locations@obBean@servletRequest" shortDescBinding="SCAN_LOCATION_TIP1@recoveryBundle@servletRequest" multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list name="selectedlocations" optionsBinding="locations@scanBean@obBean@servletRequest" shortDescBinding="SELECTED_COLUMNS@recoveryBundle@servletRequest" multiple="true"/>
                    </uix:trailing>
                  </oem:shuttle>

            </uix:cellFormat>
	  </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="MM_LOCATIONS_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
              <uix:styledText
               textBinding="SCH_FREQ@obBundle@servletRequest"
               styleClass="OraInstructionText"/>
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
            </uix:cellFormat>
           </uix:rowLayout>
         </uix:tableLayout>

          <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout width="100%">
             <uix:cellFormat hAlign="right">
               <uix:styledText textBinding="SCAN_FREQUENUCY@obBundle@servletRequest" styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="right" width="65%">
                    <uix:submitButton textBinding="ADD_WEEKLY@obBundle@servletRequest" name="event" value="addWeeklyTrigger"/>
                    <uix:spacer width="2" />
                    <uix:submitButton textBinding="ADD_MONTHLY@obBundle@servletRequest" name="event" value="addMonthlyTrigger"/>
             </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
             <uix:cellFormat hAlign="right">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
        <uix:stackLayout>
        <uix:contents>

              <oem:table
                width="100%"
                blockSize="2"
                formSubmitted="true"
                id="triggerUI"
                name="triggerUI"
                dataSourceProp="triggerUI"
                beanKey="triggerDataSourceBean"
                copyParams="target,type"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedTrigger@scanBean@obBean@servletRequest">
                  <uix:submitButton
                      formName="foo"
                      textBinding="REMOVE@obBundle@servletRequest"
                      name="event"
                      value="removeTrigger"/>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>
         </uix:contents>
          </uix:stackLayout>
             </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText
               textBinding="SCH_FREQ_TIP@obBundle@servletRequest"
               styleClass="OraInlineInfoText"/>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText labeledNodeId="comment" textBinding="COMMENT@obBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:textInput
                    name="comment"
                     id="comment"
                     textBinding="comment@scanItem@scanBean@obBean@servletRequest"
                     columns="60"
                     rows="5"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelScan"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitScan"
                                      formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
