<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="ename" valueBinding="scan@scanBean@obBean@servletRequest"/>
    <uix:formValue name="scan" valueBinding="scan@scanBean@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="text@obBean@servletRequest">
        <uix:spacer height="10"/>

        <uix:tableLayout cellSpacing="1" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
              <uix:styledText 
                   textBinding="TRIGGER_SUMMARY@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
             </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:spacer height="10"/>
        <uix:switcher childNameBinding="triggerType@scanBean@obBean@servletRequest">
         <uix:case name="addMonthlyTrigger">
          <uix:tableLayout cellSpacing="5" width="100%">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText 
                     labeledNodeId="dom"
                     textBinding="DAY_OF_THE_MONTHLY@obBundle@servletRequest" 
                     styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                <uix:choice name="dom"
                        id="dom">
                        <uix:option textBinding="OB_ONE@obBundle@servletRequest" value="1"/>
                        <uix:option textBinding="OB_TWO@obBundle@servletRequest" value="2"/>
                        <uix:option textBinding="OB_THREE@obBundle@servletRequest" value="3"/>
                        <uix:option textBinding="OB_FOUR@obBundle@servletRequest" value="4"/>
                        <uix:option textBinding="OB_FIVE@obBundle@servletRequest" value="5"/>
                        <uix:option textBinding="OB_SIX@obBundle@servletRequest" value="6"/>
                        <uix:option textBinding="OB_SEVEN@obBundle@servletRequest" value="7"/>
                        <uix:option textBinding="OB_EIGHT@obBundle@servletRequest" value="8"/>
                        <uix:option textBinding="OB_NINE@obBundle@servletRequest" value="9"/>
                        <uix:option textBinding="OB_TEN@obBundle@servletRequest" value="10"/>
                        <uix:option textBinding="OB_ELEVEN@obBundle@servletRequest" value="11"/>
                        <uix:option textBinding="OB_TWELVE@obBundle@servletRequest" value="12"/>
                        <uix:option textBinding="OB_THIRTEEN@obBundle@servletRequest" value="13"/>
                        <uix:option textBinding="OB_FOURTEEN@obBundle@servletRequest" value="14"/>
                        <uix:option textBinding="OB_FIFTEEN@obBundle@servletRequest" value="15"/>
                        <uix:option textBinding="OB_SIXTEEN@obBundle@servletRequest" value="16"/>
                        <uix:option textBinding="OB_SEVENTEEN@obBundle@servletRequest" value="17"/>
                        <uix:option textBinding="OB_EIGHTTEEN@obBundle@servletRequest" value="18"/>
                        <uix:option textBinding="OB_NINETEEN@obBundle@servletRequest" value="19"/>
                        <uix:option textBinding="OB_TWENTY@obBundle@servletRequest" value="20"/>
                        <uix:option textBinding="OB_TWENTYONE@obBundle@servletRequest" value="21"/>
                        <uix:option textBinding="OB_TWENTYTWO@obBundle@servletRequest" value="22"/>
                        <uix:option textBinding="OB_TWENTYTHREE@obBundle@servletRequest" value="23"/>
                        <uix:option textBinding="OB_TWENTYFOUR@obBundle@servletRequest" value="24"/>
                        <uix:option textBinding="OB_TWENTYFIVE@obBundle@servletRequest" value="25"/>
                        <uix:option textBinding="OB_TWENTYSIX@obBundle@servletRequest" value="26"/>
                        <uix:option textBinding="OB_TWENTYSEVEN@obBundle@servletRequest" value="27"/>
                        <uix:option textBinding="OB_TWENTYEIGHT@obBundle@servletRequest" value="28"/>
                        <uix:option textBinding="OB_TWENTYNINE@obBundle@servletRequest" value="29"/>
                        <uix:option textBinding="OB_THIRTY@obBundle@servletRequest" value="30"/>
                        <uix:option textBinding="OB_THIRTYONE@obBundle@servletRequest" value="31"/>
                      </uix:choice>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText 
                     textBinding="DAY_OF_THE_MONTHLY_TIP@obBundle@servletRequest" 
                     styleClass="OraInlineInfoText" />
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
         </uix:case>
         <uix:case name="addWeeklyTrigger">
          <uix:tableLayout cellSpacing="5" width="100%">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText 
                     labeledNodeId="ordinal"
                     textBinding="ORDINAL@obBundle@servletRequest" 
                     styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                <uix:choice name="ordinal"
                        id="ordinal">
                        <uix:option textBinding="EVERY@obBundle@servletRequest" value="every"/>
                        <uix:option textBinding="FIRST@obBundle@servletRequest" value="first"/>
                        <uix:option textBinding="SECOND@obBundle@servletRequest" value="second"/>
                        <uix:option textBinding="THIRD@obBundle@servletRequest" value="third"/>
                        <uix:option textBinding="FOURTH@obBundle@servletRequest" value="fourth"/>
                        <uix:option textBinding="FIFTH@obBundle@servletRequest" value="fifth"/>
                        <uix:option textBinding="LAST@obBundle@servletRequest" value="last"/>
                      </uix:choice>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText 
                     textBinding="ORDINAL_TIP@obBundle@servletRequest" 
                     styleClass="OraInlineInfoText" />
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText 
                     textBinding="SCHED_FREQDAYSOFWEEK@obBundle@servletRequest" 
                     styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                  <uix:messageCheckBox name="monday" value="monday" shortDescBinding="MONDAY@obBundle@servletRequest" textBinding="MONDAY@obBundle@servletRequest"/>
                  <uix:messageCheckBox name="tuesday" value="tuesday" shortDescBinding="TUESDAY@obBundle@servletRequest" textBinding="TUESDAY@obBundle@servletRequest"/>
                  <uix:messageCheckBox name="wednesday" value="wednesday" shortDescBinding="WEDNESDAY@obBundle@servletRequest" textBinding="WEDNESDAY@obBundle@servletRequest"/>
                  <uix:messageCheckBox name="thursday" value="thursday" shortDescBinding="THURSDAY@obBundle@servletRequest" textBinding="THURSDAY@obBundle@servletRequest"/>
                  <uix:messageCheckBox name="friday" value="friday" shortDescBinding="FRIDAY@obBundle@servletRequest" textBinding="FRIDAY@obBundle@servletRequest"/>
                  <uix:messageCheckBox name="saturday" value="saturday" shortDescBinding="SATURDAY@obBundle@servletRequest" textBinding="SATURDAY@obBundle@servletRequest"/>
                  <uix:messageCheckBox name="sunday" value="sunday" shortDescBinding="SUNDAY@obBundle@servletRequest" textBinding="SUNDAY@obBundle@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:styledText 
                     textBinding="SCHED_FREQDAYSOFWEEK_TIP@obBundle@servletRequest" 
                     styleClass="OraInlineInfoText" />
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
         </uix:case>
        </uix:switcher>
        <uix:tableLayout cellSpacing="5" width="100%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   textBinding="OB_BKWIZ_ST@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
              <uix:textInput name="hour"
                             textBinding="hour@scanBean@obBean@servletRequest"
                             shortDescBinding="HOUR@obBundle@servletRequest"
                             columns="2"/>
              <uix:styledText styleClass="OraInstructionText" text=":"/>
              <uix:textInput name="minute"
                             textBinding="minute@scanBean@obBean@servletRequest"
                             shortDescBinding="MINUTE@obBundle@servletRequest"
                             columns="2"/>
              <oem:radioButton name="ampm"
                               value="AM"
                               selectedValue="AM"
                               textBinding="AM_LABEL@obBundle@servletRequest"
                               shortDescBinding="AM_LABEL@obBundle@servletRequest"
                               styleClass="OraInstructionText"/>
              <oem:radioButton name="ampm"
                               value="PM"
                               selectedValue="AM"
                               textBinding="PM_LABEL@obBundle@servletRequest"
                               shortDescBinding="PM_LABEL@obBundle@servletRequest"
                               styleClass="OraInstructionText"/>
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText 
                   textBinding="TOD_TIP@obBundle@servletRequest" 
                   styleClass="OraInlineInfoText" />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                   labeledNodeId="recalltime"
                   textBinding="EXPIRE_TIME@obBundle@servletRequest" 
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="75%">
               <uix:textInput name="rtvalue" 
                                   id="recalltime" 
                                   columns="4" />
              <uix:choice name="rtunit"
                        shortDescBinding="EXPIRE_TIP@obBundle@servletRequest"
                        selectedValueBinding="optype@obBean@servletRequest">
                        <uix:option textBinding="OB_SECONDS@obBundle@servletRequest" value="seconds"/>
                        <uix:option textBinding="OB_MINUTES@obBundle@servletRequest" value="minutes"/>
                        <uix:option textBinding="OB_HOURS@obBundle@servletRequest" value="hours"/>
                        <uix:option textBinding="OB_DAYS@obBundle@servletRequest" value="days"/>
                    </uix:choice>
             </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText 
                   textBinding="EXPIRE_TIP@obBundle@servletRequest" 
                   styleClass="OraInlineInfoText" />
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                      name="event"
                                      value="cancelTrigger"
                                      formName="foo"/>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="submitTrigger"
                                      formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
