<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="54"/>
    <uix:formValue name="prevpage" value="dbreports"/>

     <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="DBREPORTS_PAGE_TITLE@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="DB_BACKUP_REPORT_TEXT@obBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="top">
            </uix:cellFormat>
         </uix:rowLayout>
           <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                name="jobUI"
                id="jobUI"
                dataSourceProp="jobUI"
                beanKey="dbjobDataSourceBean"
                copyParams="target,type"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedJob@jobBean@obBean@servletRequest">
                  <uix:submitButton
                      formName="foo"
                      textBinding="VIEW_TRANSCRIPT@obBundle@servletRequest"
                      name="event"
                      value="viewTranscript"/>
                  <uix:spacer width="5" />
                  <uix:submitButton
                      formName="foo"
                      textBinding="VOLUME_DETAILS@obBundle@servletRequest"
                      name="event"
                      value="dbVolumes"/>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>

          </uix:header>

    <uix:pageButtons>
      <uix:pageButtonBar>
                    <uix:submitButton textBinding="RETURN@obBundle@servletRequest"
                                      name="event"
                                      value="returnDBR"
                                      formName="foo"/>
      </uix:pageButtonBar>
    </uix:pageButtons>

        <uix:spacer height="10"/>

        <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="70%">
            <uix:rowLayout>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="DEVICES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'7'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="MANAGE_VOLUMES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'5'})"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
