<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="55"/>
    <uix:formValue name="jobid" valueBinding="id@jobItem@jobBean@obBean@servletRequest"/>

     <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="VOLUME_DETAILS@obBundle@servletRequest">

         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
                  <uix:styledText
                       textBinding="VOLUME_DETAILS_SUMMARY@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="top">
            </uix:cellFormat>
         </uix:rowLayout>
       <uix:tableLayout cellSpacing="5" width="80%">
             <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:styledText
                       textBinding="JOB_ID@obBundle@servletRequest"
                       styleClass="OraInstructionText" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText
                       textBinding="id@jobItem@jobBean@obBean@servletRequest"
                       styleClass="OraDataText"/>
              </uix:cellFormat>
            </uix:rowLayout>
       </uix:tableLayout>



             <uix:spacer width="6"/>
              <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                name="volumesUI"
                id="volumesUI"
                dataSourceProp="volumesUI"
                beanKey="volumesDataSourceBean"
                copyParams="target,type"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
              </oem:table>
           <uix:tableLayout>
             <uix:rowLayout width="80%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="EXPIRES_TIP@obBundle@servletRequest" />
                </uix:tip>
              </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout width="80%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="CLOSES_TIP@obBundle@servletRequest" />
                </uix:tip>
              </uix:cellFormat>

           </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="okTranscript"
                                      formName="foo"/>
        </uix:pageButtonBar>
      </uix:pageButtons>

        <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="70%">
            <uix:rowLayout>
               <uix:cellFormat hAlign="left">
                 <uix:link textBinding="DEVICES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'7'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left"  wrappingDisabled="true">
                 <uix:link textBinding="ROTATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'51'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left">
                 <uix:link textBinding="LOCATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'50'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left"  wrappingDisabled="true">
                 <uix:link textBinding="DUPLICATION_POLICY@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'61'})"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
