<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type">
      <uix:formValue name="pageNum" value="19"/>
      <uix:formValue name="dn" valueBinding="dn@devicesBean@obBean@servletRequest"/>
      <uix:formValue name="newdn" valueBinding="dn@devicesBean@obBean@servletRequest"/>
      <uix:formValue name="dtype" valueBinding="dtype@devicesBean@obBean@servletRequest"/>
      <uix:formValue name="deviceCommand" valueBinding="deviceCommand@devicesBean@obBean@servletRequest"/>

       <style selector=".OraMonoText">
          <property name="font-family">Currier,Currier New</property>
          <property name="font-size">8pt</property>
          <property name="color">#000000</property>
       </style>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
         <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

       <uix:header textBinding="deviceText@devicesBean@obBean@servletRequest">
        <uix:tableLayout cellSpacing="5" width="80%">
          <uix:rowLayout>
            <uix:cellFormat hAlign="left" columnSpan="2">
              <uix:styledText textBinding="deviceOutput@devicesBean@obBean@servletRequest" 
                              styleClass="OraInstructionText"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:labeledFieldLayout width="70%">
          <uix:messageStyledText promptBinding="DEVICE_NAME@obBundle@servletRequest"
                                 styleClass="OraDataText"
                                 textBinding="dn@devicesBean@obBean@servletRequest"/>
          <uix:messageStyledText promptBinding="DEVICE_TYPE@obBundle@servletRequest"
                                 styleClass="OraDataText"
                                 textBinding="text@obBean@servletRequest"/>
        </uix:labeledFieldLayout>

        <uix:header textBinding="COMMAND_OPTIONS@obBundle@servletRequest">
          <uix:spacer height="10"/>
          <uix:switcher childNameBinding="deviceCommand@devicesBean@obBean@servletRequest">
            <uix:case name="insertvol">
              <uix:header textBinding="SOURCE@obBundle@servletRequest">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="17%">
                    <uix:styledText textBinding="TYPE@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="5%">
                    <uix:radioButton name="insertop" value="vid" id="vid"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="VID@obBundle@servletRequest"
                                    labeledNodeId="vid"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                     <uix:textInput name="vid"
                                    columns="10"
                                    shortDescBinding="VID@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                    <uix:styledText textBinding="VID_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="17%">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="5%">
                    <uix:radioButton name="insertop" value="bc" id="bc"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="BARCODE@obBundle@servletRequest"
                                    labeledNodeId="bc"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                     <uix:textInput name="bc"
                                    shortDescBinding="BARCODE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                    <uix:styledText textBinding="BC_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:radioButton name="insertop" id="unk" value="unknown"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="UNKNOWN_TIP@obBundle@servletRequest"
                                    labeledNodeId="unk"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:radioButton name="insertop" id="ul" value="unlabeled" selected="true"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" columnSpan="2">
                    <uix:styledText textBinding="UNLABELED_TIP@obBundle@servletRequest"
                                    labeledNodeId="ul"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:radioButton name="insertop" id="ic" value="clean"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" columnSpan="2">
                    <uix:styledText textBinding="INSERT_CLEAN_TIP@obBundle@servletRequest"
                                    labeledNodeId="ic"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="USES@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                     <uix:textInput name="att1"
                                    columns="8"
                                    shortDescBinding="USES@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                    <uix:styledText textBinding="USES_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="MAX_USES@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                     <uix:textInput name="att2"
                                    columns="8"
                                    shortDescBinding="MAX_USES@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                    <uix:styledText textBinding="MAXUSES_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              </uix:header>
            </uix:case>
            <uix:case name="mountdev">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="17%">
                    <uix:styledText textBinding="MOUNT_TYPE@obBundle@servletRequest"
                                    labeledNodeId="mtx"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="5%">
                    <uix:radioButton name="mountopt" id="mtx" selectedValue="read" value="read"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="IMPORT_TIP@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:radioButton name="mountopt" id="wt" value="write"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="WRITE_TIP@obBundle@servletRequest"
                                    labeledNodeId="wt"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="MOUNT_ATT@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:checkBox name="mountatt" id="um" value="unmount"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="UNMOUNT_TIP@obBundle@servletRequest"
                                    labeledNodeId="um"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="unmountdev">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="17%">
                    <uix:styledText textBinding="UNMOUNT_ATT@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="5%">
                    <uix:checkBox name="mountatt" id="ul" value="unload"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="UNLOAD_TIP@obBundle@servletRequest"
                                    labeledNodeId="ul"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="loadvol">
              <uix:tableLayout cellSpacing="5" width="60%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="15%">
                    <uix:checkBox name="mount"
                                     value="yes"
                                     shortDescBinding="MOUNT_MODE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" columnSpan="2">
                    <uix:styledText textBinding="MOUNT_MODE@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                    <uix:radioButton selected="true" name="mountmode" id="mmx" value="read"/>
                    <uix:styledText textBinding="READ@obBundle@servletRequest"
                                    labeledNodeId="mmx"
                                    styleClass="OraInstructionText" />
                    <uix:radioButton name="mountmode" id="mmr" value="write"/>
                    <uix:styledText textBinding="WRITE@obBundle@servletRequest"
                                    labeledNodeId="mmr"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" columnSpan="2">
                    <uix:styledText textBinding="MOUNT_MODE_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:checkBox name="req"
                                     value="yes"
                                     shortDescBinding="REQ@obBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" columnSpan="2">
                    <uix:styledText textBinding="REQ@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" columnSpan="2">
                    <uix:styledText textBinding="REQ_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:checkBox name="force"
                                  value="yes"
                                  shortDescBinding="OB_FORCE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" columnSpan="2">
                    <uix:styledText textBinding="OB_FORCE@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="importvol">
              <uix:tableLayout cellSpacing="5" width="60%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="30%">
                    <uix:radioButton name="importopt"
                                     value="importdevice"
				     id="imprt"
                                     selected="true"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="IMPORT@obBundle@servletRequest"
                                    labeledNodeId="imprt"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="IMPORT_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:radioButton name="importopt"
                                     value="identifydevice"
				     id="identify"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="IDENTIFY@obBundle@servletRequest"
                                    labeledNodeId="identify"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="IDENTIFY_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:radioButton name="importopt"
                                  value="unlabeldevice"
				  id="unlabel"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="UNLABEL@obBundle@servletRequest"
                                    labeledNodeId="unlabel"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="UNLABEL_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="IEE@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:textInput name="iee"
                                   shortDescBinding="IEE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="IEE_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="exportvol">
              <uix:tableLayout cellSpacing="5" width="60%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="VID_LIST@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />

                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                     <uix:textInput name="vid"
                                    shortDescBinding="VID@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                    <uix:styledText textBinding="VID_LIST_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText textBinding="SE@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />

                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                     <uix:textInput name="se"
                                    shortDescBinding="SE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="60%">
                    <uix:styledText textBinding="SE_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="movevol">
              <uix:header textBinding="SOURCE@obBundle@servletRequest">
                <uix:tableLayout cellSpacing="5" width="60%">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="10%">
                      <uix:radioButton name="volume"
                                       id="vid"
                                       value="vid"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText labeledNodeId="vid"
                                      textBinding="VID@obBundle@servletRequest"
                                      styleClass="OraInstructionText" />

                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                       <uix:textInput name="vid"
                                      shortDescBinding="VID@obBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                      <uix:styledText textBinding="VID_TIP@obBundle@servletRequest"
                                      styleClass="OraInlineInfoText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                      <uix:cellFormat hAlign="right" width="10%">
                        <uix:radioButton name="volume"
                                         id="bc"
                                         value="bc"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText labeledNodeId="bc"
                                      textBinding="BARCODE@obBundle@servletRequest"
                                      styleClass="OraInstructionText" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                       <uix:textInput name="bc"
                                      shortDescBinding="BARCODE@obBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                      <uix:styledText textBinding="BC_TIP@obBundle@servletRequest"
                                      styleClass="OraInlineInfoText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:radioButton name="volume"
                                       id="se"
                                       value="se"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText labeledNodeId="se"
                                      textBinding="SE@obBundle@servletRequest"
                                      styleClass="OraInstructionText" />
  
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                       <uix:textInput name="se"
                                      shortDescBinding="SE@obBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                      <uix:styledText textBinding="SE_TIP@obBundle@servletRequest"
                                      styleClass="OraInlineInfoText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:case>
            <uix:case name="extractvol">
              <uix:tableLayout cellSpacing="5" width="60%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="20%">
                    <uix:radioButton name="volume"
                                     id="vid"
                                     value="vid"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="vid"
                                    textBinding="VID@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />

                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                     <uix:textInput name="vid"
                                    shortDescBinding="VID@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="VID_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:radioButton name="volume"
                                       id="se"
                                       value="se"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="se"
                                    textBinding="SE@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />

                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:textInput name="se"
                                   shortDescBinding="SE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="SE_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" >
                      <uix:radioButton name="volume"
                                       id="bc"
                                       value="bc"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="bc"
                                    textBinding="BARCODE@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />

                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                     <uix:textInput name="bc"
                                    shortDescBinding="BARCODE@obBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="BC_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText" />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="unloadvol">
              <uix:labeledFieldLayout width="80%">
                <uix:messageTextInput name="se"
                                      promptBinding="ES@obBundle@servletRequest"
                                      shortDescBinding="ES@devicesBean@obBean@servletRequest"
                                      tipBinding="ES_TIP@obBundle@servletRequest"
                                      columns="4"/>
              </uix:labeledFieldLayout>
            </uix:case>
            <uix:case name="labelvol">
              <uix:labeledFieldLayout width="80%">
                <uix:messageTextInput name="bc"
                                      promptBinding="BARCODE@obBundle@servletRequest"
                                      shortDescBinding="BARCODE@devicesBean@obBean@servletRequest"
                                      tipBinding="BC_TIP@obBundle@servletRequest"
                                      columns="20"/>
                <uix:messageTextInput name="se"
                                      promptBinding="ES@obBundle@servletRequest"
                                      shortDescBinding="ES@devicesBean@obBean@servletRequest"
                                      tipBinding="SE_TIP@obBundle@servletRequest"
                                      columns="10"/>
              </uix:labeledFieldLayout>
            </uix:case>
            <uix:case name="unlabelvol">
              <uix:labeledFieldLayout width="70%">
                <uix:messageTextInput name="se"
                                      promptBinding="SE@obBundle@servletRequest"
                                      shortDescBinding="SE@devicesBean@obBean@servletRequest"
                                      tipBinding="SE_TIP@obBundle@servletRequest"
                                      columns="10"/>
                <uix:checkBox textBinding="OB_FORCE@obBundle@servletRequest"
                                  name="force"
                                  shortDescBinding="UL_FORCE_TIP@obBundle@servletRequest"
                                  value="yes"/>
              </uix:labeledFieldLayout>
            </uix:case>
            <uix:case name="reuse">
              <uix:labeledFieldLayout width="70%">
                <uix:messageTextInput name="se"
                                      promptBinding="SE@obBundle@servletRequest"
                                      shortDescBinding="SE@devicesBean@obBean@servletRequest"
                                      tipBinding="SE_REUSE_TIP@obBundle@servletRequest"
                                      columns="10"/>
                <uix:checkBox textBinding="OB_FORCE@obBundle@servletRequest"
                                  name="force"
                                  shortDescBinding="UL_FORCE_TIP@obBundle@servletRequest"
                                  value="yes"/>
              </uix:labeledFieldLayout>
            </uix:case>
            <uix:case name="inventory">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                    <uix:checkBox textBinding="OB_REUSE_FORCE_TIP@obBundle@servletRequest"
                                  name="force"
                                  id="inv"
                                  value="yes"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="deviceCommand@devicesBean@obBean@servletRequest">
            <uix:case name="loadvol">
              <uix:header textBinding="SOURCE@obBundle@servletRequest">
                <uix:tableLayout cellSpacing="5" width="80%">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="15%">
                      <uix:radioButton name="loadvolop" value="vid" id="vid"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="VID@obBundle@servletRequest"
                                      labeledNodeId="vid"
                                      styleClass="OraInstructionText" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" >
                       <uix:textInput name="vid"
                                      columns="10"
                                      shortDescBinding="VID@obBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText textBinding="VID_TIP@obBundle@servletRequest"
                                      styleClass="OraInlineInfoText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:radioButton name="loadvolop" value="bc" id="bc"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="BARCODE@obBundle@servletRequest"
                                      labeledNodeId="bc"
                                      styleClass="OraInstructionText" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                       <uix:textInput name="bc"
                                      shortDescBinding="BARCODE@obBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText textBinding="BC_TIP@obBundle@servletRequest"
                                      styleClass="OraInlineInfoText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:radioButton name="loadvolop" value="es" id="es"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="ES@obBundle@servletRequest"
                                      labeledNodeId="es"
                                      styleClass="OraInstructionText" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                       <uix:textInput name="es"
                                      shortDescBinding="ES@obBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText textBinding="ES_TIP@obBundle@servletRequest"
                                      styleClass="OraInlineInfoText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:case>
            <uix:case name="insertvol">
              <uix:header textBinding="DESTINATION@obBundle@servletRequest">
                <uix:tableLayout cellSpacing="5" width="60%">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="10%">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="ES@obBundle@servletRequest"
                                      styleClass="OraInstructionText" />
                      </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                      <uix:textInput name="se_dest"
                                     shortDescBinding="ES@obBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                      <uix:styledText textBinding="ES_TIP@obBundle@servletRequest"
                                      styleClass="OraInlineInfoText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:case>
            <uix:case name="movevol">
              <uix:header textBinding="DESTINATION@obBundle@servletRequest">
                <uix:tableLayout cellSpacing="5" width="60%">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="10%">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="ES@obBundle@servletRequest"
                                      styleClass="OraInstructionText" />
                      </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                      <uix:textInput name="se_dest"
                                     shortDescBinding="ES@obBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="60%">
                      <uix:styledText textBinding="ES_TIP@obBundle@servletRequest"
                                      styleClass="OraInlineInfoText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="showVols@devicesBean@obBean@servletRequest">
            <uix:case name="vol">
              <uix:header textBinding="VIEW_DEVICE_VOLUMES@obBundle@servletRequest">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:textInput name="deviceVolumes"
                                     shortDescBinding="VIEW_DEVICE_VOLUMES@obBundle@servletRequest"
                                     textBinding="deviceVolumes@devicesBean@obBean@servletRequest"
                                     readOnly="true"
                                     wrap="false"
                                     columns="120"
                                     styleClass="OraMonoText"
                                     rows="15"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:case>
          </uix:switcher>
      </uix:header>
    </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
                <uix:submitButton 
                   textBinding="CANCEL@obBundle@servletRequest" 
                   name="event" 
                   value="manageDevices"/>
                <uix:submitButton 
                   textBinding="OK@obBundle@servletRequest" 
                   name="event" 
                   value="deviceCommand"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
