<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="34"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="opageOp" valueBinding="actionObject@obBean@servletRequest"/>
    <uix:formValue name="newdn" valueBinding="dn@devicesBean@obBean@servletRequest"/>
    <uix:formValue name="ms" valueBinding="msn@mediaserverBean@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

       <uix:header textBinding="heading@obBean@servletRequest">
            <uix:styledText textBinding="text@obBean@servletRequest"
                            styleClass="OraInstructionText" />
            <uix:link textBinding="DEVICES@obBundle@servletRequest"
                      onClick="submitForm('foo', true, {event:'doLoad',pageNum:'7'})"/>
            <uix:styledText textBinding="HEADING_CMSX@obBundle@servletRequest"
                            styleClass="OraInstructionText" />
            <uix:tableLayout cellSpacing="5" width="80%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="NAME@obBundle@servletRequest"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText textBinding="dn@devicesBean@obBean@servletRequest"
                       styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:styledText textBinding="TYPE@obBundle@servletRequest"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="75%">
                  <uix:styledText textBinding="ocn@devicesBean@obBean@servletRequest"
                                  styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

       <uix:switcher childNameBinding="switch@obBean@servletRequest">
         <uix:case name="inv">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="status"
                                    textBinding="STATUS@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                    <uix:choice name="status"
                                id="status"
                                selectedValueBinding="status@obBean@servletRequest">
                      <uix:option textBinding="MS_STATUS_IS@obBundle@servletRequest" value="is"/>
                      <uix:option textBinding="MS_STATUS_NIS@obBundle@servletRequest" value="nis"/>
                    </uix:choice>
                    <uix:spacer width="5" />
                    <uix:checkBox name="dii" id="dii" value="yes" />
                    <uix:styledText labeledNodeId="dii"
                                    textBinding="DEV_IS_INV@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
               <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="STATUS_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
         </uix:case>
         <uix:case name="noinv">
              <uix:tableLayout cellSpacing="5" width="80%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText labeledNodeId="status"
                                    textBinding="STATUS@obBundle@servletRequest"
                                    styleClass="OraInstructionText" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" width="75%">
                    <uix:choice name="status"
                                id="status"
                                selectedValueBinding="status@obBean@servletRequest">
                      <uix:option textBinding="MS_STATUS_IS@obBundle@servletRequest" value="is"/>
                      <uix:option textBinding="MS_STATUS_NIS@obBundle@servletRequest" value="nis"/>
                    </uix:choice>
                  </uix:cellFormat>
                </uix:rowLayout>
               <uix:rowLayout>
                 <uix:cellFormat hAlign="left">
                 </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="STATUS_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>

       <uix:switcher childNameBinding="dtype@devicesBean@obBean@servletRequest">
         <uix:case name="tape">
          <uix:tableLayout cellSpacing="5" width="80%">

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="library" 
                  textBinding="LIBRARY_TYPE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left" width="75%">
              <oem:choice
                   name="library"
                   id="library"
                   selectedValueBinding="library@devicesBean@obBean@servletRequest"
                   optionsBinding="obAdminHosts@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="LIBRARY_TYPE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
               <uix:styledText 
                  labeledNodeId="dte" 
                  textBinding="DTE@obBundle@servletRequest" 
                  styleClass="OraInstructionText" />
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:textInput name="dte"
                      id="dte"
                      columns="5"
                      textBinding="dte@devicesBean@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
               <uix:styledText
                 textBinding="DTE_TIP@obBundle@servletRequest"
                 styleClass="OraInlineInfoText"/>
             </uix:cellFormat>
           </uix:rowLayout>
          </uix:tableLayout>
         </uix:case>
        </uix:switcher>
      </uix:header>

    <uix:pageButtons>
      <uix:pageButtonBar>
                    <uix:flowLayout>
                      <uix:submitButton textBinding="CANCEL@obBundle@servletRequest"
                                        name="event"
                                        value="cancelMSDev"
                                        formName="foo"/>
                    </uix:flowLayout>
                    <uix:switcher childNameBinding="prev@obBean@servletRequest">
                      <uix:case name="yes">
                        <uix:flowLayout>
                          <uix:submitButton textBinding="PREVIOUS@obBundle@servletRequest"
                                            name="event"
                                            value="previousMSDev"
                                            formName="foo"/>
                        </uix:flowLayout>
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="next@obBean@servletRequest">
                      <uix:case name="yes">
                        <uix:flowLayout>
                          <uix:submitButton textBinding="NEXT@obBundle@servletRequest"
                                            name="event"
                                            value="nextMSDev"
                                            formName="foo"/>
                        </uix:flowLayout>
                      </uix:case>
                    </uix:switcher>
                    <uix:flowLayout>
                      <uix:submitButton textBinding="FINISH@obBundle@servletRequest"
                                        name="event"
                                        value="finishMSDev"
                                        formName="foo"/>
                    </uix:flowLayout>
                  </uix:pageButtonBar>
                </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
