<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="RESTORE_SELECT_HOSTS@obBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <%-- Cannot use the form tag with the listOfValues tag (though
          -- it is ok to use the formValue tag).  The error encountered
          -- when using the form tag with the listOfValues tag is:
          -- "cannot nest form elements"
        --%>
          <uix:listOfValues
              titleBinding="RESTORE_SOURCE_HOSTS@obBundle@servletRequest"
              searchTextBinding="searchFilter@obHostDataSourceBean@servletRequest"
              shortDescBinding="RESTORE_SOURCE_HOSTS@obBundle@servletRequest"
              >
            <uix:formValue name="pageNum" value="101"/>
            <uix:formValue
                name="pageName"
                value="database/ob/obHostLov.jsp"/>
            <uix:formValue
                name="lovName"
                valueBinding="lovName@obHostDataSourceBean@servletRequest"/>
            <uix:formValue
                name="source"
                valueBinding="source@obHostDataSourceBean@servletRequest"/>
            <uix:searchInstructions>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="SELECT_AS_TEXT@obBundle@servletRequest"/>
            </uix:searchInstructions>
            <uix:contents>
              <oem:table
                width="100%"
                blockSize="10"
                formSubmitted="true"
                proxied="true"
                id="obHostUI"
                name="obHostUI"
                dataSourceProp="obHostUI"
                beanKey="obHostDataSourceBean"
                copyParams="target,type,adminName"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:switcher childNameBinding="singleSelect@obHostDataSourceBean@servletRequest">
                  <uix:case name="true">
                    <uix:singleSelection
                         shortDescBinding="SELECT@obBundle@servletRequest"
                         selectedIndexBinding="selectedHostIndex@obHostDataSourceBean@servletRequest">
                    </uix:singleSelection>
                  </uix:case>
                  <uix:case name="false">
                    <uix:multipleSelection
                         shortDescBinding="SELECT@obBundle@servletRequest"
                         selectionBinding="selection@obHostDataSourceBean@servletRequest">
                    </uix:multipleSelection>
                  </uix:case>
                 </uix:switcher>
                </uix:tableSelection>
              </oem:table>
            </uix:contents>
          </uix:listOfValues>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

