<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob"  copyParams="target,type"> 

    <uix:formValue name="pageNum" value="53"/>
    <uix:formValue name="prevpage" value="jobs"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="JOBS_PAGE_TITLE@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="JOBS_SUMMARY@obBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="middle">
              <uix:rowLayout>
                <%@ include file="refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:cellFormat>
         </uix:rowLayout>
        <uix:stackLayout>
        <uix:contents>
        <uix:spacer width="10px"/>

         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="middle" width="2%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="VIEW@obBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" vAlign="middle">
                  <uix:spacer width="2px"/>
                    <uix:choice name="viewOptions"
                        onChange="submitForm('foo', true, {'event':'manageJobs'})"
                        shortDescBinding="SELECT@obBundle@servletRequest"
                        selectedValueBinding="optype@obBean@servletRequest">
                        <uix:option textBinding="ALL_JOBS@obBundle@servletRequest" value="all"/>
                        <uix:option textBinding="ACTIVEJ@obBundle@servletRequest" value="active"/>
                        <uix:option textBinding="USER_INPUT_REQUESTED@obBundle@servletRequest" value="inputrequested"/>
                        <uix:option textBinding="PENDING@obBundle@servletRequest" value="pending"/>
                        <uix:option textBinding="COMPLETE@obBundle@servletRequest" value="complete"/>
                        <uix:option textBinding="FAILED@obBundle@servletRequest" value="failed"/>
                    </uix:choice>
            </uix:cellFormat>
         </uix:rowLayout>
              <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                id="jobUI"
                name="jobUI"
                dataSourceProp="jobUI"
                beanKey="jobDataSourceBean"
                copyParams="target,type"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedScan@scanBean@obBean@servletRequest">
                  <uix:submitButton
                      formName="foo"
                      textBinding="VIEW_TRANSCRIPT@obBundle@servletRequest"
                      name="event"
                      value="viewTranscript"/>
                  <uix:spacer width="2px"/>
                  <uix:submitButton
                      formName="foo"
                      textBinding="RUN@obBundle@servletRequest"
                      name="event"
                      value="runJob"/>
                  <uix:spacer width="2px"/>
                  <uix:submitButton
                      formName="foo"
                      textBinding="CANCEL_JOB@obBundle@servletRequest"
                      name="event"
                      value="cancelJob"/>
                  <uix:spacer width="2px"/>
                  <uix:submitButton
                      formName="foo"
                      textBinding="REMOVE@obBundle@servletRequest"
                      name="event"
                      value="confirmRemoveJob"/>
                  <uix:spacer width="2px"/>
                  <uix:submitButton
                      formName="foo"
                      textBinding="PICK_REPORT@obBundle@servletRequest"
                      name="event"
                      value="pickReport"/>
                  <uix:spacer width="2px"/>
                  <uix:submitButton
                      formName="foo"
                      textBinding="DIST_REPORT@obBundle@servletRequest"
                      name="event"
                      value="distReport"/>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>
          </uix:contents>
          </uix:stackLayout>
         <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText" 
                                  textBinding="PICK_REPORT_TIP@obBundle@servletRequest"/>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText" 
                                  textBinding="DIST_REPORT_TIP@obBundle@servletRequest"/>
                </uix:tip>
              </uix:cellFormat>
         </uix:rowLayout>
        </uix:header>
        <uix:spacer height="10"/>

        <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="70%">
            <uix:rowLayout>
               <uix:cellFormat hAlign="left">
                 <uix:link textBinding="DEVICES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'7'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left">
                 <uix:link textBinding="SCANS_PAGE_TITLE@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'52'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left">
                 <uix:link textBinding="LOCATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'50'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left">
                 <uix:link textBinding="MEDIA_FAMILIES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'2'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left">
                 <uix:link textBinding="ROTATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'51'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left">
                 <uix:link textBinding="DUPLICATION_POLICY@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'61'})"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>


      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
