<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="oldEvent" valueBinding="optype@obBean@servletRequest"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="pageNum" value="58"/>
    <uix:formValue name="loc" valueBinding="location@locationBean@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="LOCATION_REPORTS@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="3">
          <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="100%" columnSpan="2">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="LOCATION_REPORTS_SUMMARY@obBundle@servletRequest" />
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
         <uix:spacer height="10" />
         <uix:switcher childNameBinding="reportType@locationBean@obBean@servletRequest">
           <uix:case name="schedule">
            <uix:tableLayout cellSpacing="5">
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="middle" width="2%">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="TYPE@obBundle@servletRequest"/>
                   <uix:spacer width="2"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="5%">
                    <uix:spacer width="2px"/>
                    <uix:choice name="reportType"
                        onChange="submitForm('foo', true, {'event':'locationReport'})"
                        shortDescBinding="TYPE@obBundle@servletRequest"
                        disabledBinding="readOnly@obBean@servletRequest"
                        selectedValueBinding="reportType@locationBean@obBean@servletRequest">
                        <uix:option textBinding="LOCATION_REPORT@obBundle@servletRequest" value="location"/>
                        <uix:option textBinding="EXCEPTION_REPORT@obBundle@servletRequest" value="exception"/>
                        <uix:option textBinding="SCHEDULE_REPORT@obBundle@servletRequest" value="schedule"/>
                    </uix:choice>
              </uix:cellFormat>
              <uix:cellFormat hAlign="right" width="5%">
                  <uix:styledText labeledNodeId="from" textBinding="REPORT_FROM@obBundle@servletRequest" styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="3%">
                   <uix:spacer width="2"/>
                   <uix:messageDateField id="from" name="fromDate" columns="8" valueBinding="fromDate@locationBean@obBean@servletRequest">
                     <uix:onSubmitValidater>
                       <uix:date dateStyle="medium"/>
                     </uix:onSubmitValidater>
                   </uix:messageDateField>
                </uix:cellFormat>
              <uix:cellFormat hAlign="right" width="3%">
                  <uix:styledText labeledNodeId="to" textBinding="REPORT_TO@obBundle@servletRequest" styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" width="3%">
                   <uix:spacer width="2"/>
                   <uix:messageDateField id="to" name="toDate" columns="8" valueBinding="toDate@locationBean@obBean@servletRequest">
                     <uix:onSubmitValidater>
                       <uix:date dateStyle="medium"/>
                     </uix:onSubmitValidater>
                   </uix:messageDateField>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" vAlign="middle">
                    <uix:spacer width="5px"/>
                    <uix:submitButton textBinding="GO@obBundle@servletRequest"
                                      name="event"
                                      value="locationReport"
                                      formName="foo"/>
                </uix:cellFormat>
            </uix:rowLayout>
            </uix:tableLayout>
           </uix:case>
           <uix:default>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="middle" width="2%">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="TYPE@obBundle@servletRequest"/>
                    <uix:spacer width="2px"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" vAlign="middle">
                    <uix:spacer width="2px"/>
                    <uix:choice name="reportType"
                        onChange="submitForm('foo', true, {'event':'locationReport'})"
                        shortDescBinding="TYPE@obBundle@servletRequest"
                        disabledBinding="readOnly@obBean@servletRequest"
                        selectedValueBinding="reportType@locationBean@obBean@servletRequest">
                        <uix:option textBinding="LOCATION_REPORT@obBundle@servletRequest" value="location"/>
                        <uix:option textBinding="EXCEPTION_REPORT@obBundle@servletRequest" value="exception"/>
                        <uix:option textBinding="SCHEDULE_REPORT@obBundle@servletRequest" value="schedule"/>
                    </uix:choice>
              </uix:cellFormat>
            </uix:rowLayout>
           </uix:default>
         </uix:switcher>
        <uix:stackLayout>
        <uix:spacer height="2"/>
        <uix:contents>
            <oem:table
                width="75%"
                blockSize="25"
                formSubmitted="true"
                id="reportUI"
                name="reportUI"
                dataSourceProp="reportUI"
                beanKey="locationReportDataSourceBean"
                copyParams="target,type"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
              </oem:table>
        </uix:contents>
        </uix:stackLayout>
     </uix:header>

      <uix:pageButtons>
        <uix:pageButtonBar>
                    <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                      name="event"
                                      value="manageLocations"
                                      formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
