<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="7"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="MANAGE_DEVICES@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="HEADING_MD@obBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="middle">
              <uix:rowLayout>
                <%@ include file="refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:cellFormat>
         </uix:rowLayout>
         <uix:spacer height="10" />
         <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" vAlign="middle" columnSpan="3">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="VIEW_DEVICE@obBundle@servletRequest"/>
                    <uix:spacer width="2"/>
                    <uix:choice name="deviceListOptions"
                        onChange="submitForm('foo', true, {'event':'manageDevices'})"
                        shortDescBinding="VIEW_DEVICE@obBundle@servletRequest"
                        disabledBinding="readOnly@obBean@servletRequest"
                        selectedValueBinding="optype@obBean@servletRequest">
                        <uix:option textBinding="PROBLEM_DEVICES@obBundle@servletRequest" value="probDevices"/>
                        <uix:option textBinding="ACTIVE_DEVICES@obBundle@servletRequest" value="activeDevices"/>
                        <uix:option textBinding="ALL_DEVICES@obBundle@servletRequest" value="allDevices"/>
                    </uix:choice>
              <uix:spacer width="5"/>
                    <uix:submitButton 
                         textBinding="CREATE_LIBRARY@obBundle@servletRequest" 
                         name="event" 
                         value="createLib"/>
              <uix:spacer width="5"/>
                    <uix:submitButton 
                         textBinding="CREATE_DRIVE@obBundle@servletRequest" 
                         name="event" 
                         value="createDrive"/>
              </uix:cellFormat>

         </uix:rowLayout>


        <uix:stackLayout>
        <uix:contents>

               <uix:hGrid id="devicesUI"
                    width="100%"
                    formSubmitted="true"
                    treeDataBinding="treeData@devicesDataSourceBean@servletRequest"
                    childBlockSize="10"
                    columnHeaderDataBinding="columnHeaderData@devicesDataSourceBean@servletRequest"
                    summaryBinding="MANAGE_DEVICES@obBundle@servletRequest"
                    columnFormatsBinding="columnFormatData@devicesDataSourceBean@servletRequest"
                    alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest"
                    proxyBinding="proxy@servletRequest">

                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="NAME@obBundle@servletRequest"
                          sortableBinding="firstColSortState@devicesDataSourceBean@servletRequest"
                          valueBinding="firstColSortIndex@devicesDataSourceBean@servletRequest"/>
                      </uix:columnHeader>
                    </uix:column>
                  </uix:nodeStamp>
                                                                                
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text"
                      sortableBinding="sortState"
                      valueBinding="sortIndex"/>
                  </uix:columnHeaderStamp>

                  <uix:styledText textBinding="type"/>
                  <uix:styledText textBinding="dte"/>
                  <uix:image      sourceBinding="status" shortDescBinding="STATUS@obBundle@servletRequest"/>
                  <uix:styledText textBinding="state"/>
                  <uix:link       textBinding="cleantitle" destinationBinding="clean"/>
                  <uix:styledText textBinding="host"/>
                  <uix:styledText textBinding="vendor"/>
                  <uix:styledText textBinding="firmware"/>

                  <%-- Support for selected item. --%>
                  <uix:formValue name="itemName" valueBinding="text"/>

                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedD@devicesBean@obBean@servletRequest"
                       disabledBinding="disabled">
                    <uix:contents>
                        <uix:styledText styleClass="OraPromptText"
                                       textBinding="ACTIONS@obBundle@servletRequest"/>
                      <uix:spacer width="2"/>
                      <uix:choice name="deviceAction"
                        shortDescBinding="ACTIONS@obBundle@servletRequest"
                        disabledBinding="readOnly@obBean@servletRequest"
                        selectedValueBinding="devOp@devicesBean@obBean@servletRequest">
                        <uix:option textBinding="VIEW_DEVICE_LIST@obBundle@servletRequest" 
                                    value="showDeviceList"/>
                        <uix:option textBinding="VIEW_DEVICE_LOG@obBundle@servletRequest" 
                                    value="showDeviceOutput"/>
                        <uix:option textBinding="PING_DEV@obBundle@servletRequest" 
                                    value="pingdev"/>
                        <uix:option textBinding="INVENTORY@obBundle@servletRequest" 
                                    value="inventory"/>
                        <uix:option textBinding="IMPORT_VOL@obBundle@servletRequest" 
                                    value="importvol"/>
                        <uix:option textBinding="EXPORT_VOL@obBundle@servletRequest" 
                                    value="exportvol"/>
                        <uix:option textBinding="EXTRACT_VOL@obBundle@servletRequest" 
                                    value="extractvol"/>
                        <uix:option textBinding="INSERT_VOL@obBundle@servletRequest" 
                                    value="insertvol"/>
                        <uix:option textBinding="MOVE_VOL@obBundle@servletRequest" 
                                    value="movevol"/>
                      </uix:choice>
                    <uix:submitButton
                      formName="foo"
                      textBinding="GO@obBundle@servletRequest"
                      name="event"
                      value="deviceAction"/>
                    <uix:spacer width="5"/>
                        <uix:styledText styleClass="OraPromptText"
                                       textBinding="DRIVE_ACTION@obBundle@servletRequest"/>
                      <uix:spacer width="2"/>
                      <uix:choice name="deviceAction2"
                        shortDescBinding="DRIVE_ACTION@obBundle@servletRequest"
                        disabledBinding="readOnly@obBean@servletRequest"
                        selectedValueBinding="devOp@devicesBean@obBean@servletRequest">
                        <uix:option textBinding="REUSE_VOL@obBundle@servletRequest" 
                                    value="reuse"/>
                        <uix:option textBinding="BORROW_DEVICE@obBundle@servletRequest" 
                                    value="borrow"/>
                        <uix:option textBinding="RETURN_DEVICE@obBundle@servletRequest" 
                                    value="return"/>
                        <uix:option textBinding="MOUNT@obBundle@servletRequest" 
                                    value="mountdev"/>
                        <uix:option textBinding="UNMOUNT@obBundle@servletRequest" 
                                    value="unmountdev"/>
                        <uix:option textBinding="IDENTIFY_VOL@obBundle@servletRequest" 
                                    value="identifyvol"/>
                        <uix:option textBinding="LABEL_VOL@obBundle@servletRequest" 
                                    value="labelvol"/>
                        <uix:option textBinding="LOAD_VOL@obBundle@servletRequest" 
                                    value="loadvol"/>
                        <uix:option textBinding="UNLABEL_VOL@obBundle@servletRequest" 
                                    value="unlabelvol"/>
                        <uix:option textBinding="UNLOAD_VOL@obBundle@servletRequest" 
                                    value="unloadvol"/>
                        <uix:option textBinding="CLEAN_DRIVE@obBundle@servletRequest" 
                                    value="clean"/>
                      </uix:choice>
                    <uix:spacer width="2"/>
                    <uix:submitButton
                      formName="foo"
                      textBinding="GO@obBundle@servletRequest"
                      name="event"
                      value="deviceAction2"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton
                      formName="foo"
                      textBinding="EDIT@obBundle@servletRequest"
                      name="event"
                      value="editDevice"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton
                      formName="foo"
                      textBinding="REMOVE@obBundle@servletRequest"
                      name="event"
                      value="confirmRemoveDevice"/>
                    </uix:contents>
                  </uix:singleSelection>
                </uix:tableSelection>
              </uix:hGrid>
          </uix:contents>
          </uix:stackLayout>
        </uix:header>
        <uix:spacer height="10"/>

        <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="70%">
            <uix:rowLayout>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="MANAGE_VOLUMES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'5'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="MEDIA_FAMILIES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'2'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="LOCATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'50'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left"  width="30%" wrappingDisabled="true">
                 <uix:link textBinding="ROTATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'51'})"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>
      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
