<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="9"/>
    <uix:formValue name="parentVolume" valueBinding="parentVolume@sectionsBean@obBean@servletRequest"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="MANAGE_SECTIONS@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="HEADING_SC@obBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="top">
              <uix:rowLayout>
                <%@ include file="refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:cellFormat>
         </uix:rowLayout>

          <uix:header textBinding="SECTIONS@obBundle@servletRequest">
            <uix:tableLayout>
              <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                name="sectionsUI"
                id="sectionsUI"
                dataSourceProp="sectionsUI"
                beanKey="sectionsDataSourceBean"
                copyParams="target,type"
                summaryBinding="MANAGE_SECTIONS@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
              </oem:table>
            </uix:tableLayout>
          </uix:header>
        </uix:header>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:flowLayout>
              <uix:submitButton textBinding="OK@obBundle@servletRequest"
                                name="event"
                                value="manageVolumes"
                                formName="foo"/>
            </uix:flowLayout>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
