<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="5"/>

     <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="MANAGE_VOLUMES@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="HEADING_MV@obBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="top">
              <uix:rowLayout>
                <%@ include file="refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:cellFormat>
         </uix:rowLayout>

         <uix:header textBinding="SEARCH@obBundle@servletRequest" >
         <uix:tableLayout width="100%" cellSpacing="5">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="5%" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    labeledNodeId="searchCriteria"
                    textBinding="FILTER@obBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:choice name="searchCriteria"
                     shortDescBinding="FILTER@obBundle@servletRequest"
                     selectedValueBinding="searchCriteria@volumesBean@obBean@servletRequest" >
                  <uix:option textBinding="MFS@obBundle@servletRequest" value="mfs"/>
                  <uix:option textBinding="VOLUME_ID@obBundle@servletRequest" value="vid"/>
                  <uix:option textBinding="VOLUME_SET_ID@obBundle@servletRequest" value="vsid"/>
                  <uix:option textBinding="BARCODE@obBundle@servletRequest" value="barcode"/>
                  <uix:option textBinding="ATTRIBUTES@obBundle@servletRequest" value="attr"/>
                  <uix:option textBinding="ALL@obBundle@servletRequest" value="all"/>
                </uix:choice>
                                                                                                                       
                <uix:textInput id="searchCriteria" name="searchString" columns="30"
                  textBinding="searchSections@volumesBean@obBean@servletRequest" />
                <uix:submitButton name="event" value="manageVolumes"
                  textBinding="GO@obBundle@servletRequest" />
              </uix:cellFormat>
                                                                                                                       
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" wrappingDisabled="true">
                    <uix:styledText textBinding="VOLUME_HINT@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

          <uix:header textBinding="RESULTS@obBundle@servletRequest">
             <uix:spacer width="6"/>
              <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                name="volumesUI"
                id="volumesUI"
                dataSourceProp="volumesUI"
                beanKey="volumesDataSourceBean"
                copyParams="target,type"
                summaryBinding="RESULTS@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedV@volumesBean@obBean@servletRequest">
                    <uix:submitButton
                      formName="foo"
                      textBinding="MANAGE_SECTIONS@obBundle@servletRequest"
                      name="volumeCommand"
                      value="manageSections"/>
                    <uix:spacer width="2"/>
                    <uix:submitButton
                      formName="foo"
                      textBinding="RECALL@obBundle@servletRequest"
                      name="volumeCommand"
                      value="recall"/>
                    <uix:spacer width="2"/>
                    <uix:submitButton
                      formName="foo"
                      textBinding="RELEASE@obBundle@servletRequest"
                      name="volumeCommand"
                      value="releaseVolume"/>
                    <uix:spacer width="2"/>
                    <uix:submitButton
                      formName="foo"
                      textBinding="EDIT@obBundle@servletRequest"
                      name="volumeCommand"
                      value="editvol"/>
                    <uix:spacer width="2"/>
                    <uix:submitButton
                      formName="foo"
                      textBinding="DUPLICATE_VOLUME@obBundle@servletRequest"
                      name="volumeCommand"
                      value="duplicate"/>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>
           <uix:tableLayout>
             <uix:rowLayout width="80%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="EXPIRES_TIP@obBundle@servletRequest" />
                </uix:tip>
              </uix:cellFormat>

           </uix:rowLayout>
           <uix:rowLayout width="80%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="CLOSES_TIP@obBundle@servletRequest" />
                </uix:tip>
              </uix:cellFormat>

           </uix:rowLayout>
           </uix:tableLayout>
          </uix:header>
        </uix:header>
        <uix:spacer height="10"/>

        <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="70%">
            <uix:rowLayout>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="DEVICES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'7'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="MEDIA_FAMILIES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'2'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="LOCATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'50'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="ROTATIONS@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'51'})"/>
               </uix:cellFormat>
               <uix:cellFormat hAlign="left" wrappingDisabled="true">
                 <uix:link textBinding="DUPLICATION_POLICY@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'61'})"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>
        <uix:pageButtons>
            <uix:pageButtonBar  renderedBinding="presentReturnEvent@volumesBean@obBean@servletRequest">
                    <uix:submitButton textBinding="RETURN@obBundle@servletRequest"
                                      name="event"
                                      valueBinding="returnEvent@volumesBean@obBean@servletRequest"
                                      formName="foo"/>
             </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
