<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob"  copyParams="target,type"> 

    <uix:formValue name="pageNum" value="1"/>

     <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               destTableBinding="infoUrls@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               destTableBinding="errorUrls@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="MEDIASERVERS@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="HEADING_MS@obBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="middle">
              <uix:rowLayout>
                <%@ include file="refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:cellFormat>
         </uix:rowLayout>

         <uix:rowLayout width="100%">
           <uix:cellFormat hAlign="right" vAlign="top" width="100%">
             <uix:submitButton textBinding="ADD@obBundle@servletRequest" name="event" value="createMS"/>
           </uix:cellFormat>
         </uix:rowLayout>
        <uix:stackLayout>
        <uix:contents>


              <oem:table
                width="100%"
                blockSize="25"
                formSubmitted="true"
                name="mediaserverUI"
                id="mediaserverUI"
                dataSourceProp="mediaserverUI"
                beanKey="mediaserverDataSourceBean"
                copyParams="target,type"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@obBundle@servletRequest">
                <uix:tableSelection>
                  <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedMS@mediaserverBean@obBean@servletRequest">
                    <uix:contents>
                      <uix:spacer width="2"/>
                        <uix:styledText styleClass="OraPromptText"
                                       textBinding="ACTIONS@obBundle@servletRequest"/>
                      <uix:spacer width="2"/>
                      <uix:choice name="msActions"
                        shortDescBinding="ACTIONS@obBundle@servletRequest"
                        disabledBinding="readOnly@obBean@servletRequest"
                        selectedValueBinding="optype@obBean@servletRequest">
                        <uix:option textBinding="PING_HOST@obBundle@servletRequest"
                                    value="pingHost"/>
                        <uix:option textBinding="UPDATE_HOST@obBundle@servletRequest"
                                    value="updateHost"/>
                        <uix:option textBinding="DISCOVER_DEVICES@obBundle@servletRequest"
                                    value="discoverDevices"/>
                        <uix:option textBinding="AUDMS@obBundle@servletRequest"
                                    value="audms"/>
                      </uix:choice>
                      <uix:submitButton formName="foo"
                                        textBinding="GO@obBundle@servletRequest"
                                        name="event"
                                        value="msActions"/>
                      <uix:spacer width="5" />
                      <uix:submitButton formName="foo"
                                        textBinding="EDIT@obBundle@servletRequest"
                                       name="event"
                                       value="editMediaserver"/>
                      <uix:spacer width="5" />
                      <uix:submitButton formName="foo"
                                        textBinding="REMOVE@obBundle@servletRequest"
                                        name="event"
                                        value="confirmRemoveMediaserver"/>
                    </uix:contents>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>
          </uix:contents>
          </uix:stackLayout>
         <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="NATIVE_TIP@obBundle@servletRequest" />
                </uix:tip>
              </uix:cellFormat>

         </uix:rowLayout>
         <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" vAlign="top" width="100%">
                <uix:tip>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="NDMP_TIP@obBundle@servletRequest" />
                </uix:tip>
              </uix:cellFormat>

         </uix:rowLayout>
        </uix:header>
        <uix:spacer height="10"/>

        <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest">
          <uix:tableLayout cellSpacing="5" width="70%">
            <uix:rowLayout>
               <uix:cellFormat hAlign="left"  width="30%">
                 <uix:link textBinding="DEVICES@obBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'doLoad',pageNum:'7'})"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:tableLayout>
        </uix:header>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
