<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsrestore" copyParams="target,type">
    <uix:formValue name="pageNum" value="97"/>

     <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/ob/restoreTrainMessages.jspf" %>

<uix:header textBinding="BACKUP_VERSIONS@obBundle@servletRequest">
  <uix:stackLayout>
   <uix:labeledFieldLayout width="75%">
      <uix:messagePrompt promptBinding="NAME@obBundle@servletRequest"/>
      <uix:styledText id="fileName" styleClass="OraInstructionText" textBinding="nameWithoutSeparator@originalVersion@bkpVersionDataSourceBean@servletRequest"/>
      <uix:messagePrompt promptBinding="PATH@obBundle@servletRequest"/>
      <uix:styledText id="filePath" styleClass="OraInstructionText" textBinding="path@originalVersion@bkpVersionDataSourceBean@servletRequest"/>
      <uix:messagePrompt promptBinding="HOST@obBundle@servletRequest"/>
      <uix:styledText id="fileHost" styleClass="OraInstructionText" textBinding="fromHost@originalVersion@bkpVersionDataSourceBean@servletRequest"/>
      <uix:messagePrompt promptBinding="VERSION_TO_RESTORE@obBundle@servletRequest"/>
      <uix:styledText id="fileVersion" styleClass="OraInstructionText" textBinding="backupDateTimeStr@originalVersion@bkpVersionDataSourceBean@servletRequest"/>
  </uix:labeledFieldLayout>
  <uix:spacer height="5px"/>
  <uix:header textBinding="SEARCH@obBundle@servletRequest">
          <uix:messageChoice name="filterBackupDuration" 
                      promptBinding="LBL_BACKUP_PERIOD@obBundle@servletRequest"
                      onChange="submitForm('foo',true, {event:'filterFileBkps'})"
                      selectedValueBinding="filterBackupDuration@bkpVersionDataSourceBean@servletRequest">
              <uix:option textBinding="ALL@obBundle@servletRequest" value="all"/>
              <uix:option textBinding="WITHIN_8_HOURS@obBundle@servletRequest" value="8h"/>
              <uix:option textBinding="WITHIN_1_DAY@obBundle@servletRequest" value="1d"/>
              <uix:option textBinding="WITHIN_2_DAY@obBundle@servletRequest" value="2d"/>
              <uix:option textBinding="WITHIN_1_WEEK@obBundle@servletRequest" value="1w"/>
              <uix:option textBinding="WITHIN_1_MONTH@obBundle@servletRequest" value="1m"/>
          </uix:messageChoice>
  </uix:header>

  <uix:header textBinding="RESULTS@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="100%">
              <uix:styledText styleClass="OraInstructionText" 
                    textBinding="BACKUP_VERSIONS_INSTR@obBundle@servletRequest" />
            </uix:cellFormat>
         </uix:rowLayout>
         <uix:spacer height="10px"/>
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left">
              <oem:table
                width="80%"
                blockSize="10"
                formSubmitted="true"
                id="bkpVersionUI"
                name="bkpVersionUI"
                dataSourceProp="bkpVersionUI"
                beanKey="bkpVersionDataSourceBean"
                copyParams="target,type,adminName"
                summaryBinding="SELECT@obBundle@servletRequest"
                alternateTextBinding="NONE@obBundle@servletRequest">
                 <uix:tableSelection >
                   <uix:singleSelection
                       shortDescBinding="SELECT@obBundle@servletRequest"
                       selectedIndexBinding="selectedBackupIndex@bkpVersionDataSourceBean@servletRequest">
                   </uix:singleSelection>
                 </uix:tableSelection>
               </oem:table>

            </uix:cellFormat>
         </uix:rowLayout>
    </uix:header>
  </uix:stackLayout>
</uix:header>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancelFileBkp" shortDescBinding="CANCEL@obBundle@servletRequest"/>
                <uix:submitButton textBinding="OK@obBundle@servletRequest" formName="foo" name="event" value="selectAltFileBkp" shortDescBinding="OK@obBundle@servletRequest"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

