<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/ob/fsrestore" copyParams="target,type"> 
    <uix:formValue name="pageNum" value="92"/>
    <uix:formValue name="source"/>
    <uix:formValue name="value"/>

     <uix:pageLayout titleBinding="pageHeader@fsRestoreBean@servletRequest">
       <%@ include file="/database/global.jspf" %>
       <%@ include file="/database/ob/restoreTrainMessages.jspf" %>
       <uix:tableLayout  renderedBinding="restoreByBackup@fsRestoreBean@servletRequest">
         <uix:rowLayout width="100%">
           <uix:cellFormat>
             <uix:messageRadioButton name="fileSelectionMode" value="all"
                  selectedValueBinding="fileSelectionMode@fsRestoreBean@servletRequest"
                  onChange="submitForm('foo',true,{event:'switchFileSelMode'})"
                  textBinding="RESTORE_ALL_BACKUP_CONTENTS@obBundle@servletRequest"
                  styleClass="OraInstructionText" />
           </uix:cellFormat>
           <uix:cellFormat>
             <uix:spacer width="5px"/>
           </uix:cellFormat>
           <uix:cellFormat>
             <uix:messageRadioButton name="fileSelectionMode" value="specific"
                  selectedValueBinding="fileSelectionMode@fsRestoreBean@servletRequest"
                  onChange="submitForm('foo',true,{event:'switchFileSelMode'})"
                  textBinding="RESTORE_ADD_MORE_FILES@obBundle@servletRequest"
                  styleClass="OraInstructionText" />
           </uix:cellFormat>
        </uix:rowLayout>
         <uix:rowLayout width="100%">
           <uix:cellFormat>
              <uix:spacer width="10px"/>
           </uix:cellFormat>
        </uix:rowLayout>
       </uix:tableLayout>
       <uix:tableLayout>
         <uix:rowLayout>
           <uix:cellFormat width="50%" hAlign="right" vAlign="top" renderedBinding="showBrowsePanel@fsRestoreBean@servletRequest">
              <%@ include file="/database/ob/obBrowseCatalogInc.jspf" %>
           </uix:cellFormat>
           <uix:cellFormat hAlign="center"  vAlign="middle" width="5%"  renderedBinding="showBrowsePanel@fsRestoreBean@servletRequest">
           <uix:stackLayout>
               <uix:image source="/em/images/database/ob/shuttle_move_enabled.gif"
                          destination="javascript:submitForm('foo',true,{event:'addToSelection'})"
                          shortDescBinding="ADD@obBundle@servletRequest"/>
               <uix:styledText styleClass="OraInlineInfoText" textBinding="ADD@obBundle@servletRequest"/>
               <uix:spacer height="5px"/>
               <uix:image source="/em/images/database/ob/shuttle_remove_enabled.gif"
                          destination="javascript:submitForm('foo',true,{event:'removeFromSelection'})"
                          shortDescBinding="REMOVE@obBundle@servletRequest"/>
               <uix:styledText styleClass="OraInlineInfoText" textBinding="REMOVE@obBundle@servletRequest"/>

           </uix:stackLayout>
           </uix:cellFormat>
           <uix:cellFormat width="45%" vAlign="top">
             <uix:contentContainer textBinding="RESTORE_CURRENT_SELECTION@obBundle@servletRequest" width="100%" >
                        <oem:table
                             width="100%"
                             blockSize="10"
                             formSubmitted="true"
                             id="restoreSelectionUI"
                             name="restoreSelectionUI"
                             dataSourceProp="restoreSelectionUI"
                             beanKey="restoreSelectionSourceBean"
                             summaryBinding="SELECT@obBundle@servletRequest"
                             alternateTextBinding="NONE_UC@obBundle@servletRequest">
                             <uix:tableSelection>
                               <uix:multipleSelection
                                    shortDescBinding="SELECT_TO_REMOVE@obBundle@servletRequest">
                               </uix:multipleSelection>
                             </uix:tableSelection>
                        </oem:table>
             </uix:contentContainer>
           
           </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
        <uix:spacer height="15px"/>
        <uix:tip  renderedBinding="showBrowsePanel@fsRestoreBean@servletRequest">
         <uix:stackLayout>
          <uix:styledText styleClass="OraInstructionText"
                 textBinding="DIR_NOT_RESTORABLE_TIP@obBundle@servletRequest"/>
          <uix:styledText styleClass="OraInstructionText"
                 textBinding="FILE_FILTER_TIP@obBundle@servletRequest"/>
         </uix:stackLayout>
        </uix:tip>
        <uix:spacer height="10px"/>
        <uix:header textBinding="LEGENDS@obBundle@servletRequest" size="2">
         <uix:tableLayout cellSpacing="5">
           <uix:rowLayout>
             <uix:cellFormat>
               <uix:image source="/em/images/database/ob/newupdateditem_status.gif" shortDescBinding="SELECTED_FOR_RESTORE_TIP@obBundle@servletRequest"/>
             </uix:cellFormat>
             <uix:cellFormat>
                <uix:styledText textBinding="SELECTED_FOR_RESTORE_TIP@obBundle@servletRequest" styleClass="OraInstructionText"/>
             </uix:cellFormat>
           </uix:rowLayout>
           <uix:rowLayout>
             <uix:cellFormat>
               <uix:image source="/em/images/database/ob/errorinmetric_status.gif" shortDescBinding="ERROR_DURING_BACKUP@obBundle@servletRequest"/>
             </uix:cellFormat>
             <uix:cellFormat>
                <uix:styledText textBinding="ERROR_DURING_BACKUP@obBundle@servletRequest" styleClass="OraInstructionText"/>
             </uix:cellFormat>
           </uix:rowLayout>
         </uix:tableLayout>
        </uix:header>
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@obBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@fsRestoreBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@fsRestoreBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
